/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import com.google.common.base.Function;
import forge.item.InventoryItem;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemColumn;
import forge.itemmanager.ItemColumnConfig;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.views.ItemCellRenderer;
import java.util.Map;
import javax.swing.table.TableColumn;

public class ItemTableColumn
extends TableColumn {
    private static final long serialVersionUID = 3749431834643427572L;
    private final ItemColumn itemColumn;

    public ItemTableColumn(ItemColumn itemColumn0) {
        this.itemColumn = itemColumn0;
        ColumnDef def = this.itemColumn.getConfig().getDef();
        this.setIdentifier((Object)def);
        this.setHeaderValue(def.shortName);
        int width = this.itemColumn.getConfig().getPreferredWidth();
        this.setPreferredWidth(width);
        if (def.isWidthFixed) {
            this.setMinWidth(width);
            this.setMaxWidth(width);
        }
        this.setCellRenderer(ItemCellRenderer.getColumnDefRenderer(def));
    }

    public ItemColumn getItemColumn() {
        return this.itemColumn;
    }

    public String getShortName() {
        return this.itemColumn.getConfig().getShortName();
    }

    public String getLongName() {
        return this.itemColumn.getConfig().getLongName();
    }

    public int getIndex() {
        return this.itemColumn.getConfig().getIndex();
    }

    public void setIndex(int index0) {
        this.itemColumn.getConfig().setIndex(index0);
    }

    public int getSortPriority() {
        return this.itemColumn.getConfig().getSortPriority();
    }

    public void setSortPriority(int sortPriority0) {
        this.itemColumn.getConfig().setSortPriority(sortPriority0);
    }

    public ItemColumnConfig.SortState getSortState() {
        return this.itemColumn.getConfig().getSortState();
    }

    public void setSortState(ItemColumnConfig.SortState state0) {
        this.itemColumn.getConfig().setSortState(state0);
    }

    public ItemColumnConfig.SortState getDefaultSortState() {
        return this.itemColumn.getConfig().getDefaultSortState();
    }

    public boolean isVisible() {
        return this.itemColumn.getConfig().isVisible();
    }

    public void setVisible(boolean visible0) {
        this.itemColumn.getConfig().setVisible(visible0);
    }

    public Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> getFnSort() {
        return this.itemColumn.getFnSort();
    }

    public Function<Map.Entry<? extends InventoryItem, Integer>, Object> getFnDisplay() {
        return this.itemColumn.getFnDisplay();
    }

    public void startResize() {
        if (this.itemColumn.getConfig().getDef().isWidthFixed) {
            this.setMinWidth(0);
            this.setMaxWidth(Integer.MAX_VALUE);
        }
    }

    public void endResize() {
        if (this.itemColumn.getConfig().getDef().isWidthFixed) {
            int width = this.getWidth();
            this.setMinWidth(width);
            this.setMaxWidth(width);
        }
    }

    public void updatePreferredWidth() {
        this.itemColumn.getConfig().setPreferredWidth(this.getWidth());
    }

    public String toString() {
        return this.itemColumn.toString();
    }

    public static void addColOverride(ItemManagerConfig config, Map<ColumnDef, ItemTableColumn> colOverrides, ColumnDef colDef) {
        ItemColumnConfig colConfig = config.getCols().get((Object)colDef);
        ItemTableColumn.addColOverride(config, colOverrides, colDef, colConfig.getFnSort(), colConfig.getFnDisplay());
    }

    public static void addColOverride(ItemManagerConfig config, Map<ColumnDef, ItemTableColumn> colOverrides, ColumnDef colDef, Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnSort0, Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnDisplay0) {
        colOverrides.put(colDef, new ItemTableColumn(new ItemColumn(config.getCols().get((Object)colDef), fnSort0, fnDisplay0)));
    }
}

