/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import forge.gui.MouseUtil;
import forge.item.InventoryItem;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemColumn;
import forge.itemmanager.ItemColumnConfig;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.ItemManagerModel;
import forge.itemmanager.views.ItemCellRenderer;
import forge.itemmanager.views.ItemTableColumn;
import forge.itemmanager.views.ItemView;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FCheckBox;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.lang3.StringUtils;

public final class ItemListView<T extends InventoryItem>
extends ItemView<T> {
    static final FSkin.SkinColor BACK_COLOR = FSkin.getColor(FSkin.Colors.CLR_ZEBRA);
    private static final FSkin.SkinColor FORE_COLOR = FSkin.getColor(FSkin.Colors.CLR_TEXT);
    private static final FSkin.SkinColor SEL_ACTIVE_COLOR = FSkin.getColor(FSkin.Colors.CLR_ACTIVE);
    private static final FSkin.SkinColor SEL_INACTIVE_COLOR = FSkin.getColor(FSkin.Colors.CLR_INACTIVE);
    private static final FSkin.SkinColor HEADER_BACK_COLOR = BACK_COLOR.getContrastColor(-10);
    static final FSkin.SkinColor ALT_ROW_COLOR = BACK_COLOR.getContrastColor(-20);
    private static final FSkin.SkinColor GRID_COLOR = BACK_COLOR.getContrastColor(20);
    private static final FSkin.SkinBorder HEADER_BORDER = new FSkin.CompoundSkinBorder((FSkin.SkinBorder)new FSkin.MatteSkinBorder(0, 0, 1, 1, GRID_COLOR), new EmptyBorder(0, 1, 0, 0));
    private static final FSkin.SkinFont ROW_FONT = FSkin.getFont();
    private static final int ROW_HEIGHT = 19;
    private final ItemTable table = new ItemTable();
    private final ItemTableModel tableModel;

    public ItemTableModel getTableModel() {
        return this.tableModel;
    }

    public ItemListView(ItemManager<T> itemManager0, ItemManagerModel<T> model0) {
        super(itemManager0, model0);
        this.tableModel = new ItemTableModel(model0);
        this.setAllowMultipleSelections(false);
        this.getPnlOptions().setVisible(false);
        this.table.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftDoubleClick(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                int clickedIndex = ItemListView.this.table.rowAtPoint(e.getPoint());
                ItemListView.this.itemManager.activateSelectedItems();
                if (clickedIndex >= ItemListView.this.table.getRowCount()) {
                    FMouseAdapter.forceMouseUp();
                }
            }

            @Override
            public void onRightClick(MouseEvent e) {
                ItemListView.this.itemManager.showContextMenu(e);
            }
        });
        this.table.setFocusTraversalKeys(0, null);
        this.table.setFocusTraversalKeys(1, null);
    }

    @Override
    public void setup(ItemManagerConfig config, Map<ColumnDef, ItemTableColumn> colOverrides) {
        Collection selectedItemsBefore = this.getSelectedItems();
        DefaultTableColumnModel colmodel = new DefaultTableColumnModel();
        LinkedList<ItemTableColumn> columns = new LinkedList<ItemTableColumn>();
        for (ItemColumnConfig colConfig : config.getCols().values()) {
            if (colOverrides == null || !colOverrides.containsKey((Object)colConfig.getDef())) {
                columns.add(new ItemTableColumn(new ItemColumn(colConfig)));
                continue;
            }
            columns.add(colOverrides.get((Object)colConfig.getDef()));
        }
        columns.sort(Comparator.comparingInt(ItemTableColumn::getIndex));
        boolean hideHeader = config.getCols().size() == 1 && config.getCols().containsKey((Object)ColumnDef.STRING);
        this.getPnlOptions().removeAll();
        if (config.getShowUniqueCardsOption()) {
            this.setUniqueCardsOnlyFilter();
        }
        int modelIndex = 0;
        for (ItemTableColumn col : columns) {
            col.setModelIndex(modelIndex++);
            if (col.isVisible()) {
                colmodel.addColumn(col);
            }
            if (hideHeader) continue;
            FCheckBox chkBox = new FCheckBox(StringUtils.isEmpty(col.getShortName()) ? col.getLongName() : col.getShortName(), col.isVisible());
            chkBox.setFont(ItemView.ROW_FONT);
            chkBox.setToolTipText(col.getLongName());
            chkBox.addChangeListener(arg0 -> {
                boolean visible = chkBox.isSelected();
                if (col.isVisible() == visible) {
                    return;
                }
                col.setVisible(visible);
                if (col.isVisible()) {
                    colmodel.addColumn(col);
                    int oldIndex = colmodel.getColumnCount() - 1;
                    int newIndex = col.getIndex();
                    for (int i = 0; i < col.getIndex(); ++i) {
                        if (((ItemTableColumn)columns.get(i)).isVisible()) continue;
                        --newIndex;
                    }
                    if (newIndex < oldIndex) {
                        colmodel.moveColumn(oldIndex, newIndex);
                    }
                } else {
                    colmodel.removeColumn(col);
                }
                ItemManagerConfig.save();
            });
            this.getPnlOptions().add(chkBox);
        }
        if (hideHeader) {
            this.table.getTableHeader().setPreferredSize(new Dimension(0, 0));
        } else {
            this.table.getTableHeader().setPreferredSize(new Dimension(0, 19));
        }
        this.tableModel.addListeners();
        this.table.setModel(this.tableModel);
        this.table.setColumnModel(colmodel);
        this.tableModel.setup();
        this.refresh(selectedItemsBefore, 0, 0);
    }

    public JTable getTable() {
        return this.table;
    }

    @Override
    public JComponent getComponent() {
        return this.table;
    }

    @Override
    public Point getLocationOnScreen() {
        return this.table.getTableHeader().getLocationOnScreen();
    }

    @Override
    protected FSkin.SkinImage getIcon() {
        return FSkin.getIcon(FSkinProp.ICO_LIST);
    }

    @Override
    protected String getCaption() {
        return Localizer.getInstance().getMessage("lblListView", new Object[0]);
    }

    @Override
    public void setAllowMultipleSelections(boolean allowMultipleSelections) {
        this.table.setSelectionMode(allowMultipleSelections ? 2 : 0);
    }

    @Override
    public int getSelectedIndex() {
        return this.table.getSelectedRow();
    }

    @Override
    public Iterable<Integer> getSelectedIndices() {
        int[] selectedRows;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int selectedRow : selectedRows = this.table.getSelectedRows()) {
            indices.add(selectedRow);
        }
        return indices;
    }

    @Override
    protected void onSetSelectedIndex(int index) {
        this.table.setRowSelectionInterval(index, index);
    }

    @Override
    protected void onSetSelectedIndices(Iterable<Integer> indices) {
        this.table.clearSelection();
        for (Integer index : indices) {
            this.table.addRowSelectionInterval(index, index);
        }
    }

    @Override
    protected void onScrollSelectionIntoView(JViewport viewport) {
        Rectangle targetRect = this.table.getCellRect(this.getSelectedIndex(), 0, true);
        Rectangle curViewRect = viewport.getViewRect();
        if (targetRect.y + targetRect.height > curViewRect.y + curViewRect.height) {
            targetRect.setLocation(targetRect.x, targetRect.y + targetRect.height * 3);
        } else if (targetRect.y < curViewRect.y) {
            targetRect.setLocation(targetRect.x, targetRect.y - targetRect.height * 3);
        }
        this.table.scrollRectToVisible(targetRect);
    }

    @Override
    public void selectAll() {
        this.table.selectAll();
    }

    @Override
    public int getIndexOfItem(T item) {
        return this.tableModel.itemToRow(item);
    }

    @Override
    public T getItemAtIndex(int index) {
        Map.Entry itemEntry = this.tableModel.rowToItem(index);
        return (T)(itemEntry != null ? (InventoryItem)itemEntry.getKey() : null);
    }

    @Override
    public int getCount() {
        return this.table.getRowCount();
    }

    @Override
    public int getSelectionCount() {
        return this.table.getSelectedRowCount();
    }

    @Override
    public int getIndexAtPoint(Point p) {
        return this.table.rowAtPoint(p);
    }

    @Override
    protected void onResize() {
    }

    @Override
    protected void onRefresh() {
        this.tableModel.fireTableDataChanged();
    }

    public final class ItemTableModel
    extends AbstractTableModel {
        private final ItemManagerModel<T> model;
        private final ListSelectionListener listSelectionListener = arg0 -> ItemListView.this.onSelectionChange();
        private final FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ItemListView.this.onSelectionChange();
            }
        };
        private final FMouseAdapter headerMouseAdapter = new FMouseAdapter(true){
            private ItemTableColumn resizeColumn;

            @Override
            public void onLeftMouseDown(MouseEvent e) {
                TableColumnModel colModel;
                int index;
                ItemListView.this.focus();
                if (Cursor.getPredefinedCursor(11) == ItemListView.this.table.getTableHeader().getCursor() && (index = (colModel = ItemListView.this.table.getColumnModel()).getColumnIndexAtX(e.getX() - 3)) >= 0) {
                    this.resizeColumn = (ItemTableColumn)colModel.getColumn(index);
                    this.resizeColumn.startResize();
                    MouseUtil.lockCursor();
                }
            }

            @Override
            public void onLeftMouseUp(MouseEvent e) {
                if (this.resizeColumn != null) {
                    MouseUtil.unlockCursor();
                    this.resizeColumn.endResize();
                    this.resizeColumn = null;
                }
            }

            @Override
            public void onLeftClick(MouseEvent e) {
                int columnModelIndex;
                if (Cursor.getPredefinedCursor(11) == ItemListView.this.table.getTableHeader().getCursor()) {
                    return;
                }
                TableColumnModel colModel = ItemListView.this.table.getColumnModel();
                int modelIndex = colModel.getColumn(columnModelIndex = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
                if (modelIndex < 0) {
                    return;
                }
                ItemTableModel.this.model.getCascadeManager().add(((ItemTableColumn)ItemListView.this.table.getColumnModel().getColumn(columnModelIndex)).getItemColumn(), false);
                ItemTableModel.this.model.refreshSort();
                ItemListView.this.table.tableChanged(new TableModelEvent(ItemTableModel.this));
                ItemListView.this.table.repaint();
                ItemListView.this.setSelectedIndex(0);
                ItemManagerConfig.save();
            }

            @Override
            public void onLeftMouseDragDrop(MouseEvent e) {
                for (int i = 0; i < ItemListView.this.table.getColumnCount(); ++i) {
                    ItemTableColumn column = (ItemTableColumn)ItemListView.this.table.getColumnModel().getColumn(i);
                    column.updatePreferredWidth();
                    column.setIndex(i);
                }
                ItemManagerConfig.save();
            }

            @Override
            public void onMouseExit(MouseEvent e) {
                MouseUtil.resetCursor();
            }
        };
        private final MouseMotionAdapter headerMouseMotionAdapter = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent arg0) {
                MouseUtil.setCursor(ItemListView.this.table.getTableHeader().getCursor());
            }
        };

        public ItemTableModel(ItemManagerModel<T> model0) {
            this.model = model0;
        }

        public void setup() {
            Enumeration<TableColumn> e = ItemListView.this.table.getColumnModel().getColumns();
            ItemTableColumn[] sortcols = new ItemTableColumn[ItemListView.this.table.getColumnCount()];
            while (e.hasMoreElements()) {
                ItemTableColumn col = (ItemTableColumn)e.nextElement();
                if (col.getSortPriority() <= 0 || col.getSortPriority() > sortcols.length) continue;
                sortcols[col.getSortPriority() - 1] = col;
            }
            this.model.getCascadeManager().reset();
            for (int i = sortcols.length - 1; i >= 0; --i) {
                ItemTableColumn col = sortcols[i];
                if (col == null) continue;
                this.model.getCascadeManager().add(col.getItemColumn(), true);
            }
        }

        public Map.Entry<T, Integer> rowToItem(int row) {
            List orderedList = this.model.getOrderedList();
            return row >= 0 && row < orderedList.size() ? orderedList.get(row) : null;
        }

        public int itemToRow(T item) {
            List orderedList = this.model.getOrderedList();
            for (int i = 0; i < orderedList.size(); ++i) {
                if (orderedList.get(i).getKey() != item) continue;
                return i;
            }
            return -1;
        }

        public void addListeners() {
            ItemListView.this.table.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
            ItemListView.this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
            ItemListView.this.table.removeFocusListener(this.focusAdapter);
            ItemListView.this.table.addFocusListener(this.focusAdapter);
            ItemListView.this.table.getTableHeader().removeMouseListener(this.headerMouseAdapter);
            ItemListView.this.table.getTableHeader().addMouseListener(this.headerMouseAdapter);
            ItemListView.this.table.getTableHeader().removeMouseMotionListener(this.headerMouseMotionAdapter);
            ItemListView.this.table.getTableHeader().addMouseMotionListener(this.headerMouseMotionAdapter);
        }

        @Override
        public int findColumn(String name0) {
            return ItemListView.this.table.getColumnModel().getColumnIndex(name0);
        }

        @Override
        public int getColumnCount() {
            return ItemListView.this.table.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return this.model.countDistinct();
        }

        @Override
        public Object getValueAt(int iRow, int iCol) {
            Map.Entry card = this.rowToItem(iRow);
            if (null == card) {
                return null;
            }
            return ((ItemTableColumn)ItemListView.this.table.getColumnModel().getColumn(ItemListView.this.table.convertColumnIndexToView(iCol))).getFnDisplay().apply(card);
        }
    }

    public final class ItemTable
    extends FSkin.SkinnedTable {
        private int lastTooltipRow = -1;
        private int lastTooltipCol = -1;
        private Point lastTooltipPt;

        private ItemTable() {
            this.setBackground(BACK_COLOR);
            this.setForeground(FORE_COLOR);
            this.setSelectionForeground(FORE_COLOR);
            this.setSelectionBackground(SEL_INACTIVE_COLOR);
            this.setGridColor(GRID_COLOR);
            this.setFont(ROW_FONT);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    ItemTable.this.setSelectionBackground(SEL_ACTIVE_COLOR);
                    if (ItemListView.this.getSelectedIndex() == -1 && ItemListView.this.getCount() > 0) {
                        ItemTable.this.setRowSelectionInterval(0, 0);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!e.isTemporary()) {
                        ItemTable.this.setSelectionBackground(SEL_INACTIVE_COLOR);
                    }
                }
            });
            this.setBorder((Border)null);
            this.setRowHeight(19);
            this.setRowMargin(0);
            this.setShowHorizontalLines(false);
            this.setAutoResizeMode(4);
            ActionListener listener = e -> {
                StringBuilder sb = new StringBuilder();
                for (int row : this.getSelectedRows()) {
                    Map.Entry item = ItemListView.this.tableModel.rowToItem(row);
                    sb.append(item.getValue().toString());
                    sb.append(' ');
                    sb.append(((InventoryItem)item.getKey()).toString());
                    sb.append('\n');
                }
                StringSelection selection = new StringSelection(sb.toString());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            };
            KeyStroke stroke = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false);
            this.registerKeyboardAction(listener, "Copy", stroke, 0);
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            FSkin.SkinnedTableHeader header = new FSkin.SkinnedTableHeader(this.columnModel){

                @Override
                public String getToolTipText(MouseEvent e) {
                    int col = this.columnModel.getColumnIndexAtX(e.getPoint().x);
                    if (col < 0) {
                        return null;
                    }
                    ItemTableColumn tableColumn = (ItemTableColumn)this.columnModel.getColumn(col);
                    if (tableColumn.getLongName().isEmpty()) {
                        return null;
                    }
                    return tableColumn.getLongName();
                }
            };
            header.setBorder((Border)null);
            header.setBackground(HEADER_BACK_COLOR);
            header.setForeground(FORE_COLOR);
            final DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)header.getDefaultRenderer();
            header.setDefaultRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel lbl = (JLabel)renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    lbl.setHorizontalAlignment(2);
                    FSkin.setTempBorder(lbl, HEADER_BORDER);
                    return lbl;
                }
            });
            return header;
        }

        @Override
        public void processMouseEvent(MouseEvent e) {
            Point p = e.getPoint();
            int row = this.rowAtPoint(p);
            int col = this.columnAtPoint(p);
            if (col < 0 || col >= this.getColumnCount() || row < 0 || row >= this.getRowCount()) {
                return;
            }
            Object val = this.getValueAt(row, col);
            if (val == null) {
                return;
            }
            ItemCellRenderer renderer = (ItemCellRenderer)this.getCellRenderer(row, col);
            if (renderer != null) {
                renderer.processMouseEvent(e, ItemListView.this, val, row, col);
            }
            try {
                super.processMouseEvent(e);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private String getCellTooltip(TableCellRenderer renderer, int row, int col, Object val) {
            JComponent jcell;
            String tip;
            Component cell = renderer.getTableCellRendererComponent(this, val, false, false, row, col);
            if (cell instanceof JComponent && (tip = (jcell = (JComponent)cell).getToolTipText()) != null && !tip.isEmpty()) {
                return tip;
            }
            if (val == null) {
                return "";
            }
            String text = val.toString();
            if (text.isEmpty()) {
                return "";
            }
            if (!(renderer instanceof ItemCellRenderer) || !((ItemCellRenderer)renderer).alwaysShowTooltip()) {
                int requiredWidth = cell.getPreferredSize().width;
                TableColumn tableColumn = this.getColumnModel().getColumn(col);
                if (tableColumn.getWidth() > requiredWidth) {
                    return "";
                }
            }
            return text;
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Point p = e.getPoint();
            int row = this.rowAtPoint(p);
            int col = this.columnAtPoint(p);
            if (col >= this.getColumnCount() || row >= this.getRowCount()) {
                return "";
            }
            Object val = this.getValueAt(row, col);
            if (val == null) {
                return "";
            }
            return this.getCellTooltip(this.getCellRenderer(row, col), row, col, val);
        }

        @Override
        public Point getToolTipLocation(MouseEvent e) {
            Point p = e.getPoint();
            int row = this.rowAtPoint(p);
            int col = this.columnAtPoint(p);
            if (row == this.lastTooltipRow && col == this.lastTooltipCol) {
                p = this.lastTooltipPt;
            } else {
                this.lastTooltipRow = row;
                this.lastTooltipCol = col;
                this.lastTooltipPt = p;
            }
            return new Point(p.x + 10, p.y + 20);
        }
    }
}

