/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import forge.item.InventoryItem;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.views.AttractionLightRenderer;
import forge.itemmanager.views.ColorSetRenderer;
import forge.itemmanager.views.DeckAIRenderer;
import forge.itemmanager.views.DeckQuantityRenderer;
import forge.itemmanager.views.DeckStarRenderer;
import forge.itemmanager.views.IntegerRenderer;
import forge.itemmanager.views.ItemListView;
import forge.itemmanager.views.ManaCostRenderer;
import forge.itemmanager.views.SetCodeRenderer;
import forge.itemmanager.views.StarRenderer;
import forge.toolbox.FSkin;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class ItemCellRenderer
extends DefaultTableCellRenderer {
    private static final Border DEFAULT_BORDER = new EmptyBorder(1, 1, 1, 1);

    public static ItemCellRenderer getColumnDefRenderer(ColumnDef columnDef) {
        switch (columnDef) {
            case POWER: 
            case TOUGHNESS: 
            case CMC: 
            case DECK_MAIN: 
            case DECK_SIDE: {
                return new IntegerRenderer();
            }
            case SET: 
            case DECK_EDITION: {
                return new SetCodeRenderer();
            }
            case COST: {
                return new ManaCostRenderer();
            }
            case ATTRACTION_LIGHTS: {
                return new AttractionLightRenderer();
            }
            case DECK_COLOR: {
                return new ColorSetRenderer();
            }
            case FAVORITE: {
                return new StarRenderer();
            }
            case DECK_FAVORITE: {
                return new DeckStarRenderer();
            }
            case DECK_QUANTITY: {
                return new DeckQuantityRenderer();
            }
            case DECK_AI: {
                return new DeckAIRenderer();
            }
        }
        return new ItemCellRenderer();
    }

    public boolean alwaysShowTooltip() {
        return false;
    }

    protected <T extends InventoryItem> void processMouseEvent(MouseEvent e, ItemListView<T> listView, Object value, int row, int column) {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        lbl.setBorder(DEFAULT_BORDER);
        if (isSelected) {
            lbl.setBackground(table.getSelectionBackground());
        } else if (row % 2 == 0) {
            lbl.setBackground(table.getBackground());
        } else {
            FSkin.setTempBackground(lbl, ItemListView.ALT_ROW_COLOR);
        }
        return lbl;
    }
}

