/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import forge.ImageCache;
import forge.card.ColorSet;
import forge.deck.DeckProxy;
import forge.deck.io.DeckPreferences;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.gamemodes.limited.CardRanker;
import forge.gui.GuiBase;
import forge.gui.framework.ILocalRepaint;
import forge.item.IPaperCard;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.GroupDef;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.ItemManagerModel;
import forge.itemmanager.SItemManagerUtil;
import forge.itemmanager.views.ItemTableColumn;
import forge.itemmanager.views.ItemView;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.match.controllers.CDetailPicture;
import forge.toolbox.CardFaceSymbols;
import forge.toolbox.FComboBoxWrapper;
import forge.toolbox.FLabel;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.toolbox.special.CardZoomer;
import forge.util.Localizer;
import forge.view.arcane.CardPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class ImageView<T extends InventoryItem>
extends ItemView<T> {
    private static final int PADDING = 5;
    private static final float PILE_SPACING_Y = 0.1f;
    private static final FSkin.SkinColor GROUP_HEADER_FORE_COLOR = FSkin.getColor(FSkin.Colors.CLR_TEXT);
    private static final FSkin.SkinColor GROUP_HEADER_LINE_COLOR = GROUP_HEADER_FORE_COLOR.alphaColor(120);
    private static final FSkin.SkinFont GROUP_HEADER_FONT = FSkin.getFont();
    private static final int GROUP_HEADER_HEIGHT = 19;
    private static final int GROUP_HEADER_GLYPH_WIDTH = 6;
    private static final int MIN_COLUMN_COUNT = 1;
    private static final int MAX_COLUMN_COUNT = 10;
    private final CardViewDisplay display;
    private final List<Integer> selectedIndices = new ArrayList<Integer>();
    private int columnCount = 4;
    private boolean allowMultipleSelections;
    private ColumnDef pileBy = null;
    private GroupDef groupBy = null;
    private boolean lockHoveredItem = false;
    private boolean lockInput = false;
    private Point hoverPoint;
    private Point hoverScrollPos;
    private ItemInfo hoveredItem;
    private ItemInfo focalItem;
    private InventoryItem lastAltCard = null;
    private boolean panelOptionsCreated = false;
    private final List<ItemInfo> orderedItems = new ArrayList<ItemInfo>();
    private final List<Group> groups = new ArrayList<Group>();
    final Localizer localizer = Localizer.getInstance();
    private final ExpandCollapseButton btnExpandCollapseAll = new ExpandCollapseButton();
    private final FComboBoxWrapper<Object> cbGroupByOptions = new FComboBoxWrapper();
    private final FComboBoxWrapper<Object> cbPileByOptions = new FComboBoxWrapper();
    private final FComboBoxWrapper<Integer> cbColumnCount = new FComboBoxWrapper();

    private static boolean isPreferenceEnabled(ForgePreferences.FPref preferenceName) {
        return FModel.getPreferences().getPrefBoolean(preferenceName);
    }

    public ImageView(ItemManager<T> itemManager0, ItemManagerModel<T> model0, boolean showRanking) {
        super(itemManager0, model0);
        SItemManagerUtil.populateImageViewOptions(itemManager0, this.cbGroupByOptions, this.cbPileByOptions);
        IntStream.rangeClosed(1, 10).forEach(this.cbColumnCount::addItem);
        this.cbGroupByOptions.setMaximumRowCount(this.cbGroupByOptions.getItemCount());
        this.cbPileByOptions.setMaximumRowCount(this.cbPileByOptions.getItemCount());
        this.cbColumnCount.setMaximumRowCount(this.cbColumnCount.getItemCount());
        this.cbColumnCount.setSelectedIndex(this.columnCount - 1);
        this.cbGroupByOptions.addActionListener(e -> {
            this.focus();
            if (this.cbGroupByOptions.getSelectedIndex() > 0) {
                this.setGroupBy((GroupDef)((Object)((Object)this.cbGroupByOptions.getSelectedItem())));
            } else {
                this.setGroupBy(null);
            }
        });
        this.cbPileByOptions.addActionListener(e -> {
            this.focus();
            if (this.cbPileByOptions.getSelectedIndex() > 0) {
                this.setPileBy((ColumnDef)((Object)((Object)this.cbPileByOptions.getSelectedItem())));
            } else {
                this.setPileBy(null);
            }
        });
        this.cbColumnCount.addActionListener(e -> {
            this.focus();
            this.setColumnCount(this.cbColumnCount.getSelectedItem());
        });
        this.display = new CardViewDisplay();
        this.display.setShowRanking(showRanking);
        this.display.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftMouseDown(MouseEvent e) {
                if (ImageView.this.lockInput) {
                    return;
                }
                if (!this.selectItem(e) && ImageView.this.groupBy != null) {
                    Point point = e.getPoint();
                    for (Group group : ImageView.this.groups) {
                        if (!group.getBounds().contains(point)) continue;
                        if (group.items.isEmpty() || point.y >= group.getTop() + 19) break;
                        group.isCollapsed = !group.isCollapsed;
                        ImageView.this.btnExpandCollapseAll.updateIsAllCollapsed();
                        ImageView.this.clearSelection();
                        ImageView.this.updateLayout(true);
                        break;
                    }
                }
            }

            @Override
            public void onLeftDoubleClick(MouseEvent e) {
                if (ImageView.this.lockInput) {
                    return;
                }
                ItemInfo item = ImageView.this.getItemAtPoint(e.getPoint());
                if (item != null && item.selected) {
                    ImageView.this.itemManager.activateSelectedItems();
                }
            }

            @Override
            public void onRightDoubleClick(MouseEvent e) {
                DeckProxy dp;
                if (ImageView.this.lockInput) {
                    return;
                }
                ItemInfo item = ImageView.this.getItemAtPoint(e.getPoint());
                if (item != null && item.selected && item.item instanceof DeckProxy && !(dp = (DeckProxy)item.item).isGeneratedDeck()) {
                    if (DeckPreferences.getPrefs(dp).getStarCount() > 0) {
                        DeckPreferences.getPrefs(dp).setStarCount(0);
                    } else {
                        DeckPreferences.getPrefs(dp).setStarCount(1);
                    }
                    ImageView.this.updateLayout(false);
                }
            }

            @Override
            public void onMiddleMouseDown(MouseEvent e) {
                if (ImageView.this.lockInput) {
                    return;
                }
                ItemInfo item = ImageView.this.getItemAtPoint(e.getPoint());
                if (item != null && item.item instanceof IPaperCard) {
                    ImageView.this.setLockHoveredItem(true);
                    CardView card = CardView.getCardForUi((IPaperCard)item.item);
                    CardZoomer.SINGLETON_INSTANCE.setCard(card.getCurrentState(), true);
                    CardZoomer.SINGLETON_INSTANCE.doMouseButtonZoom();
                }
            }

            @Override
            public void onMiddleMouseUp(MouseEvent e) {
                if (ImageView.this.lockInput) {
                    return;
                }
                CardZoomer.SINGLETON_INSTANCE.closeZoomer();
                ImageView.this.setLockHoveredItem(false);
            }

            @Override
            public void onRightClick(MouseEvent e) {
                if (ImageView.this.lockInput) {
                    return;
                }
                if (this.selectItem(e)) {
                    ImageView.this.setLockHoveredItem(true);
                    ImageView.this.itemManager.showContextMenu(e, () -> ImageView.this.setLockHoveredItem(false));
                }
            }

            private boolean selectItem(MouseEvent e) {
                ImageView.this.focus();
                ItemInfo item = ImageView.this.getItemAtPoint(e.getPoint());
                if (item == null) {
                    if (!e.isControlDown() && !e.isShiftDown()) {
                        ImageView.this.clearSelection();
                        ImageView.this.onSelectionChange();
                    }
                    return false;
                }
                if (item.selected) {
                    if (e.getButton() != 1) {
                        return true;
                    }
                    if (e.isControlDown()) {
                        item.selected = false;
                        ImageView.this.selectedIndices.remove((Object)item.index);
                        ImageView.this.onSelectionChange();
                        item.scrollIntoView();
                        return true;
                    }
                }
                if (!ImageView.this.allowMultipleSelections || !e.isControlDown() && !e.isShiftDown()) {
                    ImageView.this.clearSelection();
                }
                ImageView.this.selectedIndices.add(0, item.index);
                item.selected = true;
                ImageView.this.onSelectionChange();
                item.scrollIntoView();
                return true;
            }

            @Override
            public void onMouseExit(MouseEvent e) {
                if (ImageView.this.updateHoveredItem(null, null)) {
                    ImageView.this.display.repaintSelf();
                }
            }
        });
        this.display.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                FScrollPane scroller = ImageView.this.getScroller();
                Point hoverScrollPos = new Point(scroller.getHorizontalScrollBar().getValue(), scroller.getVerticalScrollBar().getValue());
                if (ImageView.this.updateHoveredItem(e.getPoint(), hoverScrollPos)) {
                    ImageView.this.display.repaintSelf();
                }
            }
        });
        this.groups.add(new Group(""));
        this.getScroller().setHorizontalScrollBarPolicy(31);
    }

    @Override
    public void setup(ItemManagerConfig config, Map<ColumnDef, ItemTableColumn> colOverrides) {
        if (!this.panelOptionsCreated) {
            this.setPanelOptions(config.getShowUniqueCardsOption());
            this.panelOptionsCreated = true;
        }
        this.setGroupBy(config.getGroupBy(), true);
        this.setPileBy(config.getPileBy(), true);
        this.setColumnCount(config.getImageColumnCount(), true);
    }

    private void setPanelOptions(boolean showUniqueCardsOption) {
        this.getPnlOptions().add((Component)this.btnExpandCollapseAll, "w 25px, h 25px");
        if (showUniqueCardsOption) {
            this.setUniqueCardsOnlyFilter();
        }
        this.getPnlOptions().add(new FLabel.Builder().text(this.localizer.getMessage("lblGroupby", new Object[0]) + ":").fontSize(12).build());
        this.cbGroupByOptions.addTo(this.getPnlOptions(), "pushx, growx");
        this.getPnlOptions().add(new FLabel.Builder().text(this.localizer.getMessage("lblPileby", new Object[0]) + ":").fontSize(12).build());
        this.cbPileByOptions.addTo(this.getPnlOptions(), "pushx, growx");
        this.getPnlOptions().add(new FLabel.Builder().text(this.localizer.getMessage("lblColumns", new Object[0]) + ":").fontSize(12).build());
        this.cbColumnCount.addTo(this.getPnlOptions(), "w 38px!");
    }

    public GroupDef getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(GroupDef groupBy0) {
        this.setGroupBy(groupBy0, false);
    }

    private void setGroupBy(GroupDef groupBy0, boolean forSetup) {
        if (this.groupBy == groupBy0) {
            return;
        }
        this.groupBy = groupBy0;
        if (this.groupBy == null) {
            this.cbGroupByOptions.setSelectedIndex(0);
        } else {
            this.cbGroupByOptions.setSelectedItem((Object)this.groupBy);
        }
        this.groups.clear();
        if (this.groupBy == null) {
            this.groups.add(new Group(""));
            this.btnExpandCollapseAll.updateIsAllCollapsed();
        } else {
            for (String groupName : this.groupBy.getGroups()) {
                this.groups.add(new Group(groupName));
            }
            if (this.btnExpandCollapseAll.isAllCollapsed) {
                for (Group group : this.groups) {
                    group.isCollapsed = true;
                }
            }
        }
        if (!forSetup) {
            if (this.itemManager.getConfig() != null) {
                this.itemManager.getConfig().setGroupBy(this.groupBy);
            }
            this.refresh(null, -1, 0);
        }
    }

    public ColumnDef getPileBy() {
        return this.pileBy;
    }

    public void setPileBy(ColumnDef pileBy0) {
        this.setPileBy(pileBy0, false);
    }

    private void setPileBy(ColumnDef pileBy0, boolean forSetup) {
        if (this.pileBy == pileBy0) {
            return;
        }
        this.pileBy = pileBy0;
        if (this.pileBy == null) {
            this.cbPileByOptions.setSelectedIndex(0);
        } else {
            this.cbPileByOptions.setSelectedItem((Object)this.pileBy);
        }
        if (!forSetup) {
            if (this.itemManager.getConfig() != null) {
                this.itemManager.getConfig().setPileBy(this.pileBy);
            }
            this.refresh(null, -1, 0);
        }
    }

    @Override
    protected void fixSelection(Iterable<T> itemsToSelect, int backupIndexToSelect, int scrollValueToRestore) {
        if (itemsToSelect == null) {
            this.clearSelection();
            this.setScrollValue(scrollValueToRestore);
            this.onSelectionChange();
        } else if (!this.setSelectedItems(itemsToSelect)) {
            this.setSelectedIndex(backupIndexToSelect);
        }
    }

    @Override
    protected void onMouseWheelZoom(MouseWheelEvent e) {
        if (e.getWheelRotation() > 0) {
            this.setColumnCount(this.columnCount + 1);
        } else {
            this.setColumnCount(this.columnCount - 1);
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount0) {
        this.setColumnCount(columnCount0, false);
    }

    private void setColumnCount(int columnCount0, boolean forSetup) {
        if (columnCount0 < 1) {
            columnCount0 = 1;
        } else if (columnCount0 > 10) {
            columnCount0 = 10;
        }
        if (this.columnCount == columnCount0) {
            return;
        }
        this.columnCount = columnCount0;
        this.cbColumnCount.setSelectedIndex(this.columnCount - 1);
        if (!forSetup) {
            ItemInfo focalItem0;
            if (this.itemManager.getConfig() != null) {
                this.itemManager.getConfig().setImageColumnCount(this.columnCount);
            }
            if ((focalItem0 = this.getFocalItem()) == null) {
                this.updateLayout(false);
                return;
            }
            int offsetTop = focalItem0.getTop() - this.getScrollValue();
            this.updateLayout(false);
            this.setScrollValue(focalItem0.getTop() - offsetTop);
            this.focalItem = focalItem0;
        }
    }

    private ItemInfo getFocalItem() {
        if (this.focalItem != null) {
            return this.focalItem;
        }
        if (this.hoveredItem != null) {
            return this.hoveredItem;
        }
        int visibleTop = this.getScrollValue();
        for (Group group : this.groups) {
            if (group.getBottom() < visibleTop) continue;
            for (Pile pile : group.piles) {
                if (group.getBottom() < visibleTop) continue;
                for (ItemInfo item : pile.items) {
                    if (item.getTop() < visibleTop) continue;
                    return item;
                }
            }
        }
        if (this.orderedItems.isEmpty()) {
            return null;
        }
        return this.orderedItems.get(0);
    }

    @Override
    protected void onResize() {
        this.updateLayout(false);
    }

    @Override
    protected void onRefresh() {
        Group otherItems = this.groupBy == null ? this.groups.get(0) : null;
        for (Group group : this.groups) {
            group.items.clear();
        }
        this.clearSelection();
        for (Map.Entry entry : this.model.getOrderedList()) {
            InventoryItem item = (InventoryItem)entry.getKey();
            int qty = (Integer)entry.getValue();
            int groupIndex = this.groupBy == null ? -1 : this.groupBy.getItemGroupIndex(item);
            for (int i = 0; i < qty; ++i) {
                if (groupIndex >= 0) {
                    this.groups.get(groupIndex).add(new ItemInfo(this, item));
                    continue;
                }
                if (otherItems == null) {
                    if (this.groups.size() > this.groupBy.getGroups().length) {
                        otherItems = this.groups.get(this.groups.size() - 1);
                    } else {
                        otherItems = new Group("Other");
                        otherItems.isCollapsed = this.btnExpandCollapseAll.isAllCollapsed;
                        this.groups.add(otherItems);
                    }
                }
                otherItems.add(new ItemInfo(this, item));
            }
        }
        if (otherItems == null && this.groups.size() > this.groupBy.getGroups().length) {
            this.groups.remove(this.groups.size() - 1);
            this.btnExpandCollapseAll.updateIsAllCollapsed();
        }
        this.updateLayout(true);
    }

    private void updateLayout(boolean forRefresh) {
        this.lockInput = true;
        this.focalItem = null;
        int y = 5;
        int groupX = 5;
        int itemAreaWidth = this.getVisibleSize().width;
        int groupWidth = itemAreaWidth - 2 * groupX;
        int pileX = 5;
        int pileWidth = itemAreaWidth - 2 * pileX;
        int gap = (10 - this.columnCount) / 2 + 2;
        int itemWidth = Math.round((pileWidth + gap) / this.columnCount - gap);
        int itemHeight = Math.round((float)itemWidth * 1.4f);
        int dx = itemWidth + gap;
        int dy = this.pileBy == null ? itemHeight + gap : Math.round((float)itemHeight * 0.1f);
        for (int i = 0; i < this.groups.size(); ++i) {
            int x;
            Group group = this.groups.get(i);
            if (forRefresh && this.pileBy != null) {
                ColumnDef groupPileBy = this.groupBy == null ? this.pileBy : this.groupBy.getGroupPileBy(i, this.pileBy);
                TreeMap piles = new TreeMap();
                for (ItemInfo itemInfo2 : group.items) {
                    Comparable<?> key = groupPileBy.fnSort.apply(itemInfo2);
                    if (!piles.containsKey(key)) {
                        piles.put(key, new Pile());
                    }
                    ((Pile)piles.get(key)).items.add(itemInfo2);
                }
                group.piles.clear();
                group.piles.addAll(piles.values());
            }
            int groupY = y;
            if (group.items.isEmpty()) {
                group.setBounds(groupX, groupY, groupWidth, 0);
                continue;
            }
            if (this.groupBy != null) {
                y += 24;
                if (group.isCollapsed) {
                    group.setBounds(groupX, groupY, groupWidth, 19);
                    continue;
                }
            }
            if (this.pileBy == null) {
                group.piles.clear();
                Pile pile = new Pile();
                x = pileX;
                for (Object itemInfo : group.items) {
                    if (pile.items.size() == this.columnCount) {
                        pile = new Pile();
                        x = pileX;
                        y += dy;
                    }
                    ((DisplayArea)itemInfo).setBounds(x, y, itemWidth, itemHeight);
                    if (pile.items.size() == 0) {
                        pile.setBounds(pileX, y, pileWidth, itemHeight);
                        group.piles.add(pile);
                    }
                    pile.items.add(itemInfo);
                    x += dx;
                }
                y += itemHeight;
            } else {
                x = pileX;
                int pileY = y;
                int maxPileHeight = 0;
                for (int j = 0; j < group.piles.size(); ++j) {
                    Object itemInfo;
                    if (j > 0 && j % this.columnCount == 0) {
                        y = pileY + maxPileHeight + gap;
                        x = pileX;
                        pileY = y;
                        maxPileHeight = 0;
                    }
                    Pile pile = (Pile)group.piles.get(j);
                    y = pileY;
                    itemInfo = pile.items.iterator();
                    while (itemInfo.hasNext()) {
                        ItemInfo itemInfo2;
                        itemInfo2 = (ItemInfo)itemInfo.next();
                        itemInfo2.setBounds(x, y, itemWidth, itemHeight);
                        y += dy;
                    }
                    int pileHeight = y + itemHeight - dy - pileY;
                    if (pileHeight > maxPileHeight) {
                        maxPileHeight = pileHeight;
                    }
                    pile.setBounds(x, pileY, itemWidth, pileHeight);
                    x += dx;
                }
                y = pileY + maxPileHeight;
            }
            group.setBounds(groupX, groupY, groupWidth, y - groupY);
            y += 5;
        }
        if (forRefresh) {
            int index = 0;
            this.orderedItems.clear();
            for (Group group : this.groups) {
                if (group.isCollapsed || group.items.isEmpty()) continue;
                for (Pile pile : group.piles) {
                    for (ItemInfo itemInfo : pile.items) {
                        itemInfo.index = index++;
                        this.orderedItems.add(itemInfo);
                    }
                }
            }
        }
        this.display.setPreferredSize(new Dimension(itemAreaWidth, y));
        this.display.revalidate();
        this.display.repaintSelf();
    }

    private ItemInfo getItemAtPoint(Point p) {
        for (int i = this.groups.size() - 1; i >= 0; --i) {
            Group group = this.groups.get(i);
            if (group.isCollapsed || !group.getBounds().contains(p)) continue;
            for (int j = group.piles.size() - 1; j >= 0; --j) {
                Pile pile = (Pile)group.piles.get(j);
                if (!pile.getBounds().contains(p)) continue;
                for (int k = pile.items.size() - 1; k >= 0; --k) {
                    ItemInfo item = (ItemInfo)pile.items.get(k);
                    if (!item.getBounds().contains(p)) continue;
                    return item;
                }
            }
        }
        return null;
    }

    private Dimension getVisibleSize() {
        FScrollPane scroller = this.getScroller();
        Dimension size = this.getScroller().getSize();
        Insets insets = this.getScroller().getInsets();
        size = new Dimension(size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
        size.width -= scroller.getVerticalScrollBar().getPreferredSize().width;
        return size;
    }

    private void setLockHoveredItem(boolean lockHoveredItem0) {
        if (this.lockHoveredItem == lockHoveredItem0) {
            return;
        }
        this.lockHoveredItem = lockHoveredItem0;
        if (!this.lockHoveredItem && this.updateHoveredItem(this.hoverPoint, this.hoverScrollPos)) {
            this.display.repaintSelf();
        }
    }

    private boolean updateHoveredItem(Point hoverPoint0, Point hoverScrollPos0) {
        this.hoverPoint = hoverPoint0;
        if (this.hoverScrollPos != hoverScrollPos0) {
            this.hoverScrollPos = hoverScrollPos0;
            this.focalItem = null;
        }
        if (this.lockHoveredItem) {
            return false;
        }
        ItemInfo item = null;
        FScrollPane scroller = this.getScroller();
        if (hoverPoint0 != null) {
            Point displayPoint = new Point(hoverPoint0);
            displayPoint.x += scroller.getHorizontalScrollBar().getValue() - hoverScrollPos0.x;
            displayPoint.y += scroller.getVerticalScrollBar().getValue() - hoverScrollPos0.y;
            item = this.getItemAtPoint(displayPoint);
        }
        if (this.hoveredItem == item) {
            return false;
        }
        this.hoveredItem = item;
        if (item != null) {
            CDetailPicture cDetailPicture = this.itemManager.getCDetailPicture();
            if (cDetailPicture != null) {
                cDetailPicture.displayAlt(item.alt);
            }
            this.showHoveredItem(item.item);
        }
        return true;
    }

    protected void showHoveredItem(T item) {
        CDetailPicture cDetailPicture = this.itemManager.getCDetailPicture();
        if (cDetailPicture != null) {
            cDetailPicture.showItem((InventoryItem)item);
        } else {
            CDeckEditorUI.SINGLETON_INSTANCE.setCard((InventoryItem)item);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.display;
    }

    @Override
    public void setAllowMultipleSelections(boolean allowMultipleSelections0) {
        this.allowMultipleSelections = allowMultipleSelections0;
    }

    @Override
    public T getItemAtIndex(int index) {
        if (index >= 0 && index < this.getCount()) {
            return (T)this.orderedItems.get(index).item;
        }
        return null;
    }

    @Override
    public int getIndexOfItem(T item) {
        for (Group group : this.groups) {
            for (ItemInfo itemInfo : group.items) {
                if (itemInfo.item != item) continue;
                if (group.isCollapsed) {
                    group.isCollapsed = false;
                    this.btnExpandCollapseAll.updateIsAllCollapsed();
                    this.clearSelection();
                    this.updateLayout(false);
                }
                return itemInfo.index;
            }
        }
        return -1;
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndices.isEmpty() ? -1 : this.selectedIndices.get(0);
    }

    @Override
    public Iterable<Integer> getSelectedIndices() {
        return this.selectedIndices;
    }

    @Override
    public int getCount() {
        return this.orderedItems.size();
    }

    @Override
    public int getSelectionCount() {
        return this.selectedIndices.size();
    }

    @Override
    public int getIndexAtPoint(Point p) {
        ItemInfo item = this.getItemAtPoint(p);
        if (item != null) {
            return item.index;
        }
        return -1;
    }

    @Override
    protected FSkin.SkinImage getIcon() {
        if (this.itemManager.getGenericType().equals(DeckProxy.class)) {
            return FSkin.getImage(FSkinProp.IMG_PACK).resize(18, 18);
        }
        return FSkin.getIcon(FSkinProp.ICO_CARD_IMAGE);
    }

    @Override
    protected String getCaption() {
        return Localizer.getInstance().getMessage("lblImageView", new Object[0]);
    }

    @Override
    public void selectAll() {
        this.clearSelection();
        IntStream.range(0, this.getCount()).forEach(this.selectedIndices::add);
        this.updateSelection();
    }

    @Override
    protected void onSetSelectedIndex(int index) {
        this.clearSelection();
        this.selectedIndices.add(index);
        this.updateSelection();
    }

    @Override
    protected void onSetSelectedIndices(Iterable<Integer> indices) {
        this.clearSelection();
        for (Integer index : indices) {
            this.selectedIndices.add(index);
        }
        this.updateSelection();
    }

    private void clearSelection() {
        int count = this.getCount();
        for (Integer i : this.selectedIndices) {
            if (i >= count) continue;
            this.orderedItems.get(i).selected = false;
        }
        this.selectedIndices.clear();
    }

    private void updateSelection() {
        for (Integer i : this.selectedIndices) {
            this.orderedItems.get(i).selected = true;
        }
        this.onSelectionChange();
    }

    @Override
    protected void onSelectionChange() {
        super.onSelectionChange();
        this.display.repaintSelf();
    }

    @Override
    protected void onScrollSelectionIntoView(JViewport viewport) {
        if (this.selectedIndices.isEmpty()) {
            return;
        }
        ItemInfo itemInfo = this.orderedItems.get(this.selectedIndices.get(0));
        itemInfo.scrollIntoView();
    }

    private class CardViewDisplay
    extends JPanel
    implements ILocalRepaint {
        boolean showRanking = false;

        private CardViewDisplay() {
            this.setOpaque(false);
            this.setFocusable(true);
        }

        public void setShowRanking(boolean showRanking) {
            this.showRanking = showRanking;
        }

        @Override
        public void repaintSelf() {
            this.repaint(this.getVisibleRect());
        }

        @Override
        public final void paintComponent(Graphics g2) {
            if (ImageView.this.groups.isEmpty() || ((Group)((ImageView)ImageView.this).groups.get((int)0)).getBounds().width <= 0) {
                return;
            }
            ImageView.this.updateHoveredItem(ImageView.this.hoverPoint, ImageView.this.hoverScrollPos);
            Graphics2D g2d = (Graphics2D)g2;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Dimension visibleSize = ImageView.this.getVisibleSize();
            int visibleTop = ImageView.this.getScrollValue();
            int visibleBottom = visibleTop + visibleSize.height;
            FSkin.setGraphicsFont(g2d, GROUP_HEADER_FONT);
            FontMetrics fm = g2d.getFontMetrics();
            int fontOffsetY = (19 - fm.getHeight()) / 2 + fm.getAscent();
            for (Group group : ImageView.this.groups) {
                if (group.items.isEmpty() || group.getBottom() < visibleTop) continue;
                if (group.getTop() >= visibleBottom) break;
                if (ImageView.this.groupBy != null) {
                    Rectangle bounds = group.getBounds();
                    int x = bounds.x + 6 + 5 + 1;
                    int y = bounds.y + fontOffsetY;
                    FSkin.setGraphicsColor(g2d, GROUP_HEADER_FORE_COLOR);
                    String caption = group.name + " (" + group.items.size() + ")";
                    g2d.drawString(caption, x, y);
                    y = bounds.y + 9;
                    FSkin.setGraphicsColor(g2d, GROUP_HEADER_LINE_COLOR);
                    g2d.drawLine(x += fm.stringWidth(caption) + 5, y, bounds.x + bounds.width - 1, y);
                    Polygon glyph = new Polygon();
                    int offset = 4;
                    x = bounds.x + offset;
                    if (group.isCollapsed) {
                        glyph.addPoint(x, ++y - offset);
                        glyph.addPoint(x + offset, y);
                        glyph.addPoint(x, y + offset);
                    } else {
                        glyph.addPoint(x - offset + 2, y + offset - 1);
                        glyph.addPoint(x + offset, y + offset - 1);
                        glyph.addPoint(x + offset, y - offset + 1);
                    }
                    g2d.fill(glyph);
                    if (group.isCollapsed) continue;
                }
                ItemInfo skippedItem = null;
                block1: for (Pile pile : group.piles) {
                    if (pile.getBottom() < visibleTop) continue;
                    if (pile.getTop() >= visibleBottom) break;
                    for (ItemInfo itemInfo : pile.items) {
                        if (itemInfo.getBottom() < visibleTop) continue;
                        if (itemInfo.getTop() >= visibleBottom) continue block1;
                        InventoryItem item = itemInfo.item;
                        itemInfo.alt = false;
                        if (!FModel.getPreferences().getPref(ForgePreferences.FPref.UI_SWITCH_STATES_DECKVIEW).equals("Never") && (ImageView.this.hoveredItem == null || !ImageView.this.hoveredItem.item.equals(item) || FModel.getPreferences().getPref(ForgePreferences.FPref.UI_SWITCH_STATES_DECKVIEW).equals("Always")) && item instanceof PaperCard) {
                            if (((PaperCard)item).hasBackFace()) {
                                if (item.equals(ImageView.this.lastAltCard)) {
                                    itemInfo.alt = true;
                                    ImageView.this.lastAltCard = null;
                                } else {
                                    ImageView.this.lastAltCard = item;
                                }
                            } else {
                                ImageView.this.lastAltCard = null;
                            }
                        }
                        if (itemInfo != ImageView.this.hoveredItem) {
                            this.drawItemImage(g2d, itemInfo);
                            continue;
                        }
                        skippedItem = itemInfo;
                    }
                }
                if (skippedItem == null) continue;
                this.drawItemImage(g2d, skippedItem);
            }
            if (ImageView.this.lockInput) {
                SwingUtilities.invokeLater(() -> ImageView.this.lockInput = false);
            }
        }

        private void drawItemImage(Graphics2D g2, ItemInfo itemInfo) {
            boolean noBorder;
            Rectangle bounds = itemInfo.getBounds();
            int itemWidth = bounds.width;
            boolean selBorderSize = true;
            InventoryItem item = itemInfo.item;
            boolean deckSelectMode = item instanceof DeckProxy;
            boolean bl = noBorder = !ImageView.isPreferenceEnabled(ForgePreferences.FPref.UI_RENDER_BLACK_BORDERS);
            if (item instanceof IPaperCard) {
                CardView cv = CardView.getCardForUi((IPaperCard)item);
                noBorder |= cv.getCurrentState().getSetCode().equalsIgnoreCase("MPS_AKH");
                noBorder |= cv.getCurrentState().isBasicLand() && cv.getCurrentState().getSetCode().equalsIgnoreCase("UST");
            }
            int borderSize = noBorder ? 0 : Math.round((float)itemWidth * 0.03f);
            int cornerSize = Math.max(4, Math.round((float)itemWidth * 0.1f));
            if (itemInfo.selected || itemInfo == ImageView.this.hoveredItem) {
                g2.setColor(Color.green);
                g2.fillRoundRect(bounds.x - 1, bounds.y - 1, bounds.width + 2, bounds.height + 2, cornerSize + 1, cornerSize + 1);
            }
            g2.setColor(Color.black);
            g2.fillRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, cornerSize, cornerSize);
            float screenScale = GuiBase.getInterface().getScreenScale();
            int drawX = bounds.x + borderSize;
            int drawY = bounds.y + borderSize;
            int drawWidth = bounds.width - 2 * borderSize;
            int drawHeight = bounds.height - 2 * borderSize;
            int imageWidth = Math.round((float)drawWidth * screenScale);
            int imageHeight = Math.round((float)drawHeight * screenScale);
            BufferedImage img = ImageCache.getImage(item, imageWidth, imageHeight, itemInfo.alt);
            if (img != null) {
                g2.drawImage(img, drawX, drawY, drawWidth, drawHeight, null);
            } else {
                if (deckSelectMode) {
                    DeckProxy dp = (DeckProxy)item;
                    if (dp.isGeneratedDeck()) {
                        FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_DECK_GENERIC), bounds.x, bounds.y, bounds.width - 2 * cornerSize, bounds.height - 2 * cornerSize);
                    } else {
                        PaperCard coverCard;
                        String deckImageKey = "";
                        PaperCard paperCard = coverCard = dp.getDeck().getCommanders().isEmpty() ? dp.getHighestCMCCard() : dp.getDeck().getCommanders().get(0);
                        if (coverCard != null) {
                            deckImageKey = coverCard.getImageKey(false);
                        }
                        ColorSet deckColor = dp.getColor();
                        int scale = CardFaceSymbols.getHeight() * cornerSize / 8;
                        int scaleArt = CardFaceSymbols.getHeight() * cornerSize / 7;
                        BufferedImage cardImage = ImageCache.scaleImage(deckImageKey, bounds.width, bounds.height, false, null);
                        if (cardImage == null) {
                            FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_DECK_GENERIC), bounds.x, bounds.y, bounds.width - 2 * cornerSize, bounds.height - 2 * cornerSize);
                        } else {
                            Image art = null;
                            try {
                                art = ImageCache.getCroppedArt(cardImage, bounds.x, bounds.y, bounds.width, bounds.height).getScaledInstance(scaleArt * 3, Math.round((float)scaleArt * 2.5f), 4);
                            }
                            catch (RasterFormatException rasterFormatException) {
                                // empty catch block
                            }
                            if (art != null) {
                                g2.drawImage(art, bounds.x + bounds.width / 9, 2 * cornerSize + bounds.y + bounds.height / 7, null);
                                FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_DECK_CARD_ART), bounds.x, bounds.y, bounds.width - 2 * cornerSize, bounds.height - 2 * cornerSize);
                            } else {
                                FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_DECK_GENERIC), bounds.x, bounds.y, bounds.width - 2 * cornerSize, bounds.height - 2 * cornerSize);
                            }
                        }
                        if (deckColor != null) {
                            CardFaceSymbols.drawColorSet(g2, deckColor, bounds.x + bounds.width - scale * 2 + cornerSize, bounds.y + bounds.height / 2 - scale * 2, scale, true);
                        }
                        FSkin.drawImage(g2, DeckPreferences.getPrefs(dp).getStarCount() > 0 ? FSkin.getImage(FSkinProp.IMG_STAR_FILLED) : FSkin.getImage(FSkinProp.IMG_STAR_OUTLINE), bounds.x, bounds.y + bounds.height / 2 - scaleArt * 2, scaleArt / 2, scaleArt / 2);
                    }
                }
                g2.setColor(Color.white);
                Shape clip = g2.getClip();
                g2.setClip(bounds);
                g2.drawString(item.getName(), bounds.x + 10, bounds.y + 20);
                g2.setClip(clip);
            }
            if (item instanceof IPaperCard) {
                IPaperCard paperCard = (IPaperCard)item;
                if (paperCard.isFoil()) {
                    CardView card = CardView.getCardForUi(paperCard);
                    if (card.getCurrentState().getFoilIndex() == 0) {
                        if (item instanceof Card) {
                            card.getCurrentState().setFoilIndexOverride(-1);
                        } else if (item instanceof IPaperCard) {
                            card.getCurrentState().setFoilIndexOverride(1);
                        }
                    }
                    CardPanel.drawFoilEffect(g2, card, bounds.x, bounds.y, bounds.width, bounds.height, borderSize);
                }
                if (this.showRanking && FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_OVERLAY_DRAFT_RANKING)) {
                    double score = CardRanker.getRawScore((PaperCard)item);
                    int draftRank = score <= 0.0 ? 0 : (score > 99.0 ? 99 : (int)Math.round(CardRanker.getRawScore((PaperCard)item)));
                    String value = String.valueOf(draftRank);
                    g2.setColor(Color.white);
                    Shape clip = g2.getClip();
                    g2.setClip(bounds);
                    int scale = (int)((float)g2.getFontMetrics().getHeight() * 3.5f);
                    int h2 = (int)((float)g2.getFontMetrics().getHeight() / 3.5f);
                    int w = g2.getFontMetrics().stringWidth(value);
                    int x = bounds.x + bounds.width / 2;
                    int y = bounds.y + bounds.height / 2;
                    if (draftRank >= 90) {
                        FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_DRAFTRANK_S), x - scale / 2, y - h2 - scale / 2, scale, scale);
                    } else if (draftRank >= 80 && draftRank <= 89) {
                        FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_DRAFTRANK_A), x - scale / 2, y - h2 - scale / 2, scale, scale);
                    } else if (draftRank >= 60 && draftRank <= 79) {
                        FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_DRAFTRANK_B), x - scale / 2, y - h2 - scale / 2, scale, scale);
                    } else if (draftRank >= 25 && draftRank <= 59) {
                        FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_DRAFTRANK_C), x - scale / 2, y - h2 - scale / 2, scale, scale);
                    } else {
                        FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_DRAFTRANK_D), x - scale / 2, y - h2 - scale / 2, scale, scale);
                    }
                    g2.drawString(value, x - w / 2, y);
                    g2.setClip(clip);
                }
            }
        }
    }

    private static class ItemInfo
    extends DisplayArea
    implements Map.Entry<InventoryItem, Integer> {
        private final T item;
        private int index;
        private boolean selected;
        private boolean alt;
        final /* synthetic */ ImageView this$0;

        private ItemInfo(T item0) {
            this.this$0 = var1_1;
            this.item = item0;
        }

        public String toString() {
            return this.item.toString();
        }

        @Override
        public InventoryItem getKey() {
            return this.item;
        }

        @Override
        public Integer getValue() {
            return 1;
        }

        @Override
        public Integer setValue(Integer value) {
            return 1;
        }
    }

    private class Pile
    extends DisplayArea {
        private final List<ItemInfo> items;

        private Pile() {
            this.items = new ArrayList<ItemInfo>();
        }
    }

    private class Group
    extends DisplayArea {
        private final List<ItemInfo> items;
        private final List<Pile> piles;
        private final String name;
        private boolean isCollapsed;

        public Group(String name0) {
            this.items = new ArrayList<ItemInfo>();
            this.piles = new ArrayList<Pile>();
            this.name = name0;
        }

        public void add(ItemInfo item) {
            this.items.add(item);
        }

        public String toString() {
            return this.name;
        }
    }

    private class DisplayArea {
        private final Rectangle bounds = new Rectangle();

        private DisplayArea() {
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public void setBounds(int x, int y, int width, int height) {
            this.bounds.x = x;
            this.bounds.y = y;
            this.bounds.width = width;
            this.bounds.height = height;
        }

        public int getTop() {
            return this.bounds.y;
        }

        public int getBottom() {
            return this.bounds.y + this.bounds.height;
        }

        public void scrollIntoView() {
            int x = this.bounds.x - 5;
            int y = this.bounds.y - 5;
            int width = this.bounds.width + 10;
            int height = this.bounds.height + 10;
            ImageView.this.display.scrollRectToVisible(new Rectangle(x, y, width, height));
        }
    }

    private class ExpandCollapseButton
    extends FLabel {
        private boolean isAllCollapsed;

        private ExpandCollapseButton() {
            super(new FLabel.ButtonBuilder());
            this.setFocusable(false);
            this.updateToolTip();
            this.setCommand(() -> {
                if (ImageView.this.groupBy == null || ImageView.this.model.getItems().isEmpty()) {
                    return;
                }
                boolean collapsed = !this.isAllCollapsed;
                for (Group group : ImageView.this.groups) {
                    group.isCollapsed = collapsed;
                }
                this.updateIsAllCollapsed();
                ImageView.this.clearSelection();
                ImageView.this.updateLayout(false);
            });
        }

        private void updateIsAllCollapsed() {
            boolean isAllCollapsed0 = true;
            for (Group group : ImageView.this.groups) {
                if (group.isCollapsed) continue;
                isAllCollapsed0 = false;
                break;
            }
            if (this.isAllCollapsed != isAllCollapsed0) {
                this.isAllCollapsed = isAllCollapsed0;
                this.updateToolTip();
                this.repaintSelf();
            }
        }

        private void updateToolTip() {
            this.setToolTipText(this.isAllCollapsed ? ImageView.this.localizer.getMessage("lblExpandallgroups", new Object[0]) : ImageView.this.localizer.getMessage("lblCollapseallgroups", new Object[0]));
        }

        @Override
        protected void paintContent(Graphics2D g2, int w, int h2, boolean paintPressedState) {
            int squareSize = w / 2 - 2;
            int offset = 2;
            int x = (w - squareSize) / 2 - offset;
            int y = (h2 - squareSize) / 2 - offset;
            if (!paintPressedState) {
                --x;
                --y;
            }
            FSkin.setGraphicsColor(g2, GROUP_HEADER_FORE_COLOR);
            for (int i = 0; i < 2; ++i) {
                g2.drawLine(x, y, x + squareSize, y);
                g2.drawLine(x + squareSize, y, x + squareSize, y + offset);
                g2.drawLine(x, y, x, y + squareSize);
                g2.drawLine(x, y + squareSize, x + offset, y + squareSize);
                x += offset;
                y += offset;
            }
            g2.drawRect(x, y, squareSize, squareSize);
            g2.drawLine(x + offset + 1, y + squareSize / 2, x + squareSize - 2 * offset + 1, y + squareSize / 2);
            if (this.isAllCollapsed) {
                g2.drawLine(x + squareSize / 2, y + offset + 1, x + squareSize / 2, y + squareSize - 2 * offset + 1);
            }
        }
    }
}

