/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import forge.deck.DeckProxy;
import forge.deck.io.DeckPreferences;
import forge.item.InventoryItem;
import forge.itemmanager.views.ItemCellRenderer;
import forge.itemmanager.views.ItemListView;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JTable;

public class DeckStarRenderer
extends ItemCellRenderer {
    private DeckProxy deck;
    private FSkin.SkinImage skinImage;

    @Override
    public boolean alwaysShowTooltip() {
        return true;
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.deck = value instanceof DeckProxy ? (DeckProxy)value : null;
        this.update();
        return super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
    }

    @Override
    public <T extends InventoryItem> void processMouseEvent(MouseEvent e, ItemListView<T> listView, Object value, int row, int column) {
        if (e.getID() == 501 && e.getButton() == 1 && value instanceof DeckProxy) {
            this.deck = (DeckProxy)value;
            DeckPreferences prefs = DeckPreferences.getPrefs(this.deck);
            prefs.setStarCount((prefs.getStarCount() + 1) % 2);
            this.update();
            listView.getTable().setRowSelectionInterval(row, row);
            listView.getTable().repaint();
            e.consume();
        }
    }

    private void update() {
        Localizer localizer = Localizer.getInstance();
        if (this.deck == null) {
            this.setToolTipText(null);
            this.skinImage = null;
        } else if (DeckPreferences.getPrefs(this.deck).getStarCount() == 0) {
            this.setToolTipText(localizer.getMessage("lblClickToAddTargetToFavorites", this.deck.getName()));
            this.skinImage = FSkin.getImage(FSkinProp.IMG_STAR_OUTLINE);
        } else {
            this.setToolTipText(localizer.getMessage("lblClickToRemoveTargetToFavorites", this.deck.getName()));
            this.skinImage = FSkin.getImage(FSkinProp.IMG_STAR_FILLED);
        }
    }

    @Override
    public final void paint(Graphics g2) {
        super.paint(g2);
        if (this.skinImage == null) {
            return;
        }
        int size = 15;
        int width = this.getWidth();
        int height = this.getHeight();
        if (size > width) {
            size = width;
        }
        FSkin.drawImage(g2, this.skinImage, (width - size) / 2, (height - size) / 2, size, size);
    }
}

