/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import forge.item.InventoryItem;
import forge.itemmanager.views.ItemCellRenderer;
import forge.itemmanager.views.ItemListView;
import forge.localinstance.skin.FSkinProp;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.toolbox.FSkin;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class DeckQuantityRenderer
extends ItemCellRenderer {
    private static final FSkin.SkinImage imgAdd = FSkin.getIcon(FSkinProp.ICO_PLUS);
    private static final FSkin.SkinImage imgRemove = FSkin.getIcon(FSkinProp.ICO_MINUS);
    private static final int imgSize = 13;

    public DeckQuantityRenderer() {
        this.setHorizontalAlignment(0);
    }

    @Override
    public <T extends InventoryItem> void processMouseEvent(MouseEvent e, ItemListView<T> listView, Object value, int row, int column) {
        if (e.getID() == 501 && e.getButton() == 1) {
            Rectangle cellBounds = listView.getTable().getCellRect(row, column, false);
            int delta = 0;
            int x = e.getX() - cellBounds.x;
            if (x <= 13) {
                delta = -1;
            } else if (x >= cellBounds.width - 13) {
                delta = 1;
            }
            if (delta != 0) {
                listView.getTable().setRowSelectionInterval(row, row);
                CDeckEditorUI.SINGLETON_INSTANCE.incrementDeckQuantity(listView.getItemAtIndex(row), delta);
                e.consume();
            }
        }
    }

    @Override
    public final void paint(Graphics g2) {
        super.paint(g2);
        int y = (this.getHeight() - 13) / 2;
        FSkin.drawImage(g2, imgRemove, 0, y, 13, 13);
        FSkin.drawImage(g2, imgAdd, this.getWidth() - 13, y, 13, 13);
    }
}

