/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.itemmanager.views.ItemCellRenderer;
import forge.util.DeckAIUtils;
import forge.util.Localizer;
import java.awt.Component;
import java.util.TreeSet;
import javax.swing.JTable;

public class DeckAIRenderer
extends ItemCellRenderer {
    private final Localizer localizer = Localizer.getInstance();

    @Override
    public boolean alwaysShowTooltip() {
        return false;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        StringBuilder label = new StringBuilder("");
        StringBuilder tooltip = new StringBuilder("");
        if (value instanceof Deck.UnplayableAICards) {
            Deck.UnplayableAICards removedUnplayableCards = (Deck.UnplayableAICards)value;
            for (DeckSection s2 : new TreeSet<DeckSection>(removedUnplayableCards.unplayable.keySet())) {
                int unplayableSize = removedUnplayableCards.unplayable.get((Object)s2).size();
                tooltip.append("[" + DeckAIUtils.getLocalizedDeckSection(this.localizer, s2) + ":" + unplayableSize + "]");
            }
            label.append(removedUnplayableCards.inMainDeck > 0 ? "" + removedUnplayableCards.inMainDeck : "");
        }
        this.setToolTipText(tooltip.toString());
        return super.getTableCellRendererComponent(table, label.toString(), isSelected, hasFocus, row, row);
    }
}

