/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import forge.card.ColorSet;
import forge.card.mana.ManaCostShard;
import forge.itemmanager.views.ItemCellRenderer;
import forge.toolbox.CardFaceSymbols;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;

public class ColorSetRenderer
extends ItemCellRenderer {
    private static final long serialVersionUID = 1770527102334163549L;
    private static final int elemtWidth = 13;
    private static final int elemtGap = 0;
    private static final int padding0 = 2;
    private ColorSet cs;

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.cs = value instanceof ColorSet ? (ColorSet)value : ColorSet.getNullColor();
        this.setToolTipText(this.cs.toString());
        return super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
    }

    @Override
    public final void paint(Graphics g2) {
        super.paint(g2);
        int cellWidth = this.getWidth();
        int x = 2;
        int y = 3;
        int cntGlyphs = this.cs.countColors();
        int offsetIfNoSpace = cntGlyphs > 1 ? (cellWidth - 2 - 13) / (cntGlyphs - 1) : 13;
        int dx = Math.min(13, offsetIfNoSpace);
        for (ManaCostShard s2 : this.cs.getOrderedShards()) {
            CardFaceSymbols.drawManaSymbol(s2.getImageKey(), g2, x, y);
            x += dx;
        }
    }
}

