/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.views;

import forge.itemmanager.views.ItemCellRenderer;
import forge.toolbox.CardFaceSymbols;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Set;
import javax.swing.JTable;
import org.apache.commons.lang3.StringUtils;

public class AttractionLightRenderer
extends ItemCellRenderer {
    private static final int elementWidth = 13;
    private static final int elementGap = 2;
    private static final int padding = 2;
    private Set<?> lights;

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Set) {
            this.lights = (Set)value;
            this.setToolTipText(StringUtils.join(this.lights, ", "));
        } else {
            this.lights = null;
            this.setToolTipText(null);
        }
        return super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
    }

    @Override
    public final void paint(Graphics g2) {
        super.paint(g2);
        if (this.lights == null) {
            return;
        }
        int cellWidth = this.getWidth();
        int x = 2;
        int y = 3;
        int cntGlyphs = 6;
        int offsetIfNoSpace = (cellWidth - 2 - 13) / 5;
        int dx = Math.min(15, offsetIfNoSpace);
        CardFaceSymbols.drawManaSymbol(this.lights.contains(1) ? "AL1ON" : "AL1OFF", g2, x, y);
        CardFaceSymbols.drawManaSymbol(this.lights.contains(2) ? "AL2ON" : "AL2OFF", g2, x + dx, y);
        CardFaceSymbols.drawManaSymbol(this.lights.contains(3) ? "AL3ON" : "AL3OFF", g2, x + dx * 2, y);
        CardFaceSymbols.drawManaSymbol(this.lights.contains(4) ? "AL4ON" : "AL4OFF", g2, x + dx * 3, y);
        CardFaceSymbols.drawManaSymbol(this.lights.contains(5) ? "AL5ON" : "AL5OFF", g2, x + dx * 4, y);
        CardFaceSymbols.drawManaSymbol(this.lights.contains(6) ? "AL6ON" : "AL6OFF", g2, x + dx * 5, y);
    }
}

