/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.item.InventoryItem;
import forge.itemmanager.ItemManager;
import forge.itemmanager.SFilterUtil;
import forge.itemmanager.filters.ItemFilter;
import forge.toolbox.FLabel;
import forge.toolbox.FSpinner;
import forge.toolbox.LayoutHelper;
import forge.util.ComparableOp;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;

public abstract class ValueRangeFilter<T extends InventoryItem>
extends ItemFilter<T> {
    private FLabel label;
    private FSpinner lowerBound;
    private FSpinner upperBound;

    protected ValueRangeFilter(ItemManager<? super T> itemManager0) {
        super(itemManager0);
    }

    protected abstract String getCaption();

    protected int minValue() {
        return 0;
    }

    protected int maxValue() {
        return 20;
    }

    @Override
    public final boolean isEmpty() {
        return this.lowerBound.getValue().equals(this.minValue()) && this.upperBound.getValue().equals(this.maxValue());
    }

    @Override
    public void reset() {
        this.lowerBound.setValue(this.minValue());
        this.upperBound.setValue(this.maxValue());
    }

    @Override
    public Component getMainComponent() {
        return ((JSpinner.DefaultEditor)this.lowerBound.getEditor()).getTextField();
    }

    @Override
    protected final void buildWidget(JPanel widget) {
        this.lowerBound = this.addSpinner(widget, true);
        String text = " <= " + this.getCaption() + " <= ";
        this.label = new FLabel.Builder().text(text).fontSize(12).build();
        widget.add(this.label);
        this.upperBound = this.addSpinner(widget, false);
        this.lowerBound.addChangeListener(arg0 -> {
            if (Integer.parseInt(this.upperBound.getValue().toString()) < Integer.parseInt(this.lowerBound.getValue().toString())) {
                this.upperBound.setValue(this.lowerBound.getValue());
            }
            this.applyChange();
        });
        this.upperBound.addChangeListener(arg0 -> {
            if (Integer.parseInt(this.lowerBound.getValue().toString()) > Integer.parseInt(this.upperBound.getValue().toString())) {
                this.lowerBound.setValue(this.upperBound.getValue());
            }
            this.applyChange();
        });
    }

    @Override
    protected void doWidgetLayout(LayoutHelper helper) {
        helper.include((JComponent)this.lowerBound, 45, 25);
        helper.include((JComponent)this.label, 125, 26);
        helper.include((JComponent)this.upperBound, 45, 25);
    }

    private FSpinner addSpinner(JPanel widget, boolean lowerBound) {
        FSpinner spinner = new FSpinner.Builder().minValue(this.minValue()).maxValue(this.maxValue()).initialValue(lowerBound ? this.minValue() : this.maxValue()).build();
        spinner.setFocusable(false);
        widget.add(spinner);
        return spinner;
    }

    protected Predicate<CardRules> getCardRulesFieldPredicate(CardRulesPredicates.LeafNumber.CardField field) {
        int lowerValue = Integer.parseInt(this.lowerBound.getValue().toString());
        int upperValue = Integer.parseInt(this.upperBound.getValue().toString());
        boolean hasMin = lowerValue != this.minValue();
        boolean hasMax = upperValue != this.maxValue();
        CardRulesPredicates.LeafNumber pLower = hasMin ? new CardRulesPredicates.LeafNumber(field, ComparableOp.GT_OR_EQUAL, lowerValue) : null;
        CardRulesPredicates.LeafNumber pUpper = hasMax ? new CardRulesPredicates.LeafNumber(field, ComparableOp.LT_OR_EQUAL, upperValue) : null;
        return SFilterUtil.optimizedAnd(pLower, pUpper);
    }

    @Override
    public boolean merge(ItemFilter<?> filter) {
        return true;
    }
}

