/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import forge.item.InventoryItem;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.ItemFilter;
import forge.toolbox.FLabel;
import forge.toolbox.FSkin;
import forge.toolbox.LayoutHelper;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class ToggleButtonsFilter<T extends InventoryItem>
extends ItemFilter<T> {
    protected boolean lockFiltering;
    private final List<FLabel> buttons = new ArrayList<FLabel>();

    protected ToggleButtonsFilter(ItemManager<? super T> itemManager0) {
        super(itemManager0);
    }

    protected FLabel addToggleButton(JPanel widget, FSkin.SkinImage icon, String tooltip) {
        FLabel button = new FLabel.Builder().icon(icon).iconScaleAuto(false).fontSize(11).tooltip(tooltip).hoverable().selectable(true).selected(true).build();
        button.setCommand(() -> {
            if (this.lockFiltering) {
                return;
            }
            this.applyChange();
        });
        this.buttons.add(button);
        widget.add(button);
        return button;
    }

    @Override
    protected void doWidgetLayout(LayoutHelper helper) {
        int availableWidth = helper.getParentWidth() - (this.buttons.size() - 1) * 2;
        int buttonWidth = availableWidth / this.buttons.size();
        Graphics g2 = this.buttons.get(0).getGraphics();
        if (buttonWidth <= 0 || g2 == null) {
            return;
        }
        int maxTextWidth = buttonWidth - 8;
        for (FLabel btn : this.buttons) {
            if (btn.getText() != null && !btn.getText().isEmpty()) {
                int max = maxTextWidth;
                Icon icon = btn.getIcon();
                if (icon != null) {
                    max -= icon.getIconWidth() + 4;
                }
                for (int fs = 11; fs > 5; --fs) {
                    FSkin.SkinFont skinFont = FSkin.getFont(fs);
                    if (skinFont.measureTextWidth(g2, btn.getText()) > max) continue;
                    btn.setFont(skinFont);
                    break;
                }
            }
            helper.include((JComponent)btn, buttonWidth, 25);
            helper.offset(-1, 0);
        }
    }

    @Override
    public final boolean isEmpty() {
        for (FLabel button : this.buttons) {
            if (button.isSelected()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        for (FLabel button : this.buttons) {
            button.setSelected(true);
        }
    }

    @Override
    public boolean merge(ItemFilter<?> filter) {
        return true;
    }
}

