/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.item.InventoryItem;
import forge.itemmanager.ItemManager;
import forge.itemmanager.SFilterUtil;
import forge.itemmanager.filters.ItemFilter;
import forge.toolbox.FTextField;
import forge.toolbox.LayoutHelper;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.Timer;

public class TextSearchFilter<T extends InventoryItem>
extends ItemFilter<T> {
    protected FTextField txtSearch;
    private Timer changeTimer = new Timer(200, arg0 -> this.applyChange());

    public TextSearchFilter(ItemManager<? super T> itemManager0) {
        super(itemManager0);
    }

    @Override
    public ItemFilter<T> createCopy() {
        TextSearchFilter<T> copy = new TextSearchFilter<T>(this.itemManager);
        copy.getWidget();
        copy.txtSearch.setText(this.txtSearch.getText());
        return copy;
    }

    @Override
    public boolean isEmpty() {
        return this.txtSearch.isEmpty();
    }

    @Override
    public void reset() {
        this.txtSearch.setText("");
    }

    @Override
    public Component getMainComponent() {
        return this.txtSearch;
    }

    @Override
    public boolean merge(ItemFilter<?> filter) {
        return false;
    }

    @Override
    protected void buildWidget(JPanel widget) {
        this.txtSearch = new FTextField.Builder().ghostText(Localizer.getInstance().getMessage("lblSearch", new Object[0])).build();
        widget.add(this.txtSearch);
        this.txtSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                switch (e.getKeyCode()) {
                    case 33: 
                    case 34: 
                    case 38: 
                    case 40: {
                        if (TextSearchFilter.this.changeTimer.isRunning()) {
                            TextSearchFilter.this.applyChange();
                        }
                        TextSearchFilter.this.itemManager.focus();
                        break;
                    }
                    case 10: {
                        if (e.getModifiersEx() != 0 || !TextSearchFilter.this.changeTimer.isRunning()) break;
                        TextSearchFilter.this.applyChange();
                    }
                }
            }
        });
        this.txtSearch.addChangeListener(new FTextField.ChangeListener(){

            @Override
            public void textChanged() {
                TextSearchFilter.this.changeTimer.restart();
            }
        });
    }

    @Override
    protected void doWidgetLayout(LayoutHelper helper) {
        helper.fillLine(this.txtSearch, 25);
    }

    @Override
    protected void applyChange() {
        this.changeTimer.stop();
        super.applyChange();
    }

    @Override
    protected Predicate<T> buildPredicate() {
        String text = this.txtSearch.getText();
        if (text.trim().isEmpty()) {
            return Predicates.alwaysTrue();
        }
        return SFilterUtil.buildItemTextFilter(text);
    }
}

