/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicates;
import forge.gui.GuiBase;
import forge.item.InventoryItem;
import forge.item.ItemPredicate;
import forge.item.PaperCard;
import forge.itemmanager.ItemManager;
import forge.itemmanager.SFilterUtil;
import forge.itemmanager.SItemManagerUtil;
import forge.itemmanager.filters.ToggleButtonsFilter;
import forge.toolbox.FLabel;
import forge.toolbox.FSkin;
import forge.util.ItemPool;
import forge.util.Localizer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;

public abstract class StatTypeFilter<T extends InventoryItem>
extends ToggleButtonsFilter<T> {
    protected final Map<SItemManagerUtil.StatTypes, FLabel> buttonMap = new HashMap<SItemManagerUtil.StatTypes, FLabel>();

    public StatTypeFilter(ItemManager<? super T> itemManager0) {
        super(itemManager0);
    }

    protected void addToggleButton(JPanel widget, SItemManagerUtil.StatTypes st) {
        Localizer localizer = Localizer.getInstance();
        StringBuilder tooltip = new StringBuilder();
        tooltip.append(st.label);
        tooltip.append(" (").append(localizer.getMessage("lblclicktotoogle", new Object[0])).append(" ");
        if (st.label.length() > 1 && !Character.isUpperCase(st.label.charAt(1))) {
            tooltip.append(st.label.substring(0, 1).toLowerCase());
            tooltip.append(st.label.substring(1));
        } else {
            tooltip.append(st.label);
        }
        tooltip.append(")");
        int imageSize = Math.round(18.0f * GuiBase.getInterface().getScreenScale());
        FLabel button = this.addToggleButton(widget, FSkin.getImage(st.skinProp, imageSize, imageSize), tooltip.toString());
        this.buttonMap.put(st, button);
        button.setRightClickCommand(() -> {
            this.lockFiltering = true;
            SFilterUtil.showOnlyStat(st, button, this.buttonMap);
            this.lockFiltering = false;
            this.applyChange();
        });
    }

    @Override
    protected <U extends InventoryItem> boolean showUnsupportedItem(U item) {
        FLabel btnPackOrDeck = this.buttonMap.get(SItemManagerUtil.StatTypes.PACK_OR_DECK);
        if (btnPackOrDeck != null && btnPackOrDeck.isSelected()) {
            return ItemPredicate.Presets.IS_PACK_OR_DECK.apply(item);
        }
        return false;
    }

    @Override
    public void afterFiltersApplied() {
        ItemPool items = this.itemManager.getFilteredItems();
        FLabel btnPackOrDeck = this.buttonMap.get(SItemManagerUtil.StatTypes.PACK_OR_DECK);
        if (btnPackOrDeck != null) {
            int count = items.countAll(ItemPredicate.Presets.IS_PACK_OR_DECK, InventoryItem.class);
            btnPackOrDeck.setText(String.valueOf(count));
        }
        for (SItemManagerUtil.StatTypes statTypes : this.buttonMap.keySet()) {
            if (statTypes.predicate == null) continue;
            int count = items.countAll(Predicates.compose(statTypes.predicate, PaperCard::getRules), PaperCard.class);
            this.buttonMap.get(statTypes).setText(String.valueOf(count));
        }
        this.getWidget().revalidate();
    }
}

