/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import forge.item.InventoryItem;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.ItemFilter;
import forge.toolbox.FLabel;
import forge.toolbox.LayoutHelper;
import forge.util.TextUtil;
import javax.swing.JPanel;

public abstract class ListLabelFilter<T extends InventoryItem>
extends ItemFilter<T> {
    private FLabel label;

    protected ListLabelFilter(ItemManager<? super T> itemManager0) {
        super(itemManager0);
    }

    protected abstract String getCaption();

    protected abstract Iterable<String> getList();

    protected abstract String getTooltip();

    protected abstract int getCount();

    @Override
    public final boolean isEmpty() {
        return this.getCount() == 0;
    }

    @Override
    protected final void buildWidget(JPanel widget) {
        this.label = new FLabel.Builder().fontAlign(2).fontSize(12).build();
        this.updateLabel();
        widget.add(this.label);
    }

    protected void updateLabel() {
        StringBuilder labelBuilder = new StringBuilder();
        labelBuilder.append(this.getCaption());
        switch (this.getCount()) {
            case 0: {
                labelBuilder.append("s: All");
                break;
            }
            case 1: {
                labelBuilder.append(": ").append(this.getList().iterator().next());
                break;
            }
            default: {
                labelBuilder.append("s: ").append(TextUtil.join(this.getList(), ", "));
            }
        }
        this.label.setText(labelBuilder.toString());
        this.label.setToolTipText(this.getTooltip());
    }

    @Override
    protected void doWidgetLayout(LayoutHelper helper) {
        helper.fillLine(this.label, 25);
    }
}

