/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import forge.gui.framework.ILocalRepaint;
import forge.item.InventoryItem;
import forge.itemmanager.ItemManager;
import forge.toolbox.FSkin;
import forge.toolbox.LayoutHelper;
import forge.util.Localizer;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class ItemFilter<T extends InventoryItem> {
    public static final int PANEL_HEIGHT = 28;
    protected final ItemManager<? super T> itemManager;
    private FilterPanel panel;
    private Widget widget;
    private final FSkin.SkinnedCheckBox chkEnable = new FSkin.SkinnedCheckBox();
    private final RemoveButton btnRemove = new RemoveButton();

    public static void layoutCheckbox(FSkin.SkinnedCheckBox cb) {
        cb.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        cb.setFont(FSkin.getFont());
        cb.setOpaque(false);
        cb.setFocusable(false);
    }

    protected ItemFilter(ItemManager<? super T> itemManager0) {
        this.itemManager = itemManager0;
        this.chkEnable.setSelected(true);
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new FilterPanel();
            ItemFilter.layoutCheckbox(this.chkEnable);
            this.chkEnable.addItemListener(arg0 -> {
                this.updateEnabled();
                this.applyChange();
            });
            this.panel.add(this.chkEnable);
            this.getWidget();
            if (!this.isEnabled()) {
                this.updateEnabled();
            }
            this.panel.add(this.widget);
            this.panel.add(this.btnRemove);
        }
        return this.panel;
    }

    public JPanel getWidget() {
        if (this.widget == null) {
            this.widget = new Widget();
            this.buildWidget(this.widget);
        }
        return this.widget;
    }

    public void refreshWidget() {
        if (this.widget == null) {
            return;
        }
        this.widget.removeAll();
        this.buildWidget(this.widget);
    }

    public Component getMainComponent() {
        return this.getWidget();
    }

    public boolean isEnabled() {
        return this.chkEnable.isSelected();
    }

    public void setEnabled(boolean enabled0) {
        this.chkEnable.setSelected(enabled0);
    }

    public boolean allowRemove() {
        return this.btnRemove.isVisible();
    }

    public void setAllowRemove(boolean b0) {
        this.btnRemove.setVisible(b0);
    }

    public void updateEnabled() {
        boolean enabled = this.isEnabled();
        for (Component comp : this.widget.getComponents()) {
            comp.setEnabled(enabled);
        }
    }

    protected void applyChange() {
        this.itemManager.applyFilters();
    }

    public final <U extends InventoryItem> Predicate<U> buildPredicate(Class<U> genericType) {
        Predicate<T> predicate = this.buildPredicate();
        return item -> {
            try {
                return predicate.apply(item);
            }
            catch (Exception ex) {
                return this.showUnsupportedItem(item);
            }
        };
    }

    protected <U extends InventoryItem> boolean showUnsupportedItem(U item) {
        return false;
    }

    public abstract ItemFilter<T> createCopy();

    public abstract boolean isEmpty();

    public abstract void reset();

    public void afterFiltersApplied() {
    }

    public abstract boolean merge(ItemFilter<?> var1);

    protected abstract void buildWidget(JPanel var1);

    protected abstract void doWidgetLayout(LayoutHelper var1);

    protected abstract Predicate<T> buildPredicate();

    private class RemoveButton
    extends JLabel
    implements ILocalRepaint {
        private final FSkin.SkinColor iconColor = FSkin.getColor(FSkin.Colors.CLR_TEXT);
        private boolean pressed;
        private boolean hovered;

        private RemoveButton() {
            this.setToolTipText(Localizer.getInstance().getMessage("lblRemoveFilter", new Object[0]));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!RemoveButton.this.isEnabled()) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        RemoveButton.this.pressed = true;
                        RemoveButton.this.repaintSelf();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (RemoveButton.this.pressed && SwingUtilities.isLeftMouseButton(e)) {
                        RemoveButton.this.pressed = false;
                        if (RemoveButton.this.hovered) {
                            RemoveButton.this.repaintSelf();
                            ItemFilter.this.itemManager.focus();
                            ItemFilter.this.itemManager.removeFilter(ItemFilter.this);
                        }
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!RemoveButton.this.isEnabled()) {
                        return;
                    }
                    RemoveButton.this.hovered = true;
                    RemoveButton.this.repaintSelf();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (RemoveButton.this.hovered) {
                        RemoveButton.this.hovered = false;
                        RemoveButton.this.repaintSelf();
                    }
                }
            });
        }

        @Override
        public void setEnabled(boolean enabled0) {
            if (!enabled0 && this.hovered) {
                this.hovered = false;
            }
            super.setEnabled(enabled0);
        }

        @Override
        public void repaintSelf() {
            Dimension d = this.getSize();
            this.repaint(0, 0, d.width, d.height);
        }

        @Override
        public void paintComponent(Graphics g2) {
            int offset;
            super.paintComponent(g2);
            int thickness = 2;
            int x1 = offset = 4;
            int y1 = offset;
            int x2 = this.getWidth() - offset - 1;
            int y2 = this.getHeight() - offset - 1;
            Graphics2D g2d = (Graphics2D)g2;
            if (this.hovered) {
                if (this.pressed) {
                    g2.translate(1, 1);
                }
                FSkin.setGraphicsColor(g2d, this.iconColor);
            } else {
                FSkin.setGraphicsColor(g2d, this.iconColor.alphaColor(150));
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setStroke(new BasicStroke(thickness));
            g2d.drawLine(x1, y1, x2, y2);
            g2d.drawLine(x2, y1, x1, y2);
        }
    }

    private class Widget
    extends JPanel {
        private Widget() {
            this.setLayout(null);
            this.setOpaque(false);
        }

        @Override
        public void doLayout() {
            LayoutHelper helper = new LayoutHelper(this);
            ItemFilter.this.doWidgetLayout(helper);
        }
    }

    private class FilterPanel
    extends FSkin.SkinnedPanel {
        private FilterPanel() {
            this.setLayout(null);
            this.setOpaque(false);
            this.setBorder(new FSkin.MatteSkinBorder(0, 0, 1, 0, FSkin.getColor(FSkin.Colors.CLR_TEXT)));
        }

        @Override
        public void doLayout() {
            LayoutHelper helper = new LayoutHelper(this);
            int removeButtonSize = ItemFilter.this.allowRemove() ? 17 : 0;
            helper.include((JComponent)ItemFilter.this.chkEnable, 23, 25);
            helper.offset(-3, 0);
            helper.fillLine(ItemFilter.this.widget, 28, removeButtonSize);
            if (removeButtonSize > 0) {
                helper.offset(-3, (28 - removeButtonSize) / 2 - 1);
                helper.include((JComponent)ItemFilter.this.btnRemove, removeButtonSize, removeButtonSize);
            }
        }
    }
}

