/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import forge.card.CardEdition;
import forge.game.GameFormat;
import forge.item.InventoryItem;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.filters.ListLabelFilter;
import forge.model.FModel;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class FormatFilter<T extends InventoryItem>
extends ListLabelFilter<T> {
    protected boolean allowReprints = true;
    protected final Set<GameFormat> formats = new HashSet<GameFormat>();

    public FormatFilter(ItemManager<? super T> itemManager0) {
        super(itemManager0);
    }

    public FormatFilter(ItemManager<? super T> itemManager0, GameFormat format0) {
        super(itemManager0);
        this.formats.add(format0);
    }

    @Override
    protected String getTooltip() {
        HashSet<String> sets = new HashSet<String>();
        HashSet<String> bannedCards = new HashSet<String>();
        HashSet additionalCards = new HashSet();
        for (GameFormat format : this.formats) {
            Object formatAdditionalCards;
            List<String> formatBannedCards;
            List<String> formatSets = format.getAllowedSetCodes();
            if (formatSets != null) {
                sets.addAll(formatSets);
            }
            if ((formatBannedCards = format.getBannedCardNames()) != null) {
                bannedCards.addAll(formatBannedCards);
            }
            if ((formatAdditionalCards = format.getAdditionalCards()) == null) continue;
            additionalCards.addAll(formatAdditionalCards);
        }
        int lastLen = 0;
        int lineLen = 0;
        StringBuilder tooltip = new StringBuilder("<html>Sets:");
        if (sets.isEmpty()) {
            tooltip.append(" All");
        } else {
            CardEdition.Collection editions = FModel.getMagicDb().getEditions();
            for (String code : sets) {
                CardEdition edition;
                if (50 < lineLen) {
                    tooltip.append("<br>");
                    lastLen += lineLen;
                    lineLen = 0;
                }
                if ((edition = editions.get(code)) != null) {
                    tooltip.append(" ").append(edition.getName()).append(" (").append(code).append("),");
                }
                lineLen = tooltip.length() - lastLen;
            }
            tooltip.delete(tooltip.length() - 1, tooltip.length());
            if (this.allowReprints) {
                tooltip.append("<br><br>Allowing identical cards from other sets");
            }
        }
        if (!bannedCards.isEmpty()) {
            tooltip.append("<br><br>Banned:");
            lastLen += lineLen;
            lineLen = 0;
            for (String cardName : bannedCards) {
                if (50 < lineLen) {
                    tooltip.append("<br>");
                    lastLen += lineLen;
                    lineLen = 0;
                }
                tooltip.append(" ").append(cardName).append(";");
                lineLen = tooltip.length() - lastLen;
            }
            tooltip.delete(tooltip.length() - 1, tooltip.length());
        }
        if (!additionalCards.isEmpty()) {
            tooltip.append("<br><br>Additional:");
            lastLen += lineLen;
            lineLen = 0;
            for (String cardName : additionalCards) {
                if (50 < lineLen) {
                    tooltip.append("<br>");
                    lastLen += lineLen;
                    lineLen = 0;
                }
                tooltip.append(" ").append(cardName).append(";");
                lineLen = tooltip.length() - lastLen;
            }
            tooltip.delete(tooltip.length() - 1, tooltip.length());
        }
        tooltip.append("</html>");
        return tooltip.toString();
    }

    @Override
    public void reset() {
        this.formats.clear();
        this.updateLabel();
    }

    public static <T extends InventoryItem> boolean canAddFormat(GameFormat format, FormatFilter<T> existingFilter) {
        return existingFilter == null || !existingFilter.formats.contains(format);
    }

    @Override
    public boolean merge(ItemFilter<?> filter) {
        FormatFilter formatFilter = (FormatFilter)filter;
        this.formats.addAll(formatFilter.formats);
        this.allowReprints = formatFilter.allowReprints;
        return true;
    }

    @Override
    protected String getCaption() {
        return "Format";
    }

    @Override
    protected int getCount() {
        return this.formats.size();
    }

    @Override
    protected Iterable<String> getList() {
        HashSet<String> strings = new HashSet<String>();
        for (GameFormat f : this.formats) {
            strings.add(f.getName());
        }
        return strings;
    }
}

