/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import forge.deck.DeckProxy;
import forge.game.GameFormat;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.DeckFormatFilter;
import forge.itemmanager.filters.ItemFilter;
import forge.screens.home.quest.DialogChooseSets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DeckSetFilter
extends DeckFormatFilter {
    protected final Set<String> sets = new HashSet<String>();
    protected final Set<String> limitedSets = new HashSet<String>();

    public DeckSetFilter(ItemManager<? super DeckProxy> itemManager0, Collection<String> sets0, boolean allowReprints0) {
        super(itemManager0);
        this.sets.addAll(sets0);
        this.formats.add(new GameFormat(null, this.sets, null));
        this.allowReprints = allowReprints0;
    }

    public DeckSetFilter(ItemManager<? super DeckProxy> itemManager0, Collection<String> sets0, Collection<String> limitedSets0, boolean allowReprints0) {
        this(itemManager0, sets0, allowReprints0);
        if (limitedSets0 != null) {
            this.limitedSets.addAll(limitedSets0);
        }
    }

    @Override
    public ItemFilter<DeckProxy> createCopy() {
        return new DeckSetFilter(this.itemManager, this.sets, this.allowReprints);
    }

    @Override
    public void reset() {
        this.sets.clear();
        super.reset();
    }

    @Override
    public boolean merge(ItemFilter<?> filter) {
        DeckSetFilter cardSetFilter = (DeckSetFilter)filter;
        this.sets.addAll(cardSetFilter.sets);
        this.limitedSets.addAll(cardSetFilter.limitedSets);
        this.allowReprints = cardSetFilter.allowReprints;
        this.formats.clear();
        this.formats.add(new GameFormat(null, this.sets, null));
        return true;
    }

    @Override
    public void edit() {
        DialogChooseSets dialog = new DialogChooseSets(this.sets, null, this.limitedSets, true, this.allowReprints);
        DeckSetFilter itemFilter = this;
        dialog.setOkCallback(() -> {
            this.sets.clear();
            this.sets.addAll(dialog.getSelectedSets());
            this.allowReprints = dialog.getWantReprints();
            this.formats.clear();
            this.formats.add(new GameFormat(null, this.sets, null));
            this.itemManager.addFilter(itemFilter);
        });
    }

    @Override
    protected String getCaption() {
        return "Set";
    }

    @Override
    protected int getCount() {
        return this.sets.size();
    }

    @Override
    protected Iterable<String> getList() {
        return this.sets;
    }

    @Override
    protected Predicate<DeckProxy> buildPredicate() {
        return input -> input != null && this.sets.contains(input.getEdition().getCode());
    }
}

