/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import forge.deck.DeckProxy;
import forge.game.GameFormat;
import forge.gamemodes.quest.QuestWorld;
import forge.gamemodes.quest.data.GameFormatQuest;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.DeckFormatFilter;
import forge.itemmanager.filters.ItemFilter;
import forge.model.FModel;
import java.util.HashSet;
import java.util.Set;

public class DeckQuestWorldFilter
extends DeckFormatFilter {
    private final Set<QuestWorld> questWorlds = new HashSet<QuestWorld>();

    public DeckQuestWorldFilter(ItemManager<? super DeckProxy> itemManager0) {
        super(itemManager0);
    }

    public DeckQuestWorldFilter(ItemManager<? super DeckProxy> itemManager0, QuestWorld questWorld0) {
        super(itemManager0);
        this.questWorlds.add(questWorld0);
        this.formats.add(DeckQuestWorldFilter.getQuestWorldFormat(questWorld0));
    }

    @Override
    public ItemFilter<DeckProxy> createCopy() {
        DeckQuestWorldFilter copy = new DeckQuestWorldFilter(this.itemManager);
        copy.questWorlds.addAll(this.questWorlds);
        for (QuestWorld w : this.questWorlds) {
            copy.formats.add(DeckQuestWorldFilter.getQuestWorldFormat(w));
        }
        return copy;
    }

    @Override
    public void reset() {
        this.questWorlds.clear();
        super.reset();
    }

    public static boolean canAddQuestWorld(QuestWorld questWorld, ItemFilter<DeckProxy> existingFilter) {
        if (questWorld.getFormat() == null && FModel.getQuest().getMainFormat() == null) {
            return false;
        }
        return existingFilter == null || !((DeckQuestWorldFilter)existingFilter).questWorlds.contains(questWorld);
    }

    @Override
    public boolean merge(ItemFilter<?> filter) {
        DeckQuestWorldFilter cardQuestWorldFilter = (DeckQuestWorldFilter)filter;
        this.questWorlds.addAll(cardQuestWorldFilter.questWorlds);
        for (QuestWorld w : cardQuestWorldFilter.questWorlds) {
            this.formats.add(DeckQuestWorldFilter.getQuestWorldFormat(w));
        }
        return true;
    }

    @Override
    protected String getCaption() {
        return "Quest World";
    }

    @Override
    protected int getCount() {
        return this.questWorlds.size();
    }

    @Override
    protected Iterable<String> getList() {
        HashSet<String> strings = new HashSet<String>();
        for (QuestWorld w : this.questWorlds) {
            strings.add(w.getName());
        }
        return strings;
    }

    private static GameFormat getQuestWorldFormat(QuestWorld w) {
        GameFormatQuest format = w.getFormat();
        if (format == null) {
            format = FModel.getQuest().getMainFormat();
        }
        return format;
    }
}

