/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import forge.deck.DeckProxy;
import forge.itemmanager.ItemManager;
import forge.itemmanager.SFilterUtil;
import forge.itemmanager.SItemManagerUtil;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.filters.StatTypeFilter;
import forge.toolbox.FLabel;
import forge.util.ItemPool;
import javax.swing.JPanel;

public class DeckColorFilter
extends StatTypeFilter<DeckProxy> {
    public DeckColorFilter(ItemManager<? super DeckProxy> itemManager0) {
        super(itemManager0);
    }

    @Override
    public ItemFilter<DeckProxy> createCopy() {
        return new DeckColorFilter(this.itemManager);
    }

    @Override
    protected void buildWidget(JPanel widget) {
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.DECK_WHITE);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.DECK_BLUE);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.DECK_BLACK);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.DECK_RED);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.DECK_GREEN);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.DECK_COLORLESS);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.DECK_MULTICOLOR);
    }

    @Override
    protected final Predicate<DeckProxy> buildPredicate() {
        return SFilterUtil.buildDeckColorFilter(this.buttonMap);
    }

    @Override
    public void afterFiltersApplied() {
        ItemPool items = this.itemManager.getFilteredItems();
        ((FLabel)this.buttonMap.get(SItemManagerUtil.StatTypes.DECK_WHITE)).setText(String.valueOf(items.countAll(DeckProxy.IS_WHITE, DeckProxy.class)));
        ((FLabel)this.buttonMap.get(SItemManagerUtil.StatTypes.DECK_BLUE)).setText(String.valueOf(items.countAll(DeckProxy.IS_BLUE, DeckProxy.class)));
        ((FLabel)this.buttonMap.get(SItemManagerUtil.StatTypes.DECK_BLACK)).setText(String.valueOf(items.countAll(DeckProxy.IS_BLACK, DeckProxy.class)));
        ((FLabel)this.buttonMap.get(SItemManagerUtil.StatTypes.DECK_RED)).setText(String.valueOf(items.countAll(DeckProxy.IS_RED, DeckProxy.class)));
        ((FLabel)this.buttonMap.get(SItemManagerUtil.StatTypes.DECK_GREEN)).setText(String.valueOf(items.countAll(DeckProxy.IS_GREEN, DeckProxy.class)));
        ((FLabel)this.buttonMap.get(SItemManagerUtil.StatTypes.DECK_COLORLESS)).setText(String.valueOf(items.countAll(DeckProxy.IS_COLORLESS, DeckProxy.class)));
        ((FLabel)this.buttonMap.get(SItemManagerUtil.StatTypes.DECK_MULTICOLOR)).setText(String.valueOf(items.countAll(DeckProxy.IS_MULTICOLOR, DeckProxy.class)));
        this.getWidget().revalidate();
    }
}

