/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.card.CardRules;
import forge.item.PaperCard;
import forge.itemmanager.ItemManager;
import forge.itemmanager.SItemManagerUtil;
import forge.itemmanager.SpellShopManager;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.filters.StatTypeFilter;
import forge.toolbox.FLabel;
import java.util.ArrayList;
import javax.swing.JPanel;

public class CardTypeFilter
extends StatTypeFilter<PaperCard> {
    public CardTypeFilter(ItemManager<? super PaperCard> itemManager0) {
        super(itemManager0);
    }

    @Override
    public ItemFilter<PaperCard> createCopy() {
        return new CardTypeFilter(this.itemManager);
    }

    @Override
    protected void buildWidget(JPanel widget) {
        if (this.itemManager instanceof SpellShopManager) {
            this.addToggleButton(widget, SItemManagerUtil.StatTypes.PACK_OR_DECK);
        }
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.LAND);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.ARTIFACT);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.CREATURE);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.ENCHANTMENT);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.PLANESWALKER);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.INSTANT);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.SORCERY);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.BATTLE);
    }

    @Override
    protected final Predicate<PaperCard> buildPredicate() {
        ArrayList<Predicate<CardRules>> types = new ArrayList<Predicate<CardRules>>();
        for (SItemManagerUtil.StatTypes s2 : this.buttonMap.keySet()) {
            if (s2.predicate == null || !((FLabel)this.buttonMap.get(s2)).isSelected()) continue;
            types.add(s2.predicate);
        }
        if (types.size() == this.buttonMap.size()) {
            return card -> true;
        }
        return Predicates.compose(Predicates.or(types), PaperCard::getRules);
    }
}

