/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.ItemManager;
import forge.itemmanager.SFilterUtil;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.filters.TextSearchFilter;
import forge.toolbox.FComboBoxWrapper;
import forge.toolbox.FLabel;
import forge.toolbox.LayoutHelper;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CardSearchFilter
extends TextSearchFilter<PaperCard> {
    private FComboBoxWrapper<String> cbSearchMode;
    private FLabel btnName;
    private FLabel btnType;
    private FLabel btnText;
    private FLabel btnCost;

    public CardSearchFilter(ItemManager<? super PaperCard> itemManager0) {
        super(itemManager0);
    }

    @Override
    public ItemFilter<PaperCard> createCopy() {
        CardSearchFilter copy = new CardSearchFilter(this.itemManager);
        copy.getWidget();
        copy.txtSearch.setText(this.txtSearch.getText());
        copy.cbSearchMode.setSelectedIndex(this.cbSearchMode.getSelectedIndex());
        copy.btnName.setSelected(this.btnName.isSelected());
        copy.btnType.setSelected(this.btnType.isSelected());
        copy.btnText.setSelected(this.btnText.isSelected());
        copy.btnCost.setSelected(this.btnCost.isSelected());
        return copy;
    }

    @Override
    public void reset() {
        super.reset();
        this.cbSearchMode.setSelectedIndex(0);
        this.btnName.setSelected(true);
        this.btnType.setSelected(true);
        this.btnText.setSelected(true);
        this.btnCost.setSelected(false);
    }

    @Override
    protected final void buildWidget(JPanel widget) {
        super.buildWidget(widget);
        this.cbSearchMode = new FComboBoxWrapper();
        this.cbSearchMode.addItem("in");
        this.cbSearchMode.addItem("not in");
        this.cbSearchMode.addTo(widget);
        this.cbSearchMode.addItemListener(arg0 -> {
            if (!this.txtSearch.isEmpty()) {
                this.applyChange();
            }
        });
        this.btnName = this.addButton(widget, "Name");
        this.btnType = this.addButton(widget, "Type");
        this.btnText = this.addButton(widget, "Text");
        this.btnCost = this.addButton(widget, "Cost");
        this.btnCost.setSelected(false);
    }

    @Override
    protected void doWidgetLayout(LayoutHelper helper) {
        int comboBoxWidth = 61;
        int buttonWidth = 51;
        helper.fillLine(this.txtSearch, 25, 281);
        helper.include(this.cbSearchMode.getComponent(), 61, 25);
        helper.include((JComponent)this.btnName, 51, 25);
        helper.include((JComponent)this.btnType, 51, 25);
        helper.include((JComponent)this.btnText, 51, 25);
        helper.include((JComponent)this.btnCost, 51, 25);
    }

    private FLabel addButton(JPanel widget, String text) {
        FLabel button = new FLabel.Builder().text(text).hoverable().selectable().selected().build();
        button.setCommand(this::applyChange);
        widget.add(button);
        return button;
    }

    @Override
    protected Predicate<PaperCard> buildPredicate() {
        return SFilterUtil.buildTextFilter(this.txtSearch.getText(), this.cbSearchMode.getSelectedIndex() != 0, this.btnName.isSelected(), this.btnType.isSelected(), this.btnText.isSelected(), this.btnCost.isSelected());
    }

    @Override
    protected <U extends InventoryItem> boolean showUnsupportedItem(U item) {
        boolean result;
        boolean bl = result = this.btnName.isSelected() && SFilterUtil.buildItemTextFilter(this.txtSearch.getText()).apply(item);
        if (this.cbSearchMode.getSelectedIndex() != 0) {
            result = !result;
        }
        return result;
    }
}

