/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import forge.game.GameFormat;
import forge.gamemodes.quest.QuestWorld;
import forge.gamemodes.quest.data.GameFormatQuest;
import forge.item.PaperCard;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.CardFormatFilter;
import forge.itemmanager.filters.ItemFilter;
import forge.model.FModel;
import java.util.HashSet;
import java.util.Set;

public class CardQuestWorldFilter
extends CardFormatFilter {
    private final Set<QuestWorld> questWorlds = new HashSet<QuestWorld>();

    public CardQuestWorldFilter(ItemManager<? super PaperCard> itemManager0) {
        this(itemManager0, true);
    }

    public CardQuestWorldFilter(ItemManager<? super PaperCard> itemManager0, boolean allowReprints) {
        super(itemManager0);
        this.allowReprints = allowReprints;
    }

    public CardQuestWorldFilter(ItemManager<? super PaperCard> itemManager0, QuestWorld questWorld0) {
        this(itemManager0, questWorld0, true);
    }

    public CardQuestWorldFilter(ItemManager<? super PaperCard> itemManager0, QuestWorld questWorld0, boolean allowReprints) {
        super(itemManager0);
        this.questWorlds.add(questWorld0);
        this.formats.add(CardQuestWorldFilter.getQuestWorldFormat(questWorld0));
        this.allowReprints = allowReprints;
    }

    @Override
    public ItemFilter<PaperCard> createCopy() {
        CardQuestWorldFilter copy = new CardQuestWorldFilter(this.itemManager);
        copy.questWorlds.addAll(this.questWorlds);
        for (QuestWorld w : this.questWorlds) {
            copy.formats.add(CardQuestWorldFilter.getQuestWorldFormat(w));
        }
        return copy;
    }

    @Override
    public void reset() {
        this.questWorlds.clear();
        super.reset();
    }

    public static boolean canAddQuestWorld(QuestWorld questWorld, ItemFilter<PaperCard> existingFilter) {
        if (questWorld.getFormat() == null && FModel.getQuest().getMainFormat() == null) {
            return false;
        }
        return existingFilter == null || !((CardQuestWorldFilter)existingFilter).questWorlds.contains(questWorld);
    }

    @Override
    public boolean merge(ItemFilter<?> filter) {
        CardQuestWorldFilter cardQuestWorldFilter = (CardQuestWorldFilter)filter;
        this.questWorlds.addAll(cardQuestWorldFilter.questWorlds);
        for (QuestWorld w : cardQuestWorldFilter.questWorlds) {
            this.formats.add(CardQuestWorldFilter.getQuestWorldFormat(w));
        }
        return true;
    }

    @Override
    protected String getCaption() {
        return "Quest World";
    }

    @Override
    protected int getCount() {
        return this.questWorlds.size();
    }

    @Override
    protected Iterable<String> getList() {
        HashSet<String> strings = new HashSet<String>();
        for (QuestWorld w : this.questWorlds) {
            strings.add(w.getName());
        }
        return strings;
    }

    private static GameFormat getQuestWorldFormat(QuestWorld w) {
        GameFormatQuest format = w.getFormat();
        if (format == null) {
            format = FModel.getQuest().getMainFormat();
        }
        return format;
    }
}

