/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import forge.game.GameFormat;
import forge.item.PaperCard;
import forge.itemmanager.ItemManager;
import forge.itemmanager.SFilterUtil;
import forge.itemmanager.filters.FormatFilter;
import forge.itemmanager.filters.ItemFilter;
import forge.screens.home.quest.DialogChooseFormats;
import java.util.List;

public class CardFormatFilter
extends FormatFilter<PaperCard> {
    public CardFormatFilter(ItemManager<? super PaperCard> itemManager0) {
        super(itemManager0);
    }

    public CardFormatFilter(ItemManager<? super PaperCard> itemManager0, GameFormat format0) {
        super(itemManager0, format0);
    }

    public CardFormatFilter(ItemManager<? super PaperCard> itemManager0, List<GameFormat> formats0, boolean allowReprints0) {
        super(itemManager0);
        this.formats.addAll(formats0);
        this.allowReprints = allowReprints0;
    }

    @Override
    public ItemFilter<PaperCard> createCopy() {
        CardFormatFilter copy = new CardFormatFilter(this.itemManager);
        copy.formats.addAll(this.formats);
        return copy;
    }

    @Override
    protected final Predicate<PaperCard> buildPredicate() {
        return SFilterUtil.buildFormatFilter(this.formats, this.allowReprints);
    }

    public void edit(ItemManager<? super PaperCard> itemManager) {
        DialogChooseFormats dialog = new DialogChooseFormats(this.formats);
        CardFormatFilter itemFilter = this;
        dialog.setWantReprintsCB(this.allowReprints);
        dialog.setOkCallback(() -> {
            this.formats.clear();
            this.formats.addAll(dialog.getSelectedFormats());
            this.allowReprints = dialog.getWantReprints();
            itemManager.addFilter(itemFilter);
        });
    }
}

