/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.card.CardRules;
import forge.item.PaperCard;
import forge.itemmanager.ItemManager;
import forge.itemmanager.SItemManagerUtil;
import forge.itemmanager.SpellShopManager;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.filters.StatTypeFilter;
import forge.toolbox.FLabel;
import java.util.ArrayList;
import javax.swing.JPanel;

public class CardCMCFilter
extends StatTypeFilter<PaperCard> {
    public CardCMCFilter(ItemManager<? super PaperCard> itemManager0) {
        super(itemManager0);
    }

    @Override
    public ItemFilter<PaperCard> createCopy() {
        return new CardCMCFilter(this.itemManager);
    }

    @Override
    protected void buildWidget(JPanel widget) {
        if (this.itemManager instanceof SpellShopManager) {
            this.addToggleButton(widget, SItemManagerUtil.StatTypes.PACK_OR_DECK);
        }
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.CMC_0);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.CMC_1);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.CMC_2);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.CMC_3);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.CMC_4);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.CMC_5);
        this.addToggleButton(widget, SItemManagerUtil.StatTypes.CMC_6);
    }

    @Override
    protected final Predicate<PaperCard> buildPredicate() {
        ArrayList<Predicate<CardRules>> cmcs = new ArrayList<Predicate<CardRules>>();
        for (SItemManagerUtil.StatTypes s2 : this.buttonMap.keySet()) {
            if (s2.predicate == null || !((FLabel)this.buttonMap.get(s2)).isSelected()) continue;
            cmcs.add(s2.predicate);
        }
        if (cmcs.size() == this.buttonMap.size()) {
            return card -> true;
        }
        return Predicates.compose(Predicates.or(cmcs), PaperCard::getRules);
    }
}

