/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import forge.game.GameFormat;
import forge.item.PaperCard;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.CardSetFilter;
import forge.itemmanager.filters.ItemFilter;
import forge.model.FModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CardBlockFilter
extends CardSetFilter {
    private final Set<GameFormat> selectedBlocks = new HashSet<GameFormat>();
    private GameFormat cardBlock;

    public CardBlockFilter(ItemManager<? super PaperCard> itemManager0, GameFormat cardBlock) {
        super(itemManager0, (Collection<String>)cardBlock.getAllowedSetCodes(), false);
        this.formats.add(cardBlock);
        this.cardBlock = cardBlock;
        this.selectedBlocks.add(cardBlock);
    }

    private CardBlockFilter(ItemManager<? super PaperCard> itemManager0, GameFormat cardBlock, Set<GameFormat> selectedBlocks) {
        this(itemManager0, cardBlock);
        this.selectedBlocks.addAll(selectedBlocks);
    }

    @Override
    public ItemFilter<PaperCard> createCopy() {
        return new CardBlockFilter((ItemManager<? super PaperCard>)this.itemManager, this.cardBlock, this.selectedBlocks);
    }

    public static boolean canAddCardBlockWorld(GameFormat cardBlock, ItemFilter<PaperCard> existingFilter) {
        if (cardBlock == null || FModel.getBlocks() == null) {
            return false;
        }
        return existingFilter == null || !((CardBlockFilter)existingFilter).selectedBlocks.contains(cardBlock);
    }

    @Override
    public boolean merge(ItemFilter<?> filter) {
        CardBlockFilter cardBlockFilter = (CardBlockFilter)filter;
        this.selectedBlocks.addAll(cardBlockFilter.selectedBlocks);
        this.sets.addAll(cardBlockFilter.sets);
        ArrayList<String> allBannedCards = new ArrayList<String>();
        for (GameFormat f : this.formats) {
            List<String> bannedCards = f.getBannedCardNames();
            if (bannedCards == null || bannedCards.size() <= 0) continue;
            allBannedCards.addAll(bannedCards);
        }
        this.formats.clear();
        this.formats.add(new GameFormat(null, this.sets, allBannedCards));
        return true;
    }

    @Override
    protected String getCaption() {
        return "Block";
    }

    @Override
    protected int getCount() {
        int setCount = 0;
        for (GameFormat block : this.selectedBlocks) {
            setCount += block.getAllowedSetCodes().size();
        }
        return setCount;
    }

    @Override
    protected Iterable<String> getList() {
        HashSet<String> strings = new HashSet<String>();
        for (GameFormat f : this.selectedBlocks) {
            strings.add(f.getName());
        }
        return strings;
    }
}

