/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import forge.gui.GuiUtils;
import forge.gui.UiCommand;
import forge.gui.interfaces.IButton;
import forge.item.InventoryItem;
import forge.itemmanager.AdvancedSearch;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.ItemFilter;
import forge.toolbox.FLabel;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FOptionPane;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.toolbox.LayoutHelper;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.ArrayUtils;

public class AdvancedSearchFilter<T extends InventoryItem>
extends ItemFilter<T> {
    private final AdvancedSearch.Model<T> model;
    private FLabel label;
    private EditDialog editDialog;
    private final Runnable onFilterChange = new Runnable(){

        @Override
        public void run() {
            AdvancedSearchFilter.this.model.updateExpression();
            AdvancedSearchFilter.this.itemManager.applyNewOrModifiedFilter(AdvancedSearchFilter.this);
        }
    };

    public AdvancedSearchFilter(ItemManager<? super T> itemManager0) {
        super(itemManager0);
        this.model = new AdvancedSearch.Model();
    }

    @Override
    public final boolean isEmpty() {
        return this.model.isEmpty();
    }

    @Override
    public void reset() {
        this.model.reset();
        this.editDialog = null;
    }

    @Override
    public ItemFilter<T> createCopy() {
        return new AdvancedSearchFilter<T>(this.itemManager);
    }

    @Override
    protected Predicate<T> buildPredicate() {
        return this.model.getPredicate();
    }

    @Override
    protected final void buildWidget(JPanel widget) {
        this.label = new FLabel.Builder().fontAlign(2).fontSize(12).build();
        this.label.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftDoubleClick(MouseEvent e) {
                AdvancedSearchFilter.this.edit();
            }

            @Override
            public void onRightClick(MouseEvent e) {
                boolean hasFilters;
                JPopupMenu menu = new JPopupMenu("AdvancedSearchContextMenu");
                boolean bl = hasFilters = !AdvancedSearchFilter.this.isEmpty();
                if (hasFilters) {
                    for (AdvancedSearch.IFilterControl control : AdvancedSearchFilter.this.model.getControls()) {
                        GuiUtils.addMenuItem(menu, FSkin.encodeSymbols(control.getFilter().toString(), false), null, () -> AdvancedSearchFilter.this.model.editFilterControl(control, AdvancedSearchFilter.this.onFilterChange));
                    }
                    GuiUtils.addSeparator(menu);
                }
                GuiUtils.addMenuItem(menu, Localizer.getInstance().getMessage("lblEditExpression", new Object[0]), null, AdvancedSearchFilter.this::edit);
                if (hasFilters) {
                    GuiUtils.addMenuItem(menu, Localizer.getInstance().getMessage("lblClearFilter", new Object[0]), null, () -> {
                        AdvancedSearchFilter.this.reset();
                        AdvancedSearchFilter.this.itemManager.applyNewOrModifiedFilter(AdvancedSearchFilter.this);
                    });
                }
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this.model.setLabel(this.label);
        widget.add(this.label);
    }

    @Override
    protected void doWidgetLayout(LayoutHelper helper) {
        helper.fillLine(this.label, 25);
    }

    public boolean edit() {
        if (this.editDialog == null) {
            this.editDialog = new EditDialog();
        }
        return this.editDialog.show();
    }

    @Override
    public boolean merge(ItemFilter<?> filter) {
        return false;
    }

    private class EditDialog {
        private static final int WIDTH = 400;
        private static final int HEIGHT = 500;
        private final JPanel panel;
        private final FScrollPane scroller;
        private FOptionPane optionPane;

        private EditDialog() {
            this.panel = new JPanel(null){

                @Override
                public void doLayout() {
                    int x = 0;
                    int y = 0;
                    int w = this.getWidth();
                    int h2 = 100;
                    for (Component child : this.getComponents()) {
                        child.setBounds(x, y, w, h2);
                        y += h2;
                    }
                }
            };
            this.panel.setOpaque(false);
            this.scroller = new FScrollPane(this.panel, false, 20, 31);
            this.scroller.setMinimumSize(new Dimension(400, 500));
            Filter filter = new Filter();
            AdvancedSearchFilter.this.model.addFilterControl(filter);
            this.panel.add(filter);
        }

        private boolean show() {
            this.optionPane = new FOptionPane(null, Localizer.getInstance().getMessage("lblAdvancedSearch", new Object[0]), null, this.scroller, ImmutableList.of(Localizer.getInstance().getMessage("lblOK", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0])), 0);
            this.optionPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    if (AdvancedSearchFilter.this.model.isEmpty()) {
                        AdvancedSearchFilter.this.model.editFilterControl(Iterables.getFirst(AdvancedSearchFilter.this.model.getControls(), null), AdvancedSearchFilter.this.onFilterChange);
                    }
                }
            });
            this.scroller.revalidate();
            this.scroller.repaint();
            this.optionPane.setVisible(true);
            int result = this.optionPane.getResult();
            this.optionPane.dispose();
            if (result != 1) {
                AdvancedSearchFilter.this.onFilterChange.run();
                return true;
            }
            return false;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void addNewFilter(Filter fromFilter) {
            if (this.panel.getComponent(this.panel.getComponentCount() - 1) == fromFilter) {
                Filter filter = new Filter();
                AdvancedSearchFilter.this.model.addFilterControl(filter);
                this.panel.add(filter);
                this.panel.revalidate();
                this.panel.repaint();
                this.scroller.scrollToBottom();
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void removeNextFilter(Filter fromFilter) {
            int index = ArrayUtils.indexOf(this.panel.getComponents(), fromFilter);
            if (index < this.panel.getComponentCount() - 1) {
                Filter nextFilter = (Filter)this.panel.getComponent(index + 1);
                AdvancedSearchFilter.this.model.removeFilterControl(nextFilter);
                this.panel.remove(nextFilter);
                this.panel.revalidate();
            }
        }

        private class Filter
        extends FSkin.SkinnedPanel
        implements AdvancedSearch.IFilterControl<T> {
            private final FLabel btnNotBeforeParen;
            private final FLabel btnOpenParen;
            private final FLabel btnNotAfterParen;
            private final FLabel btnFilter;
            private final FLabel btnCloseParen;
            private final FLabel btnAnd;
            private final FLabel btnOr;
            private AdvancedSearch.Filter<T> filter;

            private Filter() {
                super(null);
                this.setOpaque(false);
                this.btnNotBeforeParen = new FLabel.Builder().fontAlign(0).text("NOT").hoverable().selectable().build();
                this.btnOpenParen = new FLabel.Builder().fontAlign(0).text("(").hoverable().selectable().build();
                this.btnNotAfterParen = new FLabel.Builder().fontAlign(0).text("NOT").hoverable().selectable().build();
                this.btnFilter = new FLabel.ButtonBuilder().build();
                this.btnCloseParen = new FLabel.Builder().fontAlign(0).hoverable().selectable().text(")").build();
                this.btnAnd = new FLabel.Builder().fontAlign(0).text("AND").hoverable().selectable().cmdClick(new UiCommand(){

                    @Override
                    public void run() {
                        if (Filter.this.btnAnd.isSelected()) {
                            Filter.this.btnOr.setSelected(false);
                            EditDialog.this.addNewFilter(Filter.this);
                        } else {
                            EditDialog.this.removeNextFilter(Filter.this);
                        }
                    }
                }).build();
                this.btnOr = new FLabel.Builder().fontAlign(0).text("OR").hoverable().selectable().cmdClick(new UiCommand(){

                    @Override
                    public void run() {
                        if (Filter.this.btnOr.isSelected()) {
                            Filter.this.btnAnd.setSelected(false);
                            EditDialog.this.addNewFilter(Filter.this);
                        } else {
                            EditDialog.this.removeNextFilter(Filter.this);
                        }
                    }
                }).build();
                this.add(this.btnNotBeforeParen);
                this.add(this.btnOpenParen);
                this.add(this.btnNotAfterParen);
                this.add(this.btnFilter);
                this.add(this.btnCloseParen);
                this.add(this.btnAnd);
                this.add(this.btnOr);
            }

            @Override
            public void doLayout() {
                int padding = 5;
                int width = this.getWidth();
                int height = this.getHeight();
                int buttonWidth = (width - padding * 4) / 3;
                int buttonHeight = (height - padding * 3) / 3;
                int x = padding;
                int y = padding;
                int dx = buttonWidth + padding;
                int dy = buttonHeight + padding;
                this.btnNotBeforeParen.setBounds(x, y, buttonWidth, buttonHeight);
                this.btnOpenParen.setBounds(x += dx, y, buttonWidth, buttonHeight);
                this.btnNotAfterParen.setBounds(x += dx, y, buttonWidth, buttonHeight);
                x = padding;
                this.btnFilter.setBounds(x, y += dy, width - 2 * padding, buttonHeight);
                this.btnCloseParen.setBounds(x, y += dy, buttonWidth, buttonHeight);
                this.btnAnd.setBounds(x += dx, y, buttonWidth, buttonHeight);
                this.btnOr.setBounds(x += dx, y, buttonWidth, buttonHeight);
            }

            @Override
            public IButton getBtnNotBeforeParen() {
                return this.btnNotBeforeParen;
            }

            @Override
            public IButton getBtnOpenParen() {
                return this.btnOpenParen;
            }

            @Override
            public IButton getBtnNotAfterParen() {
                return this.btnNotAfterParen;
            }

            @Override
            public IButton getBtnFilter() {
                return this.btnFilter;
            }

            @Override
            public IButton getBtnCloseParen() {
                return this.btnCloseParen;
            }

            @Override
            public IButton getBtnAnd() {
                return this.btnAnd;
            }

            @Override
            public IButton getBtnOr() {
                return this.btnOr;
            }

            @Override
            public AdvancedSearch.Filter<T> getFilter() {
                return this.filter;
            }

            @Override
            public void setFilter(AdvancedSearch.Filter<T> filter0) {
                this.filter = filter0;
            }

            @Override
            public Class<? super T> getGenericType() {
                return AdvancedSearchFilter.this.itemManager.getGenericType();
            }
        }
    }
}

