/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.StaticData;
import forge.card.CardEdition;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.card.ColorSet;
import forge.deck.DeckProxy;
import forge.game.GameFormat;
import forge.gamemodes.quest.data.StarRating;
import forge.gui.interfaces.IButton;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.BooleanExpression;
import forge.itemmanager.SItemManagerUtil;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.BinaryUtil;
import forge.util.PredicateString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SFilterUtil {
    public static Predicate<PaperCard> buildTextFilter(String text, boolean invert, boolean inName, boolean inType, boolean inText, boolean inCost) {
        if ((text = text.trim()).isEmpty()) {
            return Predicates.alwaysTrue();
        }
        if (BooleanExpression.isExpression(text)) {
            BooleanExpression expression = new BooleanExpression(text, inName, inType, inText, inCost);
            try {
                Predicate<CardRules> filter = expression.evaluate();
                if (filter != null) {
                    return Predicates.compose(invert ? Predicates.not(filter) : filter, PaperCard::getRules);
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        List<String> splitText = SFilterUtil.getSplitText(text);
        ArrayList terms = new ArrayList();
        for (String s2 : splitText) {
            ArrayList<Predicate<CardRules>> subands = new ArrayList<Predicate<CardRules>>();
            if (inName) {
                subands.add(CardRulesPredicates.name(PredicateString.StringOp.CONTAINS_IC, s2));
            }
            if (inType) {
                subands.add(CardRulesPredicates.joinedType(PredicateString.StringOp.CONTAINS_IC, s2));
            }
            if (inText) {
                subands.add(CardRulesPredicates.rules(PredicateString.StringOp.CONTAINS_IC, s2));
            }
            if (inCost) {
                subands.add(CardRulesPredicates.cost(PredicateString.StringOp.CONTAINS_IC, s2));
            }
            terms.add(Predicates.or(subands));
        }
        Predicate textFilter = invert ? Predicates.not(Predicates.or(terms)) : Predicates.and(terms);
        return Predicates.compose(textFilter, PaperCard::getRules);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<String> getSplitText(String text) {
        boolean inQuotes = false;
        StringBuilder entry = new StringBuilder();
        ArrayList<String> splitText = new ArrayList<String>();
        block6: for (int i = 0; i < text.length(); ++i) {
            int ch = text.charAt(i);
            switch (ch) {
                case 32: {
                    if (inQuotes) break;
                    if (entry.length() <= 0) continue block6;
                    splitText.add(entry.toString());
                    entry = new StringBuilder();
                    continue block6;
                }
                case 34: {
                    inQuotes = !inQuotes;
                    continue block6;
                }
                case 92: {
                    if (i >= text.length() - 1 || text.charAt(i + 1) != '\"') break;
                    ch = 34;
                    ++i;
                    break;
                }
                case 44: {
                    if (!inQuotes) continue block6;
                }
            }
            entry.append((char)ch);
        }
        if (entry.length() > 0) {
            splitText.add(entry.toString());
        }
        return splitText;
    }

    public static <T extends InventoryItem> Predicate<T> buildItemTextFilter(String text) {
        if (text.trim().isEmpty()) {
            return Predicates.alwaysTrue();
        }
        return new ItemTextPredicate(text);
    }

    public static Predicate<PaperCard> buildStarRatingFilter(Map<SItemManagerUtil.StatTypes, ? extends IButton> buttonMap, HashSet<StarRating> QuestRatings) {
        Map<SItemManagerUtil.StatTypes, ? extends IButton> buttonMap2 = buttonMap;
        return card -> {
            StarRating r = new StarRating();
            r.Name = card.getName();
            r.Edition = card.getEdition();
            int j = 0;
            for (int i = 1; i < 6; ++i) {
                r.rating = i;
                if (!QuestRatings.contains(r)) continue;
                j = i;
            }
            boolean result = true;
            if (j == 0) {
                if (!((IButton)buttonMap2.get(SItemManagerUtil.StatTypes.RATE_NONE)).isSelected()) {
                    result = false;
                }
            } else if (j == 1) {
                if (!((IButton)buttonMap2.get(SItemManagerUtil.StatTypes.RATE_1)).isSelected()) {
                    result = false;
                }
            } else if (j == 2) {
                if (!((IButton)buttonMap2.get(SItemManagerUtil.StatTypes.RATE_2)).isSelected()) {
                    result = false;
                }
            } else if (j == 3) {
                if (!((IButton)buttonMap2.get(SItemManagerUtil.StatTypes.RATE_3)).isSelected()) {
                    result = false;
                }
            } else if (j == 4) {
                if (!((IButton)buttonMap2.get(SItemManagerUtil.StatTypes.RATE_4)).isSelected()) {
                    result = false;
                }
            } else if (j == 5 && !((IButton)buttonMap2.get(SItemManagerUtil.StatTypes.RATE_5)).isSelected()) {
                result = false;
            }
            return result;
        };
    }

    public static Predicate<PaperCard> buildFoilFilter(Map<SItemManagerUtil.StatTypes, ? extends IButton> buttonMap) {
        int Foil = (buttonMap.get(SItemManagerUtil.StatTypes.FOIL_OLD).isSelected() ? 1 : 0) + (buttonMap.get(SItemManagerUtil.StatTypes.FOIL_NEW).isSelected() ? 2 : 0) + (buttonMap.get(SItemManagerUtil.StatTypes.FOIL_NONE).isSelected() ? 4 : 0);
        return card -> {
            boolean result = false;
            CardEdition edition = StaticData.instance().getEditions().get(card.getEdition());
            if ((Foil & 1) == 1 && edition.getFoilType() == CardEdition.FoilType.OLD_STYLE) {
                boolean bl = result = result || card.isFoil();
            }
            if ((Foil & 2) == 2 && edition.getFoilType() == CardEdition.FoilType.MODERN) {
                boolean bl = result = result || card.isFoil();
            }
            if ((Foil & 4) == 4) {
                result = result || !card.isFoil();
            }
            return result;
        };
    }

    public static Predicate<PaperCard> buildColorFilter(Map<SItemManagerUtil.StatTypes, ? extends IButton> buttonMap) {
        byte colors0 = 0;
        if (buttonMap.get(SItemManagerUtil.StatTypes.WHITE).isSelected()) {
            colors0 = (byte)(colors0 | 1);
        }
        if (buttonMap.get(SItemManagerUtil.StatTypes.BLUE).isSelected()) {
            colors0 = (byte)(colors0 | 2);
        }
        if (buttonMap.get(SItemManagerUtil.StatTypes.BLACK).isSelected()) {
            colors0 = (byte)(colors0 | 4);
        }
        if (buttonMap.get(SItemManagerUtil.StatTypes.RED).isSelected()) {
            colors0 = (byte)(colors0 | 8);
        }
        if (buttonMap.get(SItemManagerUtil.StatTypes.GREEN).isSelected()) {
            colors0 = (byte)(colors0 | 0x10);
        }
        byte colors = colors0;
        boolean wantColorless = buttonMap.get(SItemManagerUtil.StatTypes.COLORLESS).isSelected();
        boolean wantMulticolor = buttonMap.get(SItemManagerUtil.StatTypes.MULTICOLOR).isSelected();
        return card -> {
            boolean useColorIdentity;
            CardRules rules = card.getRules();
            ColorSet color = rules.getColor();
            boolean allColorsFilteredOut = colors == 0;
            boolean bl = useColorIdentity = rules.getType().isLand() && !allColorsFilteredOut && FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_FILTER_LANDS_BY_COLOR_IDENTITY);
            if (useColorIdentity) {
                color = rules.getColorIdentity();
            }
            boolean result = true;
            if (wantMulticolor) {
                if (colors == 0) {
                    result = color.isMulticolor() || wantColorless && color.isColorless();
                } else if (colors != ColorSet.ALL_COLORS.getColor()) {
                    result = useColorIdentity && !allColorsFilteredOut ? color.hasAnyColor(colors) || wantColorless && color.isColorless() : wantColorless && color.isColorless() || rules.canCastWithAvailable(colors);
                }
            } else {
                boolean bl2 = result = !color.isMulticolor();
                if (colors != ColorSet.ALL_COLORS.getColor()) {
                    if (useColorIdentity && !allColorsFilteredOut) {
                        result = result && (color.hasAnyColor(colors) || wantColorless && color.isColorless());
                    } else {
                        boolean bl3 = result = result && (color.isColorless() || rules.canCastWithAvailable(colors));
                    }
                }
            }
            if (!wantColorless) {
                if (colors != 0 && colors != ColorSet.ALL_COLORS.getColor()) {
                    result = result && color.hasAnyColor(colors);
                }
                result = result && !color.isColorless();
            }
            return result;
        };
    }

    public static Predicate<DeckProxy> buildDeckColorFilter(Map<SItemManagerUtil.StatTypes, ? extends IButton> buttonMap) {
        return input -> {
            byte colorProfile = input.getColor().getColor();
            if (colorProfile == 0) {
                return ((IButton)buttonMap.get(SItemManagerUtil.StatTypes.DECK_COLORLESS)).isSelected();
            }
            boolean wantMulticolor = ((IButton)buttonMap.get(SItemManagerUtil.StatTypes.DECK_MULTICOLOR)).isSelected();
            if (!wantMulticolor && BinaryUtil.bitCount(colorProfile) > 1) {
                return false;
            }
            byte colors = 0;
            if (((IButton)buttonMap.get(SItemManagerUtil.StatTypes.DECK_WHITE)).isSelected()) {
                colors = (byte)(colors | 1);
            }
            if (((IButton)buttonMap.get(SItemManagerUtil.StatTypes.DECK_BLUE)).isSelected()) {
                colors = (byte)(colors | 2);
            }
            if (((IButton)buttonMap.get(SItemManagerUtil.StatTypes.DECK_BLACK)).isSelected()) {
                colors = (byte)(colors | 4);
            }
            if (((IButton)buttonMap.get(SItemManagerUtil.StatTypes.DECK_RED)).isSelected()) {
                colors = (byte)(colors | 8);
            }
            if (((IButton)buttonMap.get(SItemManagerUtil.StatTypes.DECK_GREEN)).isSelected()) {
                colors = (byte)(colors | 0x10);
            }
            return colors == 0 && wantMulticolor && BinaryUtil.bitCount(colorProfile) > 1 || (colorProfile & colors) == colorProfile;
        };
    }

    public static void showOnlyStat(SItemManagerUtil.StatTypes clickedStat, IButton clickedButton, Map<SItemManagerUtil.StatTypes, ? extends IButton> buttonMap) {
        boolean foundSelected = false;
        block6: for (Map.Entry<SItemManagerUtil.StatTypes, ? extends IButton> btn : buttonMap.entrySet()) {
            if (btn.getKey() == clickedStat) continue;
            if (btn.getKey() == SItemManagerUtil.StatTypes.MULTICOLOR) {
                switch (clickedStat) {
                    case WHITE: 
                    case BLUE: 
                    case BLACK: 
                    case RED: 
                    case GREEN: {
                        if (btn.getValue().isSelected()) continue block6;
                        btn.getValue().setSelected(true);
                        continue block6;
                    }
                }
            } else if (btn.getKey() == SItemManagerUtil.StatTypes.DECK_MULTICOLOR) {
                switch (clickedStat) {
                    case DECK_WHITE: 
                    case DECK_BLUE: 
                    case DECK_BLACK: 
                    case DECK_RED: 
                    case DECK_GREEN: {
                        if (btn.getValue().isSelected()) continue block6;
                        btn.getValue().setSelected(true);
                        continue block6;
                    }
                }
            }
            if (!btn.getValue().isSelected()) continue;
            foundSelected = true;
            btn.getValue().setSelected(false);
        }
        if (!clickedButton.isSelected()) {
            clickedButton.setSelected(true);
        } else if (!foundSelected) {
            for (Map.Entry<SItemManagerUtil.StatTypes, ? extends IButton> btn : buttonMap.entrySet()) {
                if (btn.getKey() == clickedStat || btn.getValue().isSelected()) continue;
                btn.getValue().setSelected(true);
            }
        }
    }

    public static Predicate<PaperCard> buildFormatFilter(Set<GameFormat> formats, boolean allowReprints) {
        ArrayList<Predicate<PaperCard>> predicates = new ArrayList<Predicate<PaperCard>>();
        for (GameFormat f : formats) {
            predicates.add(allowReprints ? f.getFilterRules() : f.getFilterPrinted());
        }
        return Predicates.or(predicates);
    }

    public static <T> Predicate<T> optimizedAnd(Predicate<T> p1, Predicate<T> p2) {
        return p1 == null ? p2 : (p2 == null ? p1 : Predicates.and(p1, p2));
    }

    private static class ItemTextPredicate<T extends InventoryItem>
    implements Predicate<T> {
        private final List<String> splitText;

        private ItemTextPredicate(String text) {
            this.splitText = SFilterUtil.getSplitText(text.toLowerCase());
        }

        @Override
        public boolean apply(T input) {
            String name = input.getName().toLowerCase();
            for (String s2 : this.splitText) {
                if (!name.contains(s2)) continue;
                return true;
            }
            return false;
        }
    }
}

