/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.gui.GuiUtils;
import forge.gui.UiCommand;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.IItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.ItemManagerModel;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.views.ImageView;
import forge.itemmanager.views.ItemListView;
import forge.itemmanager.views.ItemTableColumn;
import forge.itemmanager.views.ItemView;
import forge.localinstance.skin.FSkinProp;
import forge.screens.deckeditor.views.VCardCatalog;
import forge.screens.match.controllers.CDetailPicture;
import forge.toolbox.ContextMenuBuilder;
import forge.toolbox.FComboBox;
import forge.toolbox.FLabel;
import forge.toolbox.FSkin;
import forge.toolbox.LayoutHelper;
import forge.util.Aggregates;
import forge.util.ItemPool;
import forge.util.Localizer;
import forge.util.ReflectionUtil;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;

public abstract class ItemManager<T extends InventoryItem>
extends JPanel
implements IItemManager<T> {
    private ItemPool<T> pool;
    private final ItemManagerModel<T> model;
    private Predicate<? super T> filterPredicate = null;
    private final Map<Class<? extends ItemFilter<? extends T>>, List<ItemFilter<? extends T>>> filters = new HashMap<Class<? extends ItemFilter<? extends T>>, List<ItemFilter<? extends T>>>();
    private final List<ItemFilter<? extends T>> orderedFilters = new ArrayList<ItemFilter<? extends T>>();
    private boolean wantUnique = false;
    private boolean alwaysNonUnique = false;
    private boolean allowMultipleSelections = false;
    private boolean hideFilters = false;
    private boolean showRanking = false;
    private UiCommand itemActivateCommand;
    private ContextMenuBuilder contextMenuBuilder;
    private final Class<T> genericType;
    private final CDetailPicture cDetailPicture;
    private ItemManagerConfig config;
    private final List<ListSelectionListener> selectionListeners = new ArrayList<ListSelectionListener>();
    private final ItemFilter<? extends T> mainSearchFilter;
    private final FSkin.SkinnedPanel pnlButtons = new FSkin.SkinnedPanel(new MigLayout("insets 0, gap 0, ax center, hidemode 3"));
    private static final FSkin.SkinIcon SEARCH_ICON = FSkin.getIcon(FSkinProp.ICO_SEARCH).resize(20, 20);
    private final FLabel btnFilters = new FLabel.ButtonBuilder().icon(SEARCH_ICON).iconScaleAuto(false).tooltip(Localizer.getInstance().getMessage("lblClickToconfigureFilters", new Object[0])).reactOnMouseDown().build();
    private final FLabel lblCaption = new FLabel.Builder().fontAlign(2).fontSize(12).build();
    private final FLabel lblRatio = new FLabel.Builder().tooltip(Localizer.getInstance().getMessage("lblShownOfTotalCards", new Object[0])).fontAlign(2).fontSize(12).build();
    private final FLabel lblEmpty = new FLabel.Builder().text("").fontSize(12).build();
    private FComboBox cbxSection = new FComboBox();
    private static final FSkin.SkinIcon VIEW_OPTIONS_ICON = FSkin.getIcon(FSkinProp.ICO_SETTINGS).resize(20, 20);
    private final FLabel btnViewOptions = new FLabel.Builder().hoverable().selectable(true).icon(VIEW_OPTIONS_ICON).iconScaleAuto(false).tooltip(Localizer.getInstance().getMessage("lblToggleShowOrHideOptionsForCurrentView", new Object[0])).build();
    private final List<ItemView<T>> views = new ArrayList<ItemView<T>>();
    private final ItemListView<T> listView;
    private final ImageView<T> imageView;
    private ItemView<T> currentView;
    private boolean initialized;
    protected boolean lockFiltering;
    protected List<String> filteredSetCodesInCatalog = null;

    protected ItemManager(Class<T> genericType0, CDetailPicture cDetailPicture, boolean wantUnique0, boolean showRanking) {
        this.showRanking = showRanking;
        this.cDetailPicture = cDetailPicture;
        this.genericType = genericType0;
        this.wantUnique = wantUnique0;
        this.model = new ItemManagerModel<T>(genericType0);
        this.mainSearchFilter = this.createSearchFilter();
        this.mainSearchFilter.setAllowRemove(false);
        this.listView = new ItemListView<T>(this, this.model);
        this.imageView = this.createImageView(this.model);
        this.views.add(this.listView);
        this.views.add(this.imageView);
        this.currentView = this.listView;
    }

    protected ImageView<T> createImageView(ItemManagerModel<T> model0) {
        return new ImageView<T>(this, model0, this.showRanking);
    }

    public final CDetailPicture getCDetailPicture() {
        return this.cDetailPicture;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        for (int i = 0; i < this.views.size(); ++i) {
            this.views.get(i).initialize(i);
        }
        this.setOpaque(false);
        this.setLayout(null);
        this.mainSearchFilter.getPanel().setBorder(null);
        this.mainSearchFilter.getPanel().setVisible(!this.hideFilters);
        this.add(this.mainSearchFilter.getPanel());
        this.pnlButtons.setOpaque(false);
        this.pnlButtons.setBorder(new FSkin.MatteSkinBorder(1, 0, 1, 0, FSkin.getColor(FSkin.Colors.CLR_TEXT)));
        this.add(this.pnlButtons);
        this.add(this.btnFilters);
        this.add(this.lblCaption);
        this.add(this.lblRatio);
        this.add(this.lblEmpty);
        this.cbxSection.setVisible(false);
        this.add(this.cbxSection);
        for (ItemView<T> view : this.views) {
            this.add(view.getButton());
            view.getButton().setSelected(view == this.currentView);
        }
        this.add(this.btnViewOptions);
        this.btnViewOptions.setSelected(this.currentView.getPnlOptions().isVisible());
        this.add(this.currentView.getPnlOptions());
        this.add(this.currentView.getScroller());
        final Runnable cmdAddCurrentSearch = () -> {
            ItemFilter<? extends T> searchFilter = this.mainSearchFilter.createCopy();
            if (searchFilter != null) {
                this.lockFiltering = true;
                this.addFilter(searchFilter);
                this.mainSearchFilter.reset();
                this.lockFiltering = false;
            }
        };
        Runnable cmdResetFilters = () -> {
            this.resetFilters();
            SwingUtilities.invokeLater(this::focus);
        };
        Runnable cmdHideFilters = () -> {
            this.setHideFilters(!this.getHideFilters());
            SwingUtilities.invokeLater(this::focus);
        };
        this.mainSearchFilter.getMainComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && (e.isControlDown() || e.isMetaDown())) {
                    cmdAddCurrentSearch.run();
                }
            }
        });
        UiCommand cmdBuildFilterMenu = () -> {
            JPopupMenu menu = new JPopupMenu(Localizer.getInstance().getMessage("lblFilterMenu", new Object[0]));
            if (this.hideFilters) {
                GuiUtils.addMenuItem(menu, Localizer.getInstance().getMessage("lblShowFilters", new Object[0]), null, cmdHideFilters);
            } else {
                JMenu addMenu = GuiUtils.createMenu(Localizer.getInstance().getMessage("lblAddOrEditFilter", new Object[0]));
                GuiUtils.addMenuItem(addMenu, Localizer.getInstance().getMessage("lblCurrentTextSearch", new Object[0]), KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), cmdAddCurrentSearch, !this.mainSearchFilter.isEmpty());
                if (this.config != ItemManagerConfig.STRING_ONLY) {
                    this.buildAddFilterMenu(addMenu);
                }
                menu.add(addMenu);
                GuiUtils.addSeparator(menu);
                GuiUtils.addMenuItem(menu, Localizer.getInstance().getMessage("lblResetFilters", new Object[0]), null, cmdResetFilters);
                GuiUtils.addMenuItem(menu, Localizer.getInstance().getMessage("lblHideFilters", new Object[0]), null, cmdHideFilters);
            }
            menu.show(this.btnFilters, 0, this.btnFilters.getHeight());
        };
        this.btnFilters.setCommand(cmdBuildFilterMenu);
        this.btnFilters.setRightClickCommand(cmdBuildFilterMenu);
        this.btnViewOptions.setCommand(() -> {
            this.currentView.getPnlOptions().setVisible(!this.currentView.getPnlOptions().isVisible());
            this.revalidate();
        });
        this.addDefaultFilters();
        this.initialized = true;
        if (!this.applyFilters() && this.pool != null) {
            this.updateView(true, null);
        }
    }

    @Override
    public ItemManagerConfig getConfig() {
        return this.config;
    }

    @Override
    public void setup(ItemManagerConfig config0) {
        this.setup(config0, null);
    }

    public void setup(ItemManagerConfig config0, Map<ColumnDef, ItemTableColumn> colOverrides) {
        this.config = config0;
        this.setWantUnique(config0.getUniqueCardsOnly());
        for (ItemView<T> view : this.views) {
            view.setup(config0, colOverrides);
        }
        this.setViewIndex(config0.getViewIndex());
        this.setHideFilters(config0.getHideFilters());
    }

    public void setViewIndex(int viewIndex) {
        int backupIndexToSelect;
        if (viewIndex < 0 || viewIndex >= this.views.size()) {
            return;
        }
        ItemView<T> view = this.views.get(viewIndex);
        if (this.currentView == view) {
            return;
        }
        if (this.config != null) {
            this.config.setViewIndex(viewIndex);
        }
        Collection<Object> itemsToSelect = (backupIndexToSelect = this.currentView.getSelectedIndex()) > 0 || this.getSelectionCount() > 1 ? this.currentView.getSelectedItems() : null;
        this.currentView.getButton().setSelected(false);
        this.currentView.getPnlOptions().hideArrowButtons();
        this.remove(this.currentView.getPnlOptions());
        this.remove(this.currentView.getScroller());
        this.currentView = view;
        this.btnViewOptions.setSelected(view.getPnlOptions().isVisible());
        view.getButton().setSelected(true);
        view.refresh(itemsToSelect, backupIndexToSelect, 0);
        this.add(view.getPnlOptions());
        this.add(view.getScroller());
        this.revalidate();
        this.repaint();
        this.focus();
    }

    public void setHideViewOptions(int viewIndex, boolean hideViewOptions) {
        if (viewIndex < 0 || viewIndex >= this.views.size()) {
            return;
        }
        this.views.get(viewIndex).getPnlOptions().setVisible(!hideViewOptions);
    }

    @Override
    public void doLayout() {
        int buttonPanelHeight = 32;
        LayoutHelper helper = new LayoutHelper(this);
        boolean showButtonPanel = false;
        if (this.pnlButtons.isVisible()) {
            for (Component comp : this.pnlButtons.getComponents()) {
                if (!comp.isVisible()) continue;
                showButtonPanel = true;
                break;
            }
        }
        if (this.hideFilters) {
            if (showButtonPanel) {
                helper.offset(0, -4);
                helper.fillLine(this.pnlButtons, 32);
            } else {
                this.pnlButtons.setBounds(0, 0, 0, 0);
            }
        } else {
            for (ItemFilter itemFilter : this.orderedFilters) {
                helper.fillLine(itemFilter.getPanel(), 28);
            }
            helper.fillLine(this.mainSearchFilter.getPanel(), 28);
            helper.newLine(-3);
            helper.fillLine(this.pnlButtons, showButtonPanel ? 32 : 1);
        }
        int viewButtonWidth = 25;
        int n = this.lblRatio.getAutoSizeWidth();
        int captionWidth = this.lblCaption.getAutoSizeWidth();
        int cbxSectionWidth = this.cbxSection.isVisible() ? this.cbxSection.getAutoSizeWidth() : 0;
        int viewButtonCount = this.views.size() + 1;
        int widthViewButtons = viewButtonCount * 25 + helper.getGapX() * viewButtonCount;
        int availableCaptionWidth = helper.getParentWidth() - 25 - cbxSectionWidth - n - widthViewButtons;
        if (captionWidth > availableCaptionWidth) {
            this.lblCaption.setToolTipText(this.lblCaption.getText());
            captionWidth = availableCaptionWidth;
        } else {
            this.lblCaption.setToolTipText(null);
        }
        helper.newLine();
        helper.offset(1, 0);
        helper.include((JComponent)this.btnFilters, 25, 25);
        helper.include((JComponent)this.lblCaption, captionWidth, 25);
        helper.include((JComponent)this.cbxSection, cbxSectionWidth, 25);
        helper.offset(helper.getGapX(), 0);
        helper.include((JComponent)this.lblRatio, n, 25);
        helper.fillLine(this.lblEmpty, 25, widthViewButtons);
        for (ItemView<T> view : this.views) {
            helper.include((JComponent)view.getButton(), 25, 25);
            helper.offset(-1, 0);
        }
        helper.include((JComponent)this.btnViewOptions, 25, 25);
        helper.newLine(-1);
        if (this.currentView.getPnlOptions().isVisible()) {
            helper.fillLine(this.currentView.getPnlOptions(), 29);
        }
        helper.fill(this.currentView.getScroller());
    }

    @Override
    public Class<T> getGenericType() {
        return this.genericType;
    }

    @Override
    public String getCaption() {
        return this.lblCaption.getText();
    }

    @Override
    public void setCaption(String caption) {
        this.lblCaption.setText(caption);
        this.lblCaption.setLabelFor(this.listView.getTable());
    }

    @Override
    public ItemPool<T> getPool() {
        return this.pool;
    }

    @Override
    public void setPool(Iterable<T> items) {
        this.setPool(ItemPool.createFrom(items, this.genericType), false);
    }

    @Override
    public void setPool(ItemPool<T> poolView, boolean infinite) {
        this.setPoolImpl(ItemPool.createFrom(poolView, this.genericType), infinite);
    }

    @Override
    public void setPool(ItemPool<T> pool0) {
        this.setPoolImpl(pool0, false);
    }

    private void setPoolImpl(ItemPool<T> pool0, boolean infinite) {
        this.model.clear();
        this.pool = pool0;
        this.model.addItems(this.pool);
        this.model.setInfinite(infinite);
        this.updateView(true, null);
    }

    public ItemView<T> getCurrentView() {
        return this.currentView;
    }

    @Override
    public int getItemCount() {
        return this.currentView.getCount();
    }

    @Override
    public int getSelectionCount() {
        return this.currentView.getSelectionCount();
    }

    @Override
    public T getSelectedItem() {
        return this.currentView.getSelectedItem();
    }

    @Override
    public Collection<T> getSelectedItems() {
        return this.currentView.getSelectedItems();
    }

    @Override
    public ItemPool<T> getSelectedItemPool() {
        ItemPool<InventoryItem> selectedItemPool = new ItemPool<InventoryItem>(this.genericType);
        for (InventoryItem item : this.getSelectedItems()) {
            selectedItemPool.add(item, this.getItemCount(item));
        }
        return selectedItemPool;
    }

    @Override
    public boolean setSelectedItem(T item) {
        return this.currentView.setSelectedItem(item);
    }

    @Override
    public boolean setSelectedItems(Iterable<T> items) {
        return this.currentView.setSelectedItems(items);
    }

    @Override
    public T stringToItem(String str) {
        if (this.pool == null) {
            return null;
        }
        for (Map.Entry<T, Integer> itemEntry : this.pool) {
            if (!((InventoryItem)itemEntry.getKey()).toString().equals(str)) continue;
            return (T)((InventoryItem)itemEntry.getKey());
        }
        return null;
    }

    @Override
    public boolean setSelectedString(String str) {
        T item = this.stringToItem(str);
        if (item != null) {
            return this.setSelectedItem(item);
        }
        return false;
    }

    @Override
    public boolean setSelectedStrings(Iterable<String> strings) {
        ArrayList<T> items = new ArrayList<T>();
        for (String str : strings) {
            T item = this.stringToItem(str);
            if (item == null) continue;
            items.add(item);
        }
        return this.setSelectedItems(items);
    }

    @Override
    public boolean selectItemEntrys(Iterable<Map.Entry<T, Integer>> itemEntrys) {
        ArrayList<InventoryItem> items = new ArrayList<InventoryItem>();
        for (Map.Entry<T, Integer> itemEntry : itemEntrys) {
            items.add((InventoryItem)itemEntry.getKey());
        }
        return this.setSelectedItems(items);
    }

    @Override
    public void selectAll() {
        this.currentView.selectAll();
    }

    @Override
    public int getSelectedIndex() {
        return this.currentView.getSelectedIndex();
    }

    @Override
    public Iterable<Integer> getSelectedIndices() {
        return this.currentView.getSelectedIndices();
    }

    @Override
    public void setSelectedIndex(int index) {
        this.currentView.setSelectedIndex(index);
    }

    @Override
    public void setSelectedIndices(Integer[] indices) {
        this.currentView.setSelectedIndices(Arrays.asList(indices));
    }

    @Override
    public void setSelectedIndices(Iterable<Integer> indices) {
        this.currentView.setSelectedIndices(indices);
    }

    @Override
    public void addItem(T item, int qty) {
        if (this.isInfinite() && this.model.getOrderedList().contains(item)) {
            return;
        }
        this.pool.add(item, qty);
        if (this.isUnfiltered()) {
            this.model.addItem(item, qty);
        }
        ArrayList<T> items = new ArrayList<T>();
        items.add(item);
        this.updateView(false, items);
    }

    @Override
    public void addItems(Iterable<Map.Entry<T, Integer>> itemsToAdd) {
        if (this.isInfinite() && this.model.getOrderedList().containsAll(Lists.newArrayList(itemsToAdd))) {
            return;
        }
        this.pool.addAll(itemsToAdd);
        if (this.isUnfiltered()) {
            this.model.addItems(itemsToAdd);
        }
        ArrayList<InventoryItem> items = new ArrayList<InventoryItem>();
        for (Map.Entry<T, Integer> item : itemsToAdd) {
            items.add((InventoryItem)item.getKey());
        }
        this.updateView(false, items);
    }

    @Override
    public void removeItem(T item, int qty) {
        Collection<T> itemsToSelect = this.currentView == this.listView ? this.getSelectedItems() : null;
        this.pool.remove(item, qty);
        if (this.isUnfiltered()) {
            this.model.removeItem(item, qty);
        }
        this.updateView(false, itemsToSelect);
    }

    @Override
    public void removeItems(Iterable<Map.Entry<T, Integer>> itemsToRemove) {
        Collection<T> itemsToSelect = this.currentView == this.listView ? this.getSelectedItems() : null;
        for (Map.Entry<T, Integer> item : itemsToRemove) {
            this.pool.remove((InventoryItem)item.getKey(), item.getValue());
            if (!this.isUnfiltered()) continue;
            this.model.removeItem((InventoryItem)item.getKey(), item.getValue());
        }
        this.updateView(false, itemsToSelect);
    }

    @Override
    public void removeAllItems() {
        this.pool.clear();
        this.model.clear();
        this.updateView(false, null);
    }

    @Override
    public void scrollSelectionIntoView() {
        this.currentView.scrollSelectionIntoView();
    }

    @Override
    public int getItemCount(T item) {
        return this.model.isInfinite() ? Integer.MAX_VALUE : this.pool.count(item);
    }

    @Override
    public ItemPool<T> getFilteredItems() {
        return this.model.getItems();
    }

    protected abstract void addDefaultFilters();

    protected abstract ItemFilter<? extends T> createSearchFilter();

    protected abstract void buildAddFilterMenu(JMenu var1);

    protected <F extends ItemFilter<? extends T>> F getFilter(Class<F> filterClass) {
        List<ItemFilter<T>> filters = this.filters.get(filterClass);
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        return (F)((ItemFilter)ReflectionUtil.safeCast(filters.get(0), filterClass));
    }

    public void addFilter(ItemFilter<? extends T> filter) {
        ItemFilter existingFilter;
        Class<?> filterClass = filter.getClass();
        List classFilters = this.filters.computeIfAbsent(filterClass, k -> new ArrayList());
        if (classFilters.size() > 0 && (existingFilter = (ItemFilter)classFilters.get(0)).merge(filter)) {
            existingFilter.refreshWidget();
            this.applyNewOrModifiedFilter(existingFilter);
            return;
        }
        classFilters.add(filter);
        this.orderedFilters.add(filter);
        this.add(filter.getPanel());
        boolean visible = !this.hideFilters;
        filter.getPanel().setVisible(visible);
        if (visible && this.initialized) {
            this.revalidate();
            this.applyNewOrModifiedFilter(filter);
        }
    }

    public void applyNewOrModifiedFilter(ItemFilter<? extends T> filter) {
        if (this.lockFiltering) {
            filter.afterFiltersApplied();
            return;
        }
        if (!this.applyFilters()) {
            filter.afterFiltersApplied();
        }
        SwingUtilities.invokeLater(() -> filter.getMainComponent().requestFocusInWindow());
    }

    public void restoreDefaultFilters() {
        this.lockFiltering = true;
        for (ItemFilter<T> filter : this.orderedFilters) {
            this.remove(filter.getPanel());
        }
        this.filters.clear();
        this.orderedFilters.clear();
        this.addDefaultFilters();
        this.lockFiltering = false;
        this.revalidate();
        this.applyFilters();
    }

    public void removeFilter(ItemFilter<? extends T> filter) {
        Class<?> filterClass = filter.getClass();
        List<ItemFilter<T>> classFilters = this.filters.get(filterClass);
        if (classFilters != null && classFilters.remove(filter)) {
            if (classFilters.size() == 0) {
                this.filters.remove(filterClass);
            }
            this.orderedFilters.remove(filter);
            this.remove(filter.getPanel());
            this.revalidate();
            this.applyFilters();
        }
    }

    @Override
    public boolean applyFilters() {
        Predicate newFilterPredicate;
        if (this.lockFiltering || !this.initialized) {
            return false;
        }
        ArrayList<Predicate<T>> predicates = new ArrayList<Predicate<T>>();
        for (ItemFilter<T> filter : this.orderedFilters) {
            if (!filter.isEnabled() || filter.isEmpty()) continue;
            predicates.add(filter.buildPredicate(this.genericType));
        }
        if (this.mainSearchFilter.isEnabled() && !this.mainSearchFilter.isEmpty()) {
            predicates.add(this.mainSearchFilter.buildPredicate(this.genericType));
        }
        Predicate predicate = newFilterPredicate = predicates.size() == 0 ? null : Predicates.and(predicates);
        if (this.filterPredicate == newFilterPredicate) {
            return false;
        }
        this.filterPredicate = newFilterPredicate;
        if (this.pool != null) {
            this.updateView(true, this.getSelectedItems());
        }
        return true;
    }

    private boolean isUnfiltered() {
        return this.filterPredicate == null;
    }

    public boolean getHideFilters() {
        return this.hideFilters;
    }

    public void setHideFilters(boolean hideFilters0) {
        if (this.hideFilters == hideFilters0) {
            return;
        }
        this.hideFilters = hideFilters0;
        boolean visible = !hideFilters0;
        for (ItemFilter<T> filter : this.orderedFilters) {
            filter.getPanel().setVisible(visible);
        }
        this.mainSearchFilter.getPanel().setVisible(visible);
        if (this.initialized) {
            this.revalidate();
            if (hideFilters0) {
                this.resetFilters();
            } else {
                this.applyFilters();
            }
            if (this.config != null) {
                this.config.setHideFilters(hideFilters0);
            }
        }
    }

    public void resetFilters() {
        this.lockFiltering = true;
        for (ItemFilter<T> filter : this.orderedFilters) {
            filter.setEnabled(true);
            filter.reset();
        }
        this.mainSearchFilter.reset();
        this.lockFiltering = false;
        this.applyFilters();
    }

    public void refresh() {
        this.updateView(true, this.getSelectedItems());
    }

    protected Iterable<Map.Entry<T, Integer>> getUnique(Iterable<Map.Entry<T, Integer>> items) {
        return Aggregates.uniqueByLast(items, from -> ((InventoryItem)from.getKey()).getName());
    }

    public void updateView(boolean forceFilter, Iterable<T> itemsToSelect) {
        int total;
        boolean useFilter;
        boolean bl = useFilter = forceFilter && this.filterPredicate != null || !this.isUnfiltered();
        if (useFilter || this.wantUnique || forceFilter) {
            this.model.clear();
        }
        if (useFilter && this.wantUnique) {
            Predicate filterForPool = Predicates.compose(this.filterPredicate, Map.Entry::getKey);
            Iterable<Map.Entry<T, Integer>> iterable = this.getUnique(Iterables.filter(this.pool, filterForPool));
            this.model.addItems(iterable);
        } else if (useFilter) {
            Predicate pred = Predicates.compose(this.filterPredicate, Map.Entry::getKey);
            this.model.addItems(Iterables.filter(this.pool, pred));
        } else if (this.wantUnique) {
            Iterable<Map.Entry<T, Integer>> items2 = this.getUnique(this.pool);
            this.model.addItems(items2);
        } else if (!useFilter && forceFilter) {
            this.model.addItems(this.pool);
        }
        this.currentView.refresh(itemsToSelect, this.getSelectedIndex(), forceFilter ? 0 : this.currentView.getScrollValue());
        for (ItemFilter itemFilter : this.orderedFilters) {
            itemFilter.afterFiltersApplied();
        }
        if (!useFilter) {
            total = this.getFilteredItems().countAll();
        } else if (this.wantUnique) {
            total = 0;
            Iterable<T> iterable = Aggregates.uniqueByLast(this.pool, from -> ((InventoryItem)from.getKey()).getName());
            for (Map.Entry entry : iterable) {
                total += ((Integer)entry.getValue()).intValue();
            }
        } else {
            total = this.pool.countAll();
        }
        this.lblRatio.setText("(" + this.getFilteredItems().countAll() + " / " + total + ")");
    }

    public JPanel getPnlButtons() {
        return this.pnlButtons;
    }

    public FComboBox getCbxSection() {
        return this.cbxSection;
    }

    public boolean isIncrementalSearchActive() {
        return this.currentView.isIncrementalSearchActive();
    }

    public boolean getWantUnique() {
        return this.wantUnique && !this.alwaysNonUnique;
    }

    public void setWantUnique(boolean unique) {
        this.wantUnique = !this.alwaysNonUnique && unique;
    }

    public boolean getAlwaysNonUnique() {
        return this.alwaysNonUnique;
    }

    public void setAlwaysNonUnique(boolean nonUniqueOnly) {
        this.alwaysNonUnique = nonUniqueOnly;
    }

    public boolean getAllowMultipleSelections() {
        return this.allowMultipleSelections;
    }

    public void setAllowMultipleSelections(boolean allowMultipleSelections0) {
        if (this.allowMultipleSelections == allowMultipleSelections0) {
            return;
        }
        this.allowMultipleSelections = allowMultipleSelections0;
        for (ItemView<T> view : this.views) {
            view.setAllowMultipleSelections(allowMultipleSelections0);
        }
    }

    public boolean isInfinite() {
        return this.model.isInfinite();
    }

    public void focus() {
        this.currentView.focus();
    }

    public void focusSearch() {
        this.setHideFilters(false);
        this.mainSearchFilter.getMainComponent().requestFocusInWindow();
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.selectionListeners.remove(listener);
        this.selectionListeners.add(listener);
    }

    public Iterable<ListSelectionListener> getSelectionListeners() {
        return this.selectionListeners;
    }

    public void setItemActivateCommand(UiCommand itemActivateCommand0) {
        this.itemActivateCommand = itemActivateCommand0;
    }

    public void activateSelectedItems() {
        if (this.itemActivateCommand != null) {
            this.itemActivateCommand.run();
        }
    }

    public void setContextMenuBuilder(ContextMenuBuilder contextMenuBuilder0) {
        this.contextMenuBuilder = contextMenuBuilder0;
    }

    public void showContextMenu(MouseEvent e) {
        this.showContextMenu(e, null);
    }

    public void showContextMenu(MouseEvent e, final Runnable onClose) {
        this.focus();
        int index = this.currentView.getIndexAtPoint(e.getPoint());
        boolean needSelection = true;
        for (Integer selectedIndex : this.getSelectedIndices()) {
            if (selectedIndex != index) continue;
            needSelection = false;
            break;
        }
        if (needSelection) {
            this.setSelectedIndex(index);
        }
        if (this.contextMenuBuilder == null) {
            if (onClose != null) {
                onClose.run();
            }
            return;
        }
        JPopupMenu menu = new JPopupMenu("ItemManagerContextMenu");
        this.contextMenuBuilder.buildContextMenu(menu);
        if (onClose != null) {
            menu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent arg0) {
                    onClose.run();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
                    onClose.run();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                }
            });
        }
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected List<String> getFilteredSetCodesInCatalog() {
        if (this.filteredSetCodesInCatalog == null) {
            ItemManager<? extends InventoryItem> cardsManager = VCardCatalog.SINGLETON_INSTANCE.getItemManager();
            if (cardsManager == null) {
                return null;
            }
            try {
                ItemPool<? extends InventoryItem> cardsPool = cardsManager.getPool();
                HashSet<String> uniqueSetCodes = new HashSet<String>();
                for (Map.Entry<? extends InventoryItem, Integer> entry : cardsPool) {
                    uniqueSetCodes.add(((PaperCard)entry.getKey()).getEdition());
                }
                this.filteredSetCodesInCatalog = new ArrayList<String>(uniqueSetCodes);
            }
            catch (ClassCastException ex) {
                return null;
            }
        }
        return this.filteredSetCodesInCatalog;
    }
}

