/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import forge.Singletons;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.deck.io.DeckPreferences;
import forge.game.GameFormat;
import forge.game.GameType;
import forge.game.IHasGameType;
import forge.gamemodes.quest.QuestWorld;
import forge.gui.GuiUtils;
import forge.gui.UiCommand;
import forge.gui.framework.FScreen;
import forge.item.InventoryItem;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemColumn;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.filters.AdvancedSearchFilter;
import forge.itemmanager.filters.DeckBlockFilter;
import forge.itemmanager.filters.DeckColorFilter;
import forge.itemmanager.filters.DeckFolderFilter;
import forge.itemmanager.filters.DeckFormatFilter;
import forge.itemmanager.filters.DeckQuestWorldFilter;
import forge.itemmanager.filters.DeckSearchFilter;
import forge.itemmanager.filters.DeckSetFilter;
import forge.itemmanager.filters.FormatFilter;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.views.ItemCellRenderer;
import forge.itemmanager.views.ItemListView;
import forge.itemmanager.views.ItemTableColumn;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.SEditorIO;
import forge.screens.deckeditor.controllers.CDeckEditor;
import forge.screens.deckeditor.controllers.CEditorConstructed;
import forge.screens.deckeditor.controllers.CEditorLimited;
import forge.screens.deckeditor.controllers.CEditorQuest;
import forge.screens.home.quest.DialogChooseFormats;
import forge.screens.home.quest.DialogChooseSets;
import forge.screens.match.controllers.CDetailPicture;
import forge.toolbox.FOptionPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JTable;
import org.apache.commons.lang3.StringUtils;

public final class DeckManager
extends ItemManager<DeckProxy>
implements IHasGameType {
    private static final FSkin.SkinIcon icoDelete = FSkin.getIcon(FSkinProp.ICO_DELETE);
    private static final FSkin.SkinIcon icoEdit = FSkin.getIcon(FSkinProp.ICO_EDIT);
    private final GameType gameType;
    private UiCommand cmdDelete;
    private UiCommand cmdSelect;

    public DeckManager(GameType gt, CDetailPicture cDetailPicture) {
        super(DeckProxy.class, cDetailPicture, true, false);
        this.gameType = gt;
        this.addSelectionListener(e -> {
            if (this.cmdSelect != null) {
                this.cmdSelect.run();
            }
        });
        this.setItemActivateCommand(() -> this.editDeck((DeckProxy)this.getSelectedItem()));
    }

    @Override
    public GameType getGameType() {
        return this.gameType;
    }

    @Override
    public void setup(ItemManagerConfig config0) {
        boolean wasStringOnly = this.getConfig() == ItemManagerConfig.STRING_ONLY;
        boolean isStringOnly = config0 == ItemManagerConfig.STRING_ONLY;
        HashMap<ColumnDef, ItemTableColumn> colOverrides = null;
        if (config0.getCols().containsKey((Object)ColumnDef.DECK_ACTIONS)) {
            ItemTableColumn column = new ItemTableColumn(new ItemColumn(config0.getCols().get((Object)ColumnDef.DECK_ACTIONS)));
            column.setCellRenderer(new DeckActionsRenderer());
            colOverrides = new HashMap<ColumnDef, ItemTableColumn>();
            colOverrides.put(ColumnDef.DECK_ACTIONS, column);
        }
        super.setup(config0, colOverrides);
        if (isStringOnly != wasStringOnly) {
            this.restoreDefaultFilters();
        }
    }

    public void setDeleteCommand(UiCommand c0) {
        this.cmdDelete = c0;
    }

    public void setSelectCommand(UiCommand c0) {
        this.cmdSelect = c0;
    }

    public UiCommand getSelectCommand() {
        return this.cmdSelect;
    }

    @Override
    protected void addDefaultFilters() {
        if (this.getConfig() == ItemManagerConfig.STRING_ONLY) {
            return;
        }
        this.addFilter(new DeckColorFilter(this));
    }

    @Override
    protected ItemFilter<DeckProxy> createSearchFilter() {
        return new DeckSearchFilter(this);
    }

    private Map<String, HashMap> buildHierarchy(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        HashMap<String, HashMap> hierarchy = new HashMap<String, HashMap>();
        String[] components = path.split("/", 2);
        Map<Object, Object> value = new HashMap();
        if (components.length > 1) {
            value = this.buildHierarchy(components[1]);
        }
        hierarchy.put("/" + components[0], (HashMap)value);
        return hierarchy;
    }

    private void merge(Map<String, HashMap> mapLeft, Map<String, HashMap> mapRight) {
        for (String key : mapRight.keySet()) {
            if (mapLeft.containsKey(key)) {
                this.merge(mapLeft.get(key), mapRight.get(key));
                continue;
            }
            mapLeft.put(key, mapRight.get(key));
        }
    }

    private void buildNestedMenu(Map tree, JMenu menu, String parentPath) {
        if (tree.size() > 0) {
            for (Object key : tree.keySet()) {
                String fullPath = key.toString();
                if (parentPath != null) {
                    fullPath = parentPath + key.toString();
                }
                String finalFullPath = fullPath;
                GuiUtils.addMenuItem(menu, key.toString(), null, () -> this.addFilter(new DeckFolderFilter(this, finalFullPath)), true);
                Map value = (Map)tree.get(key);
                if (value.size() <= 0) continue;
                JMenu submenu = GuiUtils.createMenu(key.toString());
                this.buildNestedMenu(value, submenu, finalFullPath);
                menu.add(submenu);
            }
        }
    }

    @Override
    protected void buildAddFilterMenu(JMenu menu) {
        GuiUtils.addSeparator(menu);
        HashMap<String, HashMap> hierarchy = new HashMap<String, HashMap>();
        for (Map.Entry deckEntry : this.getPool()) {
            String path = ((DeckProxy)deckEntry.getKey()).getPath();
            if (!StringUtils.isNotEmpty(path)) continue;
            this.merge(hierarchy, this.buildHierarchy(path));
        }
        Localizer localizer = Localizer.getInstance();
        JMenu folder = GuiUtils.createMenu(localizer.getMessage("lblFolder", new Object[0]));
        if (hierarchy.size() > 0) {
            this.buildNestedMenu(hierarchy, folder, null);
        } else {
            folder.setEnabled(false);
        }
        menu.add(folder);
        JMenu fmt = GuiUtils.createMenu(localizer.getMessage("lblFormat", new Object[0]));
        for (GameFormat gameFormat : FModel.getFormats().getFilterList()) {
            GuiUtils.addMenuItem(fmt, gameFormat.getName(), null, () -> this.addFilter(new DeckFormatFilter(this, gameFormat)), FormatFilter.canAddFormat(gameFormat, this.getFilter(DeckFormatFilter.class)));
        }
        menu.add(fmt);
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblFormats", new Object[0]) + "...", null, () -> {
            DeckFormatFilter existingFilter = this.getFilter(DeckFormatFilter.class);
            if (existingFilter != null) {
                existingFilter.edit();
            } else {
                DialogChooseFormats dialog = new DialogChooseFormats();
                dialog.setOkCallback(() -> {
                    List<GameFormat> formats = dialog.getSelectedFormats();
                    if (!formats.isEmpty()) {
                        for (GameFormat format : formats) {
                            this.addFilter(new DeckFormatFilter(this, format));
                        }
                    }
                });
            }
        });
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblSets", new Object[0]) + "...", null, () -> {
            DeckSetFilter existingFilter = this.getFilter(DeckSetFilter.class);
            if (existingFilter != null) {
                existingFilter.edit();
            } else {
                List<String> limitedSets = this.getFilteredSetCodesInCatalog();
                DialogChooseSets dialog = new DialogChooseSets(null, null, limitedSets, true);
                dialog.setOkCallback(() -> {
                    List<String> sets = dialog.getSelectedSets();
                    if (!sets.isEmpty()) {
                        this.addFilter(new DeckSetFilter(this, sets, limitedSets, dialog.getWantReprints()));
                    }
                });
            }
        });
        JMenu world = GuiUtils.createMenu(localizer.getMessage("lblQuestWorld", new Object[0]));
        for (QuestWorld w : FModel.getWorlds()) {
            GuiUtils.addMenuItem(world, w.getName(), null, () -> this.addFilter(new DeckQuestWorldFilter((ItemManager<? super DeckProxy>)this, w)), DeckQuestWorldFilter.canAddQuestWorld(w, this.getFilter(DeckQuestWorldFilter.class)));
        }
        menu.add(world);
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.LOAD_ARCHIVED_FORMATS)) {
            JMenu jMenu = GuiUtils.createMenu(localizer.getMessage("lblBlock", new Object[0]));
            Iterable<GameFormat> blockFormats = FModel.getFormats().getBlockList();
            for (GameFormat f : blockFormats) {
                GuiUtils.addMenuItem(jMenu, f.getName(), null, () -> this.addFilter(new DeckBlockFilter(this, f)), DeckBlockFilter.canAddCardBlock(f, this.getFilter(DeckBlockFilter.class)));
            }
            menu.add(jMenu);
        }
        GuiUtils.addSeparator(menu);
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblColors", new Object[0]), null, () -> this.addFilter(new DeckColorFilter(this)), this.getFilter(DeckColorFilter.class) == null);
        GuiUtils.addSeparator(menu);
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblAdvanced", new Object[0]) + "...", null, () -> {
            AdvancedSearchFilter<DeckProxy> filter = this.getFilter(AdvancedSearchFilter.class);
            if (filter != null) {
                filter.edit();
            } else {
                filter = new AdvancedSearchFilter<DeckProxy>(this);
                this.lockFiltering = true;
                boolean result = filter.edit();
                this.lockFiltering = false;
                if (result) {
                    this.addFilter(filter);
                }
            }
        });
    }

    @Override
    protected List<String> getFilteredSetCodesInCatalog() {
        GameType gameType = this.getGameType();
        if (gameType == GameType.Brawl) {
            this.filteredSetCodesInCatalog = ((GameFormat)FModel.getFormats().get("Brawl")).getAllowedSetCodes();
            return this.filteredSetCodesInCatalog;
        }
        return super.getFilteredSetCodesInCatalog();
    }

    public void editDeck(DeckProxy deck) {
        CDeckEditor editorCtrl = null;
        FScreen screen = null;
        switch (this.gameType) {
            case Quest: {
                screen = FScreen.DECK_EDITOR_QUEST;
                editorCtrl = new CEditorQuest(FModel.getQuest(), this.getCDetailPicture());
                break;
            }
            case Constructed: {
                screen = FScreen.DECK_EDITOR_CONSTRUCTED;
                DeckPreferences.setCurrentDeck(deck != null ? deck.toString() : "");
                editorCtrl = new CEditorConstructed(this.getCDetailPicture(), this.gameType);
                break;
            }
            case Commander: {
                screen = FScreen.DECK_EDITOR_CONSTRUCTED;
                DeckPreferences.setCommanderDeck(deck != null ? deck.toString() : "");
                editorCtrl = new CEditorConstructed(this.getCDetailPicture(), this.gameType);
                break;
            }
            case Oathbreaker: {
                screen = FScreen.DECK_EDITOR_CONSTRUCTED;
                DeckPreferences.setCommanderDeck(deck != null ? deck.toString() : "");
                editorCtrl = new CEditorConstructed(this.getCDetailPicture(), this.gameType);
                break;
            }
            case Brawl: {
                screen = FScreen.DECK_EDITOR_CONSTRUCTED;
                DeckPreferences.setBrawlDeck(deck != null ? deck.toString() : "");
                editorCtrl = new CEditorConstructed(this.getCDetailPicture(), this.gameType);
                break;
            }
            case TinyLeaders: {
                screen = FScreen.DECK_EDITOR_CONSTRUCTED;
                DeckPreferences.setTinyLeadersDeck(deck != null ? deck.toString() : "");
                editorCtrl = new CEditorConstructed(this.getCDetailPicture(), this.gameType);
                break;
            }
            case Sealed: {
                screen = FScreen.DECK_EDITOR_SEALED;
                editorCtrl = new CEditorLimited(FModel.getDecks().getSealed(), screen, this.getCDetailPicture());
                break;
            }
            case Draft: {
                screen = FScreen.DECK_EDITOR_DRAFT;
                editorCtrl = new CEditorLimited(FModel.getDecks().getDraft(), screen, this.getCDetailPicture());
                break;
            }
            case Winston: {
                screen = FScreen.DECK_EDITOR_DRAFT;
                editorCtrl = new CEditorLimited(FModel.getDecks().getWinston(), screen, this.getCDetailPicture());
                break;
            }
            default: {
                return;
            }
        }
        if (!Singletons.getControl().ensureScreenActive(screen)) {
            return;
        }
        if (editorCtrl != null) {
            CDeckEditorUI.SINGLETON_INSTANCE.setEditorController(editorCtrl);
        }
        if (!SEditorIO.confirmSaveChanges(screen, true)) {
            return;
        }
        if (deck != null) {
            CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getDeckController().load(deck.getPath(), deck.getName());
        } else {
            CDeckEditorUI.SINGLETON_INSTANCE.getCurrentEditorController().getDeckController().loadDeck(new Deck());
        }
    }

    public boolean deleteDeck(DeckProxy deck) {
        if (deck == null) {
            return false;
        }
        if (!FOptionPane.showConfirmDialog(Localizer.getInstance().getMessage("lblConfirmDelete", new Object[0]) + "'" + deck.getName() + "'?", Localizer.getInstance().getMessage("lblDeleteDeck", new Object[0]), Localizer.getInstance().getMessage("lblDelete", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0]), false)) {
            return false;
        }
        switch (this.gameType) {
            case Constructed: 
            case Commander: 
            case Oathbreaker: 
            case Brawl: 
            case TinyLeaders: 
            case Sealed: 
            case Draft: {
                deck.deleteFromStorage();
                break;
            }
            case Quest: {
                deck.deleteFromStorage();
                FModel.getQuest().save();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Delete not implemented for game type = " + this.gameType.toString());
            }
        }
        this.removeItem(deck, 1);
        if (this.cmdDelete != null) {
            this.cmdDelete.run();
        }
        return true;
    }

    public class DeckActionsRenderer
    extends ItemCellRenderer {
        private static final int imgSize = 20;

        @Override
        public boolean alwaysShowTooltip() {
            return false;
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setToolTipText(null);
            return super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
        }

        @Override
        public <T extends InventoryItem> void processMouseEvent(MouseEvent e, ItemListView<T> listView, Object value, int row, int column) {
            Rectangle cellBounds = listView.getTable().getCellRect(row, column, false);
            int x = e.getX() - cellBounds.x;
            if (e.getID() == 501 && e.getButton() == 1) {
                DeckProxy deck = (DeckProxy)value;
                if (x >= 0 && x < 20) {
                    if (DeckManager.this.deleteDeck(deck)) {
                        e.consume();
                        return;
                    }
                } else if (x >= 20 && x < 40) {
                    DeckManager.this.editDeck(deck);
                }
                listView.getTable().setRowSelectionInterval(row, row);
                listView.getTable().repaint();
                e.consume();
            }
        }

        @Override
        public final void paint(Graphics g2) {
            super.paint(g2);
            FSkin.drawImage(g2, icoDelete, 0, 0, 20, 20);
            FSkin.drawImage(g2, icoEdit, 19, -1, 20, 20);
        }
    }
}

