/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import forge.StaticData;
import forge.card.CardEdition;
import forge.game.GameFormat;
import forge.gamemodes.quest.QuestWorld;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gui.GuiUtils;
import forge.item.PaperCard;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.AdvancedSearchFilter;
import forge.itemmanager.filters.CardBlockFilter;
import forge.itemmanager.filters.CardCMCFilter;
import forge.itemmanager.filters.CardCMCRangeFilter;
import forge.itemmanager.filters.CardColorFilter;
import forge.itemmanager.filters.CardFoilFilter;
import forge.itemmanager.filters.CardFormatFilter;
import forge.itemmanager.filters.CardPowerFilter;
import forge.itemmanager.filters.CardQuestWorldFilter;
import forge.itemmanager.filters.CardRatingFilter;
import forge.itemmanager.filters.CardSearchFilter;
import forge.itemmanager.filters.CardSetFilter;
import forge.itemmanager.filters.CardToughnessFilter;
import forge.itemmanager.filters.CardTypeFilter;
import forge.itemmanager.filters.FormatFilter;
import forge.itemmanager.filters.ItemFilter;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.home.quest.DialogChooseFormats;
import forge.screens.home.quest.DialogChooseSets;
import forge.screens.match.controllers.CDetailPicture;
import forge.util.CollectionSuppliers;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JMenu;

public class CardManager
extends ItemManager<PaperCard> {
    private boolean QuestMode;

    public CardManager(CDetailPicture cDetailPicture, boolean wantUnique0, boolean qm, boolean sr) {
        super(PaperCard.class, cDetailPicture, wantUnique0, sr);
        this.QuestMode = qm;
    }

    @Override
    protected void addDefaultFilters() {
        CardManager.addDefaultFilters(this);
    }

    @Override
    protected ItemFilter<PaperCard> createSearchFilter() {
        return CardManager.createSearchFilter(this);
    }

    @Override
    protected void buildAddFilterMenu(JMenu menu) {
        this.buildAddFilterMenu(menu, this);
    }

    @Override
    protected Iterable<Map.Entry<PaperCard, Integer>> getUnique(Iterable<Map.Entry<PaperCard, Integer>> items) {
        ListMultimap entriesByName = Multimaps.newListMultimap(new TreeMap(String.CASE_INSENSITIVE_ORDER), CollectionSuppliers.arrayLists());
        for (Map.Entry<PaperCard, Integer> item : items) {
            String cardName = item.getKey().getName();
            entriesByName.put(cardName, item);
        }
        HashMap<PaperCard, Integer> cardsMap = new HashMap<PaperCard, Integer>();
        for (String cardName : entriesByName.keySet()) {
            Map.Entry<PaperCard, Integer> cardEntry;
            Collection entries = entriesByName.get(cardName);
            ListMultimap<CardEdition, Map.Entry<PaperCard, Integer>> entriesByEdition = Multimaps.newListMultimap(new HashMap(), CollectionSuppliers.arrayLists());
            for (Map.Entry entry : entries) {
                CardEdition ed2 = StaticData.instance().getCardEdition(((PaperCard)entry.getKey()).getEdition());
                if (ed2 == null) continue;
                entriesByEdition.put(ed2, entry);
            }
            if (entriesByEdition.size() == 0) continue;
            ArrayList<CardEdition> acceptedEditions = Lists.newArrayList(Iterables.filter(entriesByEdition.keySet(), ed -> StaticData.instance().getCardArtPreference().accept((CardEdition)ed)));
            if (acceptedEditions.size() == 0) {
                acceptedEditions.addAll(entriesByEdition.keySet());
            }
            if ((cardEntry = this.getCardEntryToAdd(entriesByEdition, acceptedEditions)) == null) continue;
            cardsMap.put(cardEntry.getKey(), cardEntry.getValue());
        }
        return cardsMap.entrySet();
    }

    private Map.Entry<PaperCard, Integer> getCardEntryToAdd(ListMultimap<CardEdition, Map.Entry<PaperCard, Integer>> entriesByEdition, List<CardEdition> acceptedEditions) {
        Collections.sort(acceptedEditions);
        if (StaticData.instance().cardArtPreferenceIsLatest()) {
            Collections.reverse(acceptedEditions);
        }
        Iterator<CardEdition> editionIterator = acceptedEditions.iterator();
        Map.Entry candidateEntry = null;
        Map.Entry firstCandidateEntryFound = null;
        while (editionIterator.hasNext() && candidateEntry == null) {
            CardEdition cardEdition = editionIterator.next();
            Collection cardEntries = entriesByEdition.get((Object)cardEdition);
            Iterator entriesIterator = cardEntries.iterator();
            Map.Entry entry = candidateEntry = entriesIterator.hasNext() ? (Map.Entry)entriesIterator.next() : null;
            if (candidateEntry != null && firstCandidateEntryFound == null) {
                firstCandidateEntryFound = candidateEntry;
            }
            while ((candidateEntry == null || !((PaperCard)candidateEntry.getKey()).hasImage()) && entriesIterator.hasNext()) {
                candidateEntry = (Map.Entry)entriesIterator.next();
                if (firstCandidateEntryFound != null) continue;
                firstCandidateEntryFound = candidateEntry;
            }
            if (candidateEntry == null || ((PaperCard)candidateEntry.getKey()).hasImage()) continue;
            candidateEntry = null;
        }
        return candidateEntry != null ? candidateEntry : firstCandidateEntryFound;
    }

    public static void addDefaultFilters(ItemManager<? super PaperCard> itemManager) {
        itemManager.addFilter(new CardColorFilter(itemManager));
        itemManager.addFilter(new CardTypeFilter(itemManager));
        itemManager.addFilter(new CardCMCFilter(itemManager));
        if (FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.FOIL_FILTER_DEFAULT) == 1) {
            itemManager.addFilter(new CardFoilFilter(itemManager));
        }
        if (FModel.getQuestPreferences().getPrefInt(QuestPreferences.QPref.RATING_FILTER_DEFAULT) == 1) {
            itemManager.addFilter(new CardRatingFilter(itemManager));
        }
    }

    public static ItemFilter<PaperCard> createSearchFilter(ItemManager<? super PaperCard> itemManager) {
        return new CardSearchFilter(itemManager);
    }

    public void buildAddFilterMenu(JMenu menu, ItemManager<? super PaperCard> itemManager) {
        GuiUtils.addSeparator(menu);
        Localizer localizer = Localizer.getInstance();
        JMenu fmt = GuiUtils.createMenu(localizer.getMessage("lblFormat", new Object[0]));
        for (GameFormat gameFormat : FModel.getFormats().getFilterList()) {
            GuiUtils.addMenuItem(fmt, gameFormat.getName(), null, () -> itemManager.addFilter(new CardFormatFilter(itemManager, gameFormat)), FormatFilter.canAddFormat(gameFormat, itemManager.getFilter(CardFormatFilter.class)));
        }
        menu.add(fmt);
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblFormats", new Object[0]) + "...", null, () -> {
            CardFormatFilter existingFilter = itemManager.getFilter(CardFormatFilter.class);
            if (existingFilter != null) {
                existingFilter.edit(itemManager);
            } else {
                DialogChooseFormats dialog = new DialogChooseFormats();
                dialog.setWantReprintsCB(true);
                dialog.setOkCallback(() -> {
                    List<GameFormat> formats = dialog.getSelectedFormats();
                    if (!formats.isEmpty()) {
                        itemManager.addFilter(new CardFormatFilter(itemManager, formats, dialog.getWantReprints()));
                    }
                });
            }
        });
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblSets", new Object[0]) + "...", null, () -> {
            CardSetFilter existingFilter = itemManager.getFilter(CardSetFilter.class);
            if (existingFilter != null) {
                existingFilter.edit(itemManager);
            } else {
                List<String> limitedSets = this.getFilteredSetCodesInCatalog();
                DialogChooseSets dialog = new DialogChooseSets(null, null, limitedSets, true);
                dialog.setOkCallback(() -> {
                    List<String> sets = dialog.getSelectedSets();
                    if (!sets.isEmpty()) {
                        itemManager.addFilter(new CardSetFilter(itemManager, sets, limitedSets, dialog.getWantReprints()));
                    }
                });
            }
        });
        JMenu world = GuiUtils.createMenu(localizer.getMessage("lblQuestWorld", new Object[0]));
        for (QuestWorld w : FModel.getWorlds()) {
            GuiUtils.addMenuItem(world, w.getName(), null, () -> itemManager.addFilter(new CardQuestWorldFilter(itemManager, w)), CardQuestWorldFilter.canAddQuestWorld(w, itemManager.getFilter(CardQuestWorldFilter.class)));
        }
        menu.add(world);
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.LOAD_ARCHIVED_FORMATS)) {
            JMenu jMenu = GuiUtils.createMenu(localizer.getMessage("lblBlock", new Object[0]));
            Iterable<GameFormat> blockFormats = FModel.getFormats().getBlockList();
            for (GameFormat f : blockFormats) {
                GuiUtils.addMenuItem(jMenu, f.getName(), null, () -> itemManager.addFilter(new CardBlockFilter(itemManager, f)), CardBlockFilter.canAddCardBlockWorld(f, itemManager.getFilter(CardBlockFilter.class)));
            }
            menu.add(jMenu);
        }
        GuiUtils.addSeparator(menu);
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblColors", new Object[0]), null, () -> itemManager.addFilter(new CardColorFilter(itemManager)), itemManager.getFilter(CardColorFilter.class) == null);
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblTypes", new Object[0]), null, () -> itemManager.addFilter(new CardTypeFilter(itemManager)), itemManager.getFilter(CardTypeFilter.class) == null);
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblConvertedManaCosts", new Object[0]), null, () -> itemManager.addFilter(new CardCMCFilter(itemManager)), itemManager.getFilter(CardCMCFilter.class) == null);
        GuiUtils.addSeparator(menu);
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblCMCRange", new Object[0]), null, () -> itemManager.addFilter(new CardCMCRangeFilter(itemManager)), itemManager.getFilter(CardCMCRangeFilter.class) == null);
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblPowerRange", new Object[0]), null, () -> itemManager.addFilter(new CardPowerFilter(itemManager)), itemManager.getFilter(CardPowerFilter.class) == null);
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblToughnessRange", new Object[0]), null, () -> itemManager.addFilter(new CardToughnessFilter(itemManager)), itemManager.getFilter(CardToughnessFilter.class) == null);
        GuiUtils.addSeparator(menu);
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblFoil", new Object[0]), null, () -> itemManager.addFilter(new CardFoilFilter(itemManager)), itemManager.getFilter(CardFoilFilter.class) == null);
        if (this.QuestMode) {
            GuiUtils.addMenuItem(menu, localizer.getMessage("lblPersonalRating", new Object[0]), null, () -> itemManager.addFilter(new CardRatingFilter(itemManager)), itemManager.getFilter(CardRatingFilter.class) == null);
        }
        GuiUtils.addSeparator(menu);
        GuiUtils.addMenuItem(menu, localizer.getMessage("lblAdvanced", new Object[0]) + "...", null, () -> {
            AdvancedSearchFilter filter = itemManager.getFilter(AdvancedSearchFilter.class);
            if (filter != null) {
                filter.edit();
            } else {
                filter = new AdvancedSearchFilter(itemManager);
                itemManager.lockFiltering = true;
                boolean result = filter.edit();
                itemManager.lockFiltering = false;
                if (result) {
                    itemManager.addFilter(filter);
                }
            }
        });
    }
}

