/*
 * Decompiled with CFR 0.152.
 */
package forge.item.generation;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import forge.StaticData;
import forge.card.PrintSheet;
import forge.item.PaperCard;
import forge.item.SealedTemplate;
import forge.item.generation.BoosterGenerator;
import forge.item.generation.IUnOpenedProduct;
import forge.util.ItemPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.Pair;

public class UnOpenedProduct
implements IUnOpenedProduct {
    private final SealedTemplate tpl;
    private final Map<String, PrintSheet> sheets;
    private boolean poolLimited = false;

    public final boolean isPoolLimited() {
        return this.poolLimited;
    }

    public final void setLimitedPool(boolean considerNumbersInPool) {
        this.poolLimited = considerNumbersInPool;
    }

    public UnOpenedProduct(SealedTemplate template) {
        this.tpl = template;
        this.sheets = null;
    }

    public UnOpenedProduct(SealedTemplate template, ItemPool<PaperCard> pool) {
        this(template, pool.toFlatList());
    }

    public UnOpenedProduct(SealedTemplate template, Iterable<PaperCard> cards) {
        this.tpl = template;
        this.sheets = new TreeMap<String, PrintSheet>();
        this.prebuildSheets(cards);
    }

    public UnOpenedProduct(SealedTemplate sealedProductTemplate, Predicate<PaperCard> filterPrinted) {
        this(sealedProductTemplate, Iterables.filter(StaticData.instance().getCommonCards().getAllCards(), filterPrinted));
    }

    private void prebuildSheets(Iterable<PaperCard> sourceList) {
        for (Pair<String, Integer> cc : this.tpl.getSlots()) {
            this.sheets.put(cc.getKey(), BoosterGenerator.makeSheet(cc.getKey(), sourceList));
        }
    }

    @Override
    public List<PaperCard> get() {
        if (this.sheets != null) {
            return this.getBoosterPack();
        }
        return BoosterGenerator.getBoosterPack(this.tpl);
    }

    private List<PaperCard> getBoosterPack() {
        ArrayList<PaperCard> result = new ArrayList<PaperCard>();
        for (Pair<String, Integer> slot : this.tpl.getSlots()) {
            PrintSheet ps = this.sheets.get(slot.getLeft());
            if (ps.isEmpty() && this.poolLimited) {
                throw new IllegalStateException("The cardpool has been depleted and has no more cards for slot " + slot.getKey());
            }
            List<PaperCard> foundCards = ps.random(slot.getRight(), true);
            if (this.poolLimited) {
                ps.removeAll(foundCards);
            }
            result.addAll(foundCards);
        }
        return result;
    }
}

