/*
 * Decompiled with CFR 0.152.
 */
package forge.item.generation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forge.StaticData;
import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.card.CardRulesPredicates;
import forge.card.CardSplitType;
import forge.card.PrintSheet;
import forge.item.BoosterSlot;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.item.SealedTemplate;
import forge.item.SealedTemplateWithSlots;
import forge.util.Aggregates;
import forge.util.MyRandom;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BoosterGenerator {
    private static final Map<String, PrintSheet> cachedSheets = new TreeMap<String, PrintSheet>(String.CASE_INSENSITIVE_ORDER);

    private static synchronized PrintSheet getPrintSheet(String key) {
        if (!cachedSheets.containsKey(key)) {
            cachedSheets.put(key, BoosterGenerator.makeSheet(key, StaticData.instance().getCommonCards().getAllCards()));
        }
        return cachedSheets.get(key);
    }

    private static PaperCard generateFoilCard(PrintSheet sheet) {
        PaperCard randomCard = sheet.random(1, true).get(0);
        return randomCard.getFoiled();
    }

    private static PaperCard generateFoilCard(List<PaperCard> cardList) {
        Collections.shuffle(cardList, MyRandom.getRandom());
        PaperCard randomCard = cardList.get(0);
        return randomCard.getFoiled();
    }

    public static List<PaperCard> getBoosterPack(SealedTemplate template) {
        if (template instanceof SealedTemplateWithSlots) {
            return BoosterGenerator.getBoosterPack((SealedTemplateWithSlots)template);
        }
        ArrayList<PaperCard> result = new ArrayList<PaperCard>();
        ArrayList<PrintSheet> sheetsUsed = new ArrayList<PrintSheet>();
        CardEdition edition = StaticData.instance().getEditions().get(template.getEdition());
        boolean hasFoil = edition != null && !template.getSlots().isEmpty() && MyRandom.getRandom().nextDouble() < edition.getFoilChanceInBooster() && edition.getFoilType() != CardEdition.FoilType.NOT_SUPPORTED;
        boolean foilAtEndOfPack = hasFoil && edition.getFoilAlwaysInCommonSlot();
        CardRarity foilCard = CardRarity.Unknown;
        block15: while (foilCard == CardRarity.Unknown) {
            int randomNum = MyRandom.getRandom().nextInt(10) + 1;
            switch (randomNum) {
                case 1: {
                    foilCard = CardRarity.Rare;
                    continue block15;
                }
                case 2: 
                case 3: {
                    foilCard = CardRarity.Uncommon;
                    continue block15;
                }
                case 4: 
                case 5: 
                case 6: {
                    foilCard = CardRarity.Common;
                    continue block15;
                }
                case 7: {
                    if (edition == null || !edition.getName().equals("Time Spiral")) continue block15;
                    foilCard = CardRarity.Special;
                    continue block15;
                }
                case 8: {
                    if (edition == null || !edition.getName().equals("Vintage Masters") || MyRandom.getRandom().nextInt(53) > 7) continue block15;
                    foilCard = CardRarity.Special;
                    continue block15;
                }
                case 9: {
                    if (edition == null || !template.hasSlot("dfc")) continue block15;
                    foilCard = CardRarity.Special;
                    continue block15;
                }
                case 10: {
                    if (edition == null || !edition.getName().equals("Planeshift") || MyRandom.getRandom().nextInt(53) > 3) continue block15;
                    foilCard = CardRarity.Special;
                    continue block15;
                }
            }
            foilCard = CardRarity.Common;
        }
        String extraFoilSheetKey = edition != null ? edition.getAdditionalSheetForFoils() : "";
        boolean replaceCommon = edition != null && !template.getSlots().isEmpty() && MyRandom.getRandom().nextDouble() < edition.getChanceReplaceCommonWith();
        String foilSlot = "";
        if (hasFoil) {
            foilSlot = Aggregates.random(template.getSlots()).getLeft().split("[ :!]")[0];
            switch (foilCard) {
                case Rare: {
                    if (template.hasSlot("RareMythic")) {
                        foilSlot = "RareMythic";
                        break;
                    }
                    if (template.hasSlot("Rare")) {
                        foilSlot = "Rare";
                        break;
                    }
                    if (!template.hasSlot("UncommonRare")) break;
                    foilSlot = "UncommonRare";
                    break;
                }
                case Uncommon: {
                    if (template.hasSlot("Uncommon")) {
                        foilSlot = "Uncommon";
                        break;
                    }
                    if (!template.hasSlot("UncommonRare")) break;
                    foilSlot = "UncommonRare";
                    break;
                }
                case Common: {
                    foilSlot = "Common";
                    if (!template.hasSlot("BasicLand") || MyRandom.getRandom().nextInt(130) > 20) break;
                    foilSlot = "BasicLand";
                    break;
                }
                case Special: {
                    if (template.hasSlot("TimeShifted")) {
                        foilSlot = "TimeShifted";
                        break;
                    }
                    if (template.hasSlot("dfc")) {
                        foilSlot = "dfc";
                        break;
                    }
                    if (!template.hasSlot("Special")) break;
                    foilSlot = "Special";
                    break;
                }
            }
        }
        ArrayList<PaperCard> foilCardGeneratedAndHeld = new ArrayList<PaperCard>();
        for (Pair<String, Integer> slot : template.getSlots()) {
            ArrayList<PaperCard> foilCards;
            List<Object> paperCards;
            boolean foilInThisSlot;
            String sheetKey;
            String[] sType;
            String slotType = slot.getLeft();
            int numCards = slot.getRight();
            boolean convertCardFoil = slotType.endsWith("+");
            if (convertCardFoil) {
                slotType = slotType.substring(0, slotType.length() - 1);
            }
            String setCode = (sType = TextUtil.splitWithParenthesis(slotType, ' ')).length == 1 && template.getEdition() != null ? template.getEdition() : null;
            String string = sheetKey = StaticData.instance().getEditions().contains(setCode) ? slotType.trim() + " " + (String)setCode : slotType.trim();
            if (sheetKey.startsWith("wholeSheet")) {
                PrintSheet ps = BoosterGenerator.getPrintSheet(sheetKey);
                result.addAll(ps.all());
                sheetsUsed.add(ps);
                continue;
            }
            slotType = slotType.split("[ :!]")[0];
            boolean bl = foilInThisSlot = hasFoil && slotType.equals(foilSlot);
            if (!foilAtEndOfPack && foilInThisSlot || foilAtEndOfPack && hasFoil && slotType.startsWith("Common")) {
                --numCards;
            }
            if (edition != null && edition.getName().equals("Planeshift") && slotType.startsWith("Rare") && foilSlot.startsWith("Special")) {
                --numCards;
            }
            if (replaceCommon && slotType.startsWith("Common")) {
                --numCards;
                String replaceKey = StaticData.instance().getEditions().contains(setCode) ? edition.getSlotReplaceCommonWith().trim() + " " + (String)setCode : edition.getSlotReplaceCommonWith().trim();
                PrintSheet replaceSheet = BoosterGenerator.getPrintSheet(replaceKey);
                result.addAll(replaceSheet.random(1, true));
                sheetsUsed.add(replaceSheet);
                System.out.println("Common was replaced with something from the replace sheet...");
                replaceCommon = false;
            }
            PrintSheet ps = BoosterGenerator.getPrintSheet(sheetKey);
            if (convertCardFoil) {
                paperCards = Lists.newArrayList();
                for (PaperCard pc : ps.random(numCards, true)) {
                    paperCards.add(pc.getFoiled());
                }
            } else {
                paperCards = ps.random(numCards, true);
            }
            result.addAll(paperCards);
            sheetsUsed.add(ps);
            if (!foilInThisSlot) continue;
            if (!foilAtEndOfPack) {
                hasFoil = false;
                if (!extraFoilSheetKey.isEmpty()) {
                    foilCards = new ArrayList();
                    for (PaperCard card : ps.toFlatList()) {
                        if (foilCards.contains(card)) continue;
                        foilCards.add(card);
                    }
                    BoosterGenerator.addCardsFromExtraSheet(foilCards, extraFoilSheetKey);
                    result.add(BoosterGenerator.generateFoilCard(foilCards));
                    continue;
                }
                result.add(BoosterGenerator.generateFoilCard(ps));
                continue;
            }
            if (!extraFoilSheetKey.isEmpty()) {
                foilCards = new ArrayList<PaperCard>();
                for (PaperCard card : ps.toFlatList()) {
                    if (foilCards.contains(card)) continue;
                    foilCards.add(card);
                }
                BoosterGenerator.addCardsFromExtraSheet(foilCards, extraFoilSheetKey);
                foilCardGeneratedAndHeld.add(BoosterGenerator.generateFoilCard(foilCards));
                continue;
            }
            if (edition == null) continue;
            if (edition.getName().equals("Vintage Masters")) {
                if (MyRandom.getRandom().nextInt(30) == 1 || !foilSlot.equals("Special")) {
                    foilCardGeneratedAndHeld.add(BoosterGenerator.generateFoilCard(ps));
                    continue;
                }
                result.addAll(ps.random(1, true));
                continue;
            }
            foilCardGeneratedAndHeld.add(BoosterGenerator.generateFoilCard(ps));
        }
        if (hasFoil && foilAtEndOfPack) {
            result.addAll(foilCardGeneratedAndHeld);
        }
        if (edition != null) {
            String sheetReplaceCardFromSheet2;
            String sheetReplaceCardFromSheet;
            String boosterReplaceSlotFromPrintSheet;
            String boosterMustContain = edition.getBoosterMustContain();
            if (!boosterMustContain.isEmpty()) {
                BoosterGenerator.ensureGuaranteedCardInBooster(result, template, boosterMustContain);
            }
            if (!(boosterReplaceSlotFromPrintSheet = edition.getBoosterReplaceSlotFromPrintSheet()).isEmpty()) {
                BoosterGenerator.replaceCardFromExtraSheet(result, boosterReplaceSlotFromPrintSheet);
            }
            if (!(sheetReplaceCardFromSheet = edition.getSheetReplaceCardFromSheet()).isEmpty()) {
                String[] split = sheetReplaceCardFromSheet.split("_");
                PrintSheet replaceThis = StaticData.instance().getPrintSheets().get(split[0]);
                ArrayList<PaperCard> candidates = Lists.newArrayList();
                for (PaperCard p : result) {
                    if (!replaceThis.all().contains(p)) continue;
                    candidates.add(candidates.size(), p);
                }
                result.removeAll(candidates);
                BoosterGenerator.replaceCardFromExtraSheet(candidates, split[1]);
                result.addAll(candidates);
            }
            if (!(sheetReplaceCardFromSheet2 = edition.getSheetReplaceCardFromSheet2()).isEmpty()) {
                String[] split = sheetReplaceCardFromSheet2.split("_");
                PrintSheet replaceThis = StaticData.instance().getPrintSheets().get(split[0]);
                ArrayList<PaperCard> candidates = Lists.newArrayList();
                for (PaperCard p : result) {
                    if (!replaceThis.all().contains(p)) continue;
                    candidates.add(candidates.size(), p);
                }
                result.removeAll(candidates);
                BoosterGenerator.replaceCardFromExtraSheet(candidates, split[1]);
                result.addAll(candidates);
            }
        }
        return result;
    }

    public static List<PaperCard> getBoosterPack(SealedTemplateWithSlots template) {
        CardEdition edition = StaticData.instance().getEditions().get(template.getEdition());
        ArrayList<PaperCard> result = new ArrayList<PaperCard>();
        Map<String, BoosterSlot> boosterSlots = template.getNamedSlots();
        for (Pair<String, Integer> slot : template.getSlots()) {
            List<Object> paperCards;
            PrintSheet ps;
            BoosterSlot boosterSlot;
            String determineSheet;
            String slotType = slot.getLeft().trim();
            int numCards = slot.getRight();
            System.out.println(numCards + " of type " + slotType);
            boolean convertCardFoil = slotType.endsWith("+");
            if (convertCardFoil) {
                slotType = slotType.substring(0, slotType.length() - 1);
            }
            if ((determineSheet = (boosterSlot = boosterSlots.get(slotType)).replaceSlot()).endsWith("+")) {
                determineSheet = determineSheet.substring(0, determineSheet.length() - 1);
                convertCardFoil = true;
            }
            String setCode = template.getEdition();
            try {
                ps = BoosterGenerator.getPrintSheet(determineSheet + " " + setCode);
            }
            catch (Exception e) {
                ps = BoosterGenerator.getPrintSheet(determineSheet);
            }
            if (convertCardFoil) {
                paperCards = Lists.newArrayList();
                for (PaperCard pc : ps.random(numCards, true)) {
                    paperCards.add(pc.getFoiled());
                }
            } else {
                paperCards = ps.random(numCards, true);
            }
            result.addAll(paperCards);
        }
        return result;
    }

    private static void ensureGuaranteedCardInBooster(List<PaperCard> result, SealedTemplate template, String boosterMustContain) {
        String[] types = TextUtil.split(boosterMustContain, ' ');
        boolean alreadyHaveCard = false;
        for (PaperCard paperCard : result) {
            boolean bl = true;
            for (String type : types) {
                if (paperCard.getRules().getType().hasStringType(type)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            alreadyHaveCard = true;
            break;
        }
        if (!alreadyHaveCard) {
            ArrayList<PaperCard> possibleCards = Lists.newArrayList();
            for (Pair<String, Integer> pair : template.getSlots()) {
                String slotType = pair.getLeft();
                String setCode = template.getEdition();
                String sheetKey = StaticData.instance().getEditions().contains(setCode) ? slotType.trim() + " " + setCode : slotType.trim();
                PrintSheet ps = BoosterGenerator.getPrintSheet(sheetKey);
                ArrayList<PaperCard> cardsInSlot = Lists.newArrayList(ps.toFlatList());
                for (PaperCard pc : cardsInSlot) {
                    boolean cardHasAllTypes = true;
                    for (String type : types) {
                        if (pc.getRules().getType().hasStringType(type)) continue;
                        cardHasAllTypes = false;
                        break;
                    }
                    if (!cardHasAllTypes || possibleCards.contains(pc)) continue;
                    possibleCards.add(pc);
                }
            }
            if (!possibleCards.isEmpty()) {
                PaperCard paperCard = (PaperCard)Aggregates.random(possibleCards);
                BoosterGenerator.replaceCard(result, paperCard);
            }
        }
    }

    public static void replaceCardFromExtraSheet(List<PaperCard> booster, String printSheetKey) {
        PrintSheet replacementSheet = StaticData.instance().getPrintSheets().get(printSheetKey);
        PaperCard toAdd = replacementSheet.random(1, false).get(0);
        BoosterGenerator.replaceCard(booster, toAdd);
    }

    public static void replaceCard(List<PaperCard> booster, PaperCard toAdd) {
        Predicate<PaperCard> rarityPredicate = null;
        switch (toAdd.getRarity()) {
            case BasicLand: {
                rarityPredicate = IPaperCard.Predicates.Presets.IS_BASIC_LAND;
                break;
            }
            case Common: {
                rarityPredicate = IPaperCard.Predicates.Presets.IS_COMMON;
                break;
            }
            case Uncommon: {
                rarityPredicate = IPaperCard.Predicates.Presets.IS_UNCOMMON;
                break;
            }
            case Rare: 
            case MythicRare: {
                rarityPredicate = IPaperCard.Predicates.Presets.IS_RARE_OR_MYTHIC;
                break;
            }
            default: {
                rarityPredicate = IPaperCard.Predicates.Presets.IS_SPECIAL;
            }
        }
        PaperCard toReplace = null;
        for (PaperCard card : booster) {
            if (!rarityPredicate.apply(card)) continue;
            toReplace = card;
            break;
        }
        if (toReplace != null) {
            if (toReplace.isFoil()) {
                toAdd = toAdd.getFoiled();
            }
            booster.remove(toReplace);
            booster.add(toAdd);
        }
    }

    public static void addCardsFromExtraSheet(List<PaperCard> dest, String printSheetKey) {
        PrintSheet extraSheet = BoosterGenerator.getPrintSheet(printSheetKey);
        HashSet<CardRarity> allowedRarity = Sets.newHashSet();
        if (!dest.isEmpty()) {
            for (PaperCard inDest : dest) {
                allowedRarity.add(inDest.getRarity());
            }
        }
        for (PaperCard card : extraSheet.toFlatList()) {
            if (dest.contains(card) || !allowedRarity.contains((Object)card.getRarity())) continue;
            dest.add(card);
        }
    }

    public static PrintSheet makeSheet(String sheetKey, Iterable<PaperCard> src) {
        Predicate predicateRare;
        Predicate predicateMythic;
        String mainCode;
        PrintSheet ps = new PrintSheet(sheetKey);
        String[] sKey = TextUtil.splitWithParenthesis(sheetKey, ' ', 2);
        Predicate setPred = sKey.length > 1 ? IPaperCard.Predicates.printedInSets(sKey[1].split(" ")) : Predicates.alwaysTrue();
        LinkedList<String> operators = new LinkedList<String>(Arrays.asList(TextUtil.splitWithParenthesis(sKey[0], ':')));
        Predicate<PaperCard> extraPred = BoosterGenerator.buildExtraPredicate(operators);
        Iterator itMod = operators.iterator();
        while (itMod.hasNext()) {
            mainCode = (String)itMod.next();
            if (mainCode.regionMatches(true, 0, "fromSheet", 0, 9) || mainCode.regionMatches(true, 0, "wholeSheet", 0, 10)) {
                System.out.println("Parsing from main code: " + mainCode);
                String sheetName = StringUtils.strip(mainCode.substring(10), "()\" ");
                System.out.println("Attempting to lookup: " + sheetName);
                src = StaticData.instance().getPrintSheets().get(sheetName).toFlatList();
                setPred = Predicates.alwaysTrue();
            } else {
                if (!mainCode.startsWith("promo") && !mainCode.startsWith("name")) continue;
                String list = StringUtils.strip(mainCode.substring(5), "() ");
                String[] cardNames = TextUtil.splitWithParenthesis(list, ',', '\"', '\"');
                ArrayList<PaperCard> srcList = new ArrayList<PaperCard>();
                for (String cardName : cardNames) {
                    srcList.add(StaticData.instance().getCommonCards().getCard(cardName));
                }
                src = srcList;
                setPred = Predicates.alwaysTrue();
            }
            itMod.remove();
        }
        String string = mainCode = operators.isEmpty() ? null : ((String)operators.get(0)).trim();
        if (null == mainCode || mainCode.equalsIgnoreCase("Any")) {
            Predicate<PaperCard> predicate = Predicates.and(setPred, extraPred);
            ps.addAll(Iterables.filter(src, predicate));
        } else if (mainCode.equalsIgnoreCase("UncommonRare")) {
            Predicate predicateRares = Predicates.and(setPred, IPaperCard.Predicates.Presets.IS_RARE, extraPred);
            ps.addAll(Iterables.filter(src, predicateRares));
            Predicate predicateUncommon = Predicates.and(setPred, IPaperCard.Predicates.Presets.IS_UNCOMMON, extraPred);
            ps.addAll(Iterables.filter(src, predicateUncommon), 3);
        } else if (mainCode.equalsIgnoreCase("RareMythic")) {
            predicateMythic = Predicates.and(setPred, IPaperCard.Predicates.Presets.IS_MYTHIC_RARE, extraPred);
            ps.addAll(Iterables.filter(src, predicateMythic));
            predicateRare = Predicates.and(setPred, IPaperCard.Predicates.Presets.IS_RARE, extraPred);
            ps.addAll(Iterables.filter(src, predicateRare), 2);
        } else if (mainCode.equalsIgnoreCase("UncommonRareMythic")) {
            predicateMythic = Predicates.and(setPred, IPaperCard.Predicates.Presets.IS_MYTHIC_RARE, extraPred);
            ps.addAll(Iterables.filter(src, predicateMythic));
            predicateRare = Predicates.and(setPred, IPaperCard.Predicates.Presets.IS_RARE, extraPred);
            ps.addAll(Iterables.filter(src, predicateRare), 2);
            Predicate predicateUncommon = Predicates.and(setPred, IPaperCard.Predicates.Presets.IS_UNCOMMON, extraPred);
            ps.addAll(Iterables.filter(src, predicateUncommon), 4);
        } else {
            throw new IllegalArgumentException("Booster generator: operator could not be parsed - " + mainCode);
        }
        return ps;
    }

    private static Predicate<PaperCard> buildExtraPredicate(List<String> operators) {
        ArrayList conditions = new ArrayList();
        Iterator<String> itOp = operators.iterator();
        while (itOp.hasNext()) {
            boolean invert;
            String operator = itOp.next();
            if (StringUtils.isEmpty(operator)) {
                itOp.remove();
                continue;
            }
            if (operator.endsWith("s")) {
                operator = operator.substring(0, operator.length() - 1);
            }
            boolean bl = invert = operator.charAt(0) == '!';
            if (invert) {
                operator = operator.substring(1);
            }
            IPaperCard.Predicates.PredicateCards toAdd = null;
            if (operator.equalsIgnoreCase("dfc")) {
                toAdd = Predicates.compose(Predicates.or(CardRulesPredicates.splitType(CardSplitType.Transform), CardRulesPredicates.splitType(CardSplitType.Meld), CardRulesPredicates.splitType(CardSplitType.Modal)), PaperCard::getRules);
            } else if (operator.equalsIgnoreCase("Land")) {
                toAdd = Predicates.compose(CardRulesPredicates.Presets.IS_LAND, PaperCard::getRules);
            } else if (operator.equalsIgnoreCase("BasicLand")) {
                toAdd = IPaperCard.Predicates.Presets.IS_BASIC_LAND;
            } else if (operator.equalsIgnoreCase("TimeShifted")) {
                toAdd = IPaperCard.Predicates.Presets.IS_SPECIAL;
            } else if (operator.equalsIgnoreCase("Special")) {
                toAdd = IPaperCard.Predicates.Presets.IS_SPECIAL;
            } else if (operator.equalsIgnoreCase("Mythic")) {
                toAdd = IPaperCard.Predicates.Presets.IS_MYTHIC_RARE;
            } else if (operator.equalsIgnoreCase("Rare")) {
                toAdd = IPaperCard.Predicates.Presets.IS_RARE;
            } else if (operator.equalsIgnoreCase("Uncommon")) {
                toAdd = IPaperCard.Predicates.Presets.IS_UNCOMMON;
            } else if (operator.equalsIgnoreCase("Common")) {
                toAdd = IPaperCard.Predicates.Presets.IS_COMMON;
            } else if (operator.startsWith("name(")) {
                operator = StringUtils.strip(operator.substring(4), "() ");
                Object cardNames = TextUtil.splitWithParenthesis(operator, ',', '\"', '\"');
                toAdd = IPaperCard.Predicates.names(Lists.newArrayList(cardNames));
            } else if (operator.startsWith("color(")) {
                operator = StringUtils.strip(operator.substring("color(".length() + 1), "()\" ");
                switch (operator.toLowerCase()) {
                    case "black": {
                        toAdd = IPaperCard.Predicates.Presets.IS_BLACK;
                        break;
                    }
                    case "blue": {
                        toAdd = IPaperCard.Predicates.Presets.IS_BLUE;
                        break;
                    }
                    case "green": {
                        toAdd = IPaperCard.Predicates.Presets.IS_GREEN;
                        break;
                    }
                    case "red": {
                        toAdd = IPaperCard.Predicates.Presets.IS_RED;
                        break;
                    }
                    case "white": {
                        toAdd = IPaperCard.Predicates.Presets.IS_WHITE;
                        break;
                    }
                    case "colorless": {
                        toAdd = IPaperCard.Predicates.Presets.IS_COLORLESS;
                    }
                }
            } else if (operator.startsWith("fromSets(")) {
                operator = StringUtils.strip(operator.substring("fromSets(".length() + 1), "()\" ");
                String[] sets = operator.split(",");
                toAdd = IPaperCard.Predicates.printedInSets(sets);
            } else if (operator.startsWith("fromSheet(") && invert) {
                String sheetName = StringUtils.strip(operator.substring(9), "()\" ");
                Iterable<PaperCard> cards = StaticData.instance().getPrintSheets().get(sheetName).toFlatList();
                toAdd = IPaperCard.Predicates.cards(Lists.newArrayList(cards));
            }
            if (toAdd == null) continue;
            itOp.remove();
            if (invert) {
                toAdd = Predicates.not(toAdd);
            }
            conditions.add(toAdd);
        }
        if (conditions.isEmpty()) {
            return Predicates.alwaysTrue();
        }
        return Predicates.and(conditions);
    }
}

