/*
 * Decompiled with CFR 0.152.
 */
package forge.item;

import forge.StaticData;
import forge.card.CardEdition;
import forge.item.PaperCard;
import forge.item.SealedProduct;
import forge.item.SealedTemplate;
import forge.item.generation.BoosterGenerator;
import java.util.List;

public class TournamentPack
extends SealedProduct {
    public static TournamentPack fromSet(CardEdition edition) {
        SealedTemplate d = StaticData.instance().getTournamentPacks().get(edition.getCode());
        return new TournamentPack(edition.getName(), d);
    }

    public TournamentPack(String name0, SealedTemplate boosterData) {
        super(name0, boosterData);
    }

    public final boolean isStarterDeck() {
        return this.contents.getSlots().get(0).getRight() < 30;
    }

    @Override
    public final String getItemType() {
        return !this.isStarterDeck() ? "Tournament Pack" : "Starter Deck";
    }

    @Override
    protected List<PaperCard> generate() {
        return BoosterGenerator.getBoosterPack(this.contents);
    }

    public final Object clone() {
        return new TournamentPack(this.name, this.contents);
    }

    @Override
    public String getImageKey(boolean altState) {
        return "o:" + this.getEdition();
    }
}

