/*
 * Decompiled with CFR 0.152.
 */
package forge.item;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.StaticData;
import forge.card.CardRulesPredicates;
import forge.item.IPaperCard;
import forge.item.InventoryItemFromSet;
import forge.item.PaperCard;
import forge.item.SealedTemplate;
import forge.item.generation.BoosterGenerator;
import forge.util.Aggregates;
import java.util.ArrayList;
import java.util.List;

public abstract class SealedProduct
implements InventoryItemFromSet {
    public static final List<String> specialSets = new ArrayList<String>();
    protected final SealedTemplate contents;
    protected final String name;
    private final int hash;
    protected List<PaperCard> cards = null;

    public SealedProduct(String name0, SealedTemplate boosterData) {
        if (null == name0) {
            throw new IllegalArgumentException("name0 must not be null");
        }
        if (null == boosterData) {
            throw new IllegalArgumentException("boosterData for " + name0 + " must not be null");
        }
        this.contents = boosterData;
        this.name = name0;
        this.hash = this.name.hashCode() ^ this.getClass().hashCode() ^ this.contents.hashCode();
    }

    @Override
    public final String getName() {
        return this.name + " " + this.getItemType();
    }

    public String getDescription() {
        return this.contents.toString();
    }

    @Override
    public final String getEdition() {
        return this.contents.getEdition();
    }

    public List<PaperCard> getCards() {
        if (null == this.cards) {
            this.cards = this.generate();
        }
        return this.cards;
    }

    public int getTotalCards() {
        return this.contents.getNumberOfCardsExpected();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SealedProduct other = (SealedProduct)o;
        return this.contents.equals(other.contents) && this.name.equals(other.name);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.getName();
    }

    protected List<PaperCard> generate() {
        return BoosterGenerator.getBoosterPack(this.contents);
    }

    protected PaperCard getRandomBasicLand(String setCode) {
        return this.getRandomBasicLands(setCode, 1).get(0);
    }

    protected List<PaperCard> getRandomBasicLands(String setCode, int count) {
        Predicate<PaperCard> cardsRule = Predicates.and(IPaperCard.Predicates.printedInSet(setCode), Predicates.compose(CardRulesPredicates.Presets.IS_BASIC_LAND, PaperCard::getRules));
        return Aggregates.random(Iterables.filter(StaticData.instance().getCommonCards().getAllCards(), cardsRule), count);
    }

    static {
        specialSets.add("Black");
        specialSets.add("Blue");
        specialSets.add("Green");
        specialSets.add("Red");
        specialSets.add("White");
        specialSets.add("Colorless");
    }
}

