/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import forge.gui.GuiBase;
import forge.gui.util.SOptionPane;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SGuiChoose {
    public static <T> T oneOrNone(String message, T[] choices) {
        return SGuiChoose.oneOrNone(message, choices, null, null);
    }

    public static <T> T oneOrNone(String message, T[] choices, T selected, Function<T, String> display) {
        if (choices == null || choices.length == 0) {
            return null;
        }
        List<T> choice = SGuiChoose.getChoices(message, 0, 1, choices, selected, display);
        return choice.isEmpty() ? null : (T)choice.get(0);
    }

    public static <T> T oneOrNone(String message, Collection<T> choices) {
        return SGuiChoose.oneOrNone(message, choices, null, null);
    }

    public static <T> T oneOrNone(String message, Collection<T> choices, T selected, Function<T, String> display) {
        if (choices == null || choices.isEmpty()) {
            return null;
        }
        List<T> choice = SGuiChoose.getChoices(message, 0, 1, choices, selected, display);
        return choice.isEmpty() ? null : (T)choice.get(0);
    }

    public static <T> T one(String message, Collection<T> choices) {
        if (choices == null || choices.isEmpty()) {
            return null;
        }
        if (choices.size() == 1) {
            return Iterables.getFirst(choices, null);
        }
        List<T> choice = SGuiChoose.getChoices(message, 1, 1, choices);
        assert (choice.size() == 1);
        return choice.get(0);
    }

    public static <T> void reveal(String message, Collection<T> items) {
        SGuiChoose.getChoices(message, -1, -1, items);
    }

    public static Integer getInteger(String message, int min2, int max) {
        return SGuiChoose.getInteger(message, min2, max, false);
    }

    public static Integer getInteger(String message, int min2, int max, boolean sortDesc) {
        if (max <= min2) {
            return min2;
        }
        if (max == Integer.MAX_VALUE) {
            return SGuiChoose.getInteger(message, min2, max, min2 + 99);
        }
        int count = max - min2 + 1;
        if (count > 100) {
            return SGuiChoose.getInteger(message, min2, max, min2 + 99);
        }
        Integer[] choices = new Integer[count];
        if (sortDesc) {
            for (int i = 0; i < count; ++i) {
                choices[count - i - 1] = i + min2;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                choices[i] = i + min2;
            }
        }
        return SGuiChoose.oneOrNone(message, choices);
    }

    public static Integer getInteger(String message, int min2, int max, int cutoff) {
        int val;
        String str;
        if (max <= min2 || cutoff < min2) {
            return min2;
        }
        if (cutoff >= max) {
            return SGuiChoose.getInteger(message, min2, max);
        }
        ArrayList<Object> choices = new ArrayList<Object>();
        for (int i = min2; i <= cutoff; ++i) {
            choices.add(i);
        }
        choices.add("...");
        Object choice = SGuiChoose.oneOrNone(message, choices);
        if (choice instanceof Integer || choice == null) {
            return (Integer)choice;
        }
        String prompt = "Enter a number";
        if (min2 != Integer.MIN_VALUE) {
            prompt = max != Integer.MAX_VALUE ? prompt + " between " + min2 + " and " + max : prompt + " greater than or equal to " + min2;
        } else if (max != Integer.MAX_VALUE) {
            prompt = prompt + " less than or equal to " + max;
        }
        prompt = prompt + ":";
        do {
            if ((str = SOptionPane.showInputDialog(prompt, message)) != null) continue;
            return null;
        } while (!StringUtils.isNumeric(str) || (val = Integer.parseInt(str)) < min2 || val > max);
        return val;
    }

    public static <T> List<T> getChoices(String message, int min2, int max, T[] choices) {
        return SGuiChoose.getChoices(message, min2, max, Arrays.asList(choices), null, null);
    }

    public static <T> List<T> getChoices(String message, int min2, int max, T[] choices, T selected, Function<T, String> display) {
        return SGuiChoose.getChoices(message, min2, max, Arrays.asList(choices), selected, display);
    }

    public static <T> List<T> getChoices(String message, int min2, int max, Collection<T> choices) {
        return SGuiChoose.getChoices(message, min2, max, choices, null, null);
    }

    public static <T> List<T> getChoices(String message, int min2, int max, Collection<T> choices, T selected, Function<T, String> display) {
        return GuiBase.getInterface().getChoices(message, min2, max, choices, selected, display);
    }

    public static <T> List<T> many(String title, String topCaption, int cnt, List<T> sourceChoices) {
        return SGuiChoose.many(title, topCaption, cnt, cnt, sourceChoices);
    }

    public static <T> List<T> many(String title, String topCaption, int min2, int max, List<T> sourceChoices) {
        int m1 = max >= 0 ? sourceChoices.size() - max : -1;
        int m22 = min2 >= 0 ? sourceChoices.size() - min2 : -1;
        return SGuiChoose.order(title, topCaption, m1, m22, sourceChoices, null);
    }

    public static <T> List<T> order(String title, String top, List<T> sourceChoices) {
        return SGuiChoose.order(title, top, 0, 0, sourceChoices, null);
    }

    public static <T> List<T> order(String title, String top, int remainingObjectsMin, int remainingObjectsMax, List<T> sourceChoices, List<T> destChoices) {
        return GuiBase.getInterface().order(title, top, remainingObjectsMin, remainingObjectsMax, sourceChoices, destChoices);
    }
}

