/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.interfaces;

import com.google.common.base.Function;
import forge.LobbyPlayer;
import forge.ai.GameState;
import forge.deck.CardPool;
import forge.game.GameEntityView;
import forge.game.GameView;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.event.GameEventSpellAbilityCast;
import forge.game.event.GameEventSpellRemovedFromStack;
import forge.game.phase.PhaseType;
import forge.game.player.DelayedReveal;
import forge.game.player.IHasIcon;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbilityView;
import forge.game.zone.ZoneType;
import forge.gui.control.PlaybackSpeed;
import forge.interfaces.IGameController;
import forge.item.PaperCard;
import forge.localinstance.skin.FSkinProp;
import forge.player.PlayerZoneUpdate;
import forge.player.PlayerZoneUpdates;
import forge.trackable.TrackableCollection;
import forge.util.ITriggerEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface IGuiGame {
    public void setGameView(GameView var1);

    public GameView getGameView();

    public void setOriginalGameController(PlayerView var1, IGameController var2);

    public void setGameController(PlayerView var1, IGameController var2);

    public void setSpectator(IGameController var1);

    public void openView(TrackableCollection<PlayerView> var1);

    public void afterGameEnd();

    public void showCombat();

    public void showPromptMessage(PlayerView var1, String var2);

    public void showCardPromptMessage(PlayerView var1, String var2, CardView var3);

    public void updateButtons(PlayerView var1, boolean var2, boolean var3, boolean var4);

    public void updateButtons(PlayerView var1, String var2, String var3, boolean var4, boolean var5, boolean var6);

    public void flashIncorrectAction();

    public void alertUser();

    public void updatePhase(boolean var1);

    public void updateTurn(PlayerView var1);

    public void updatePlayerControl();

    public void enableOverlay();

    public void disableOverlay();

    public void finishGame();

    public void showManaPool(PlayerView var1);

    public void hideManaPool(PlayerView var1);

    public void updateStack();

    public void notifyStackAddition(GameEventSpellAbilityCast var1);

    public void notifyStackRemoval(GameEventSpellRemovedFromStack var1);

    public void handleLandPlayed(Card var1);

    public Iterable<PlayerZoneUpdate> tempShowZones(PlayerView var1, Iterable<PlayerZoneUpdate> var2);

    public void hideZones(PlayerView var1, Iterable<PlayerZoneUpdate> var2);

    public void updateZones(Iterable<PlayerZoneUpdate> var1);

    public void updateSingleCard(CardView var1);

    public void updateCards(Iterable<CardView> var1);

    public void updateRevealedCards(TrackableCollection<CardView> var1);

    public void refreshCardDetails(Iterable<CardView> var1);

    public void refreshField();

    public GameState getGamestate();

    public void updateManaPool(Iterable<PlayerView> var1);

    public void updateLives(Iterable<PlayerView> var1);

    public void updateShards(Iterable<PlayerView> var1);

    public void setPanelSelection(CardView var1);

    public SpellAbilityView getAbilityToPlay(CardView var1, List<SpellAbilityView> var2, ITriggerEvent var3);

    public Map<CardView, Integer> assignCombatDamage(CardView var1, List<CardView> var2, int var3, GameEntityView var4, boolean var5, boolean var6);

    public Map<Object, Integer> assignGenericAmount(CardView var1, Map<Object, Integer> var2, int var3, boolean var4, String var5);

    public void message(String var1);

    public void message(String var1, String var2);

    public void showErrorDialog(String var1);

    public void showErrorDialog(String var1, String var2);

    public boolean showConfirmDialog(String var1, String var2);

    public boolean showConfirmDialog(String var1, String var2, boolean var3);

    public boolean showConfirmDialog(String var1, String var2, String var3, String var4);

    public boolean showConfirmDialog(String var1, String var2, String var3, String var4, boolean var5);

    public int showOptionDialog(String var1, String var2, FSkinProp var3, List<String> var4, int var5);

    public String showInputDialog(String var1, String var2, boolean var3);

    public String showInputDialog(String var1, String var2, FSkinProp var3);

    public String showInputDialog(String var1, String var2, FSkinProp var3, String var4);

    public String showInputDialog(String var1, String var2, FSkinProp var3, String var4, List<String> var5, boolean var6);

    public boolean confirm(CardView var1, String var2);

    public boolean confirm(CardView var1, String var2, List<String> var3);

    public boolean confirm(CardView var1, String var2, boolean var3, List<String> var4);

    public <T> List<T> getChoices(String var1, int var2, int var3, List<T> var4);

    public <T> List<T> getChoices(String var1, int var2, int var3, List<T> var4, T var5, Function<T, String> var6);

    public Integer getInteger(String var1, int var2);

    public Integer getInteger(String var1, int var2, int var3);

    public Integer getInteger(String var1, int var2, int var3, boolean var4);

    public Integer getInteger(String var1, int var2, int var3, int var4);

    public <T> T oneOrNone(String var1, List<T> var2);

    public <T> T one(String var1, List<T> var2);

    public <T> void reveal(String var1, List<T> var2);

    public <T> List<T> many(String var1, String var2, int var3, List<T> var4, CardView var5);

    public <T> List<T> many(String var1, String var2, int var3, int var4, List<T> var5, CardView var6);

    public <T> List<T> order(String var1, String var2, List<T> var3, CardView var4);

    public <T> List<T> order(String var1, String var2, int var3, int var4, List<T> var5, List<T> var6, CardView var7, boolean var8);

    public <T> List<T> insertInList(String var1, T var2, List<T> var3);

    public List<PaperCard> sideboard(CardPool var1, CardPool var2, String var3);

    public GameEntityView chooseSingleEntityForEffect(String var1, List<? extends GameEntityView> var2, DelayedReveal var3, boolean var4);

    public List<GameEntityView> chooseEntitiesForEffect(String var1, List<? extends GameEntityView> var2, int var3, int var4, DelayedReveal var5);

    public List<CardView> manipulateCardList(String var1, Iterable<CardView> var2, Iterable<CardView> var3, boolean var4, boolean var5, boolean var6);

    public void setCard(CardView var1);

    public void setPlayerAvatar(LobbyPlayer var1, IHasIcon var2);

    public PlayerZoneUpdates openZones(PlayerView var1, Collection<ZoneType> var2, Map<PlayerView, Object> var3, boolean var4);

    public void restoreOldZones(PlayerView var1, PlayerZoneUpdates var2);

    public void setHighlighted(PlayerView var1, boolean var2);

    public void setUsedToPay(CardView var1, boolean var2);

    public void setSelectables(Iterable<CardView> var1);

    public void clearSelectables();

    public boolean isSelecting();

    public boolean isGamePaused();

    public void setgamePause(boolean var1);

    public void setGameSpeed(PlaybackSpeed var1);

    public String getDayTime();

    public void updateDayTime(String var1);

    public void awaitNextInput();

    public void cancelAwaitNextInput();

    public boolean isUiSetToSkipPhase(PlayerView var1, PhaseType var2);

    public void autoPassUntilEndOfTurn(PlayerView var1);

    public boolean mayAutoPass(PlayerView var1);

    public void autoPassCancel(PlayerView var1);

    public void updateAutoPassPrompt();

    public boolean shouldAutoYield(String var1);

    public void setShouldAutoYield(String var1, boolean var2);

    public boolean shouldAlwaysAcceptTrigger(int var1);

    public boolean shouldAlwaysDeclineTrigger(int var1);

    public void setShouldAlwaysAcceptTrigger(int var1);

    public void setShouldAlwaysDeclineTrigger(int var1);

    public void setShouldAlwaysAskTrigger(int var1);

    public void clearAutoYields();

    public void setCurrentPlayer(PlayerView var1);
}

