/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.framework;

import forge.gui.MouseUtil;
import forge.gui.framework.DragCell;
import forge.gui.framework.RectangleOfDouble;
import forge.gui.framework.SLayoutIO;
import forge.gui.framework.SRearrangingUtil;
import forge.toolbox.FAbsolutePositioner;
import forge.toolbox.FOverlay;
import forge.toolbox.FPanel;
import forge.view.FDialog;
import forge.view.FFrame;
import forge.view.FNavigationBar;
import forge.view.FView;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;

public final class SResizingUtil {
    private static final List<DragCell> LEFT_PANELS = new ArrayList<DragCell>();
    private static final List<DragCell> RIGHT_PANELS = new ArrayList<DragCell>();
    private static final List<DragCell> TOP_PANELS = new ArrayList<DragCell>();
    private static final List<DragCell> BOTTOM_PANELS = new ArrayList<DragCell>();
    private static int dX;
    private static int evtX;
    private static int dY;
    private static int evtY;
    public static final int W_MIN = 100;
    public static final int H_MIN = 75;
    private static final MouseListener MAD_RESIZE_X;
    private static final MouseListener MAD_RESIZE_Y;
    private static final MouseMotionListener MMA_DRAG_X;
    private static final MouseMotionListener MMA_DRAG_Y;
    private static final ComponentListener CAD_RESIZE;

    public static void resizeWindow() {
        List<DragCell> cells = FView.SINGLETON_INSTANCE.getDragCells();
        FFrame frame = FView.SINGLETON_INSTANCE.getFrame();
        FNavigationBar navigationBar = FView.SINGLETON_INSTANCE.getNavigationBar();
        JPanel pnlContent = FView.SINGLETON_INSTANCE.getPnlContent();
        FPanel pnlInsets = FView.SINGLETON_INSTANCE.getPnlInsets();
        Rectangle mainBounds = frame.getContentPane().getBounds();
        FDialog.getBackdropPanel().setBounds(mainBounds);
        int navigationBarHeight = navigationBar.getPreferredSize().height;
        navigationBar.setSize(mainBounds.width, navigationBarHeight);
        navigationBar.validate();
        if (!frame.isTitleBarHidden()) {
            mainBounds.y += navigationBarHeight;
            mainBounds.height -= navigationBarHeight;
        }
        FAbsolutePositioner.SINGLETON_INSTANCE.containerResized(mainBounds);
        FOverlay.SINGLETON_INSTANCE.getPanel().setBounds(mainBounds);
        pnlInsets.setBounds(mainBounds);
        pnlInsets.validate();
        int w = pnlContent.getWidth();
        int h2 = pnlContent.getHeight();
        double roughVal = 0.0;
        int smoothVal = 0;
        HashSet<Component> existingComponents = new HashSet<Component>(Arrays.asList(pnlContent.getComponents()));
        for (DragCell cellA : cells) {
            RectangleOfDouble cellSizeB;
            RectangleOfDouble cellSizeA = cellA.getRoughBounds();
            roughVal = cellSizeA.getX() * (double)w + cellSizeA.getW() * (double)w;
            smoothVal = (int)Math.round(roughVal);
            for (DragCell cellB : cells) {
                cellSizeB = cellB.getRoughBounds();
                if (cellSizeB.getX() * (double)w + cellSizeB.getW() * (double)w != roughVal) continue;
                cellB.setSmoothW(smoothVal - (int)Math.round(cellSizeB.getX() * (double)w));
            }
            cellA.setSmoothW(smoothVal - (int)Math.round(cellSizeA.getX() * (double)w));
            roughVal = cellSizeA.getY() * (double)h2 + cellSizeA.getH() * (double)h2;
            smoothVal = (int)Math.round(roughVal);
            for (DragCell cellB : cells) {
                cellSizeB = cellB.getRoughBounds();
                if (cellSizeB.getY() * (double)h2 + cellSizeB.getH() * (double)h2 != roughVal) continue;
                cellB.setSmoothH(smoothVal - (int)Math.round(cellSizeB.getY() * (double)h2));
            }
            cellA.setSmoothH(smoothVal - (int)Math.round(cellSizeA.getY() * (double)h2));
            cellA.setSmoothX((int)Math.round(cellSizeA.getX() * (double)w));
            cellA.setSmoothY((int)Math.round(cellSizeA.getY() * (double)h2));
            if (existingComponents.contains(cellA)) continue;
            pnlContent.add(cellA);
        }
        for (DragCell t2 : cells) {
            t2.setSmoothBounds();
            t2.validate();
            t2.refresh();
        }
        cells.clear();
    }

    public static void resizeX(MouseEvent e) {
        dX = (int)e.getLocationOnScreen().getX() - evtX;
        evtX = (int)e.getLocationOnScreen().getX();
        boolean leftLock = false;
        boolean rightLock = false;
        for (DragCell t2 : LEFT_PANELS) {
            if (t2.getW() + dX >= 100) continue;
            leftLock = true;
            break;
        }
        for (DragCell t2 : RIGHT_PANELS) {
            if (t2.getW() - dX >= 100) continue;
            rightLock = true;
            break;
        }
        if (dX < 0 && leftLock) {
            return;
        }
        if (dX > 0 && rightLock) {
            return;
        }
        for (DragCell t2 : LEFT_PANELS) {
            t2.setBounds(t2.getX(), t2.getY(), t2.getW() + dX, t2.getH());
            t2.refresh();
        }
        for (DragCell t2 : RIGHT_PANELS) {
            t2.setBounds(t2.getX() + dX, t2.getY(), t2.getW() - dX, t2.getH());
            t2.refresh();
        }
    }

    public static void resizeY(MouseEvent e) {
        dY = (int)e.getLocationOnScreen().getY() - evtY;
        evtY = (int)e.getLocationOnScreen().getY();
        boolean topLock = false;
        boolean bottomLock = false;
        for (DragCell t2 : TOP_PANELS) {
            if (t2.getH() + dY >= 75) continue;
            topLock = true;
            break;
        }
        for (DragCell t2 : BOTTOM_PANELS) {
            if (t2.getH() - dY >= 75) continue;
            bottomLock = true;
            break;
        }
        if (dY < 0 && topLock) {
            return;
        }
        if (dY > 0 && bottomLock) {
            return;
        }
        for (DragCell t2 : TOP_PANELS) {
            t2.setBounds(t2.getX(), t2.getY(), t2.getW(), t2.getH() + dY);
            t2.revalidate();
            t2.repaintSelf();
        }
        for (DragCell t2 : BOTTOM_PANELS) {
            t2.setBounds(t2.getX(), t2.getY() + dY, t2.getW(), t2.getH() - dY);
            t2.revalidate();
            t2.repaintSelf();
        }
    }

    public static void startResizeX(MouseEvent e) {
        MouseUtil.lockCursor();
        evtX = (int)e.getLocationOnScreen().getX();
        LEFT_PANELS.clear();
        RIGHT_PANELS.clear();
        DragCell src = (DragCell)((JPanel)e.getSource()).getParent();
        int srcX2 = src.getAbsX2();
        int limTop = -1;
        int limBottom = Integer.MAX_VALUE;
        int tempX = -1;
        int tempX2 = -1;
        int tempY = -1;
        int tempY2 = -1;
        for (DragCell t2 : FView.SINGLETON_INSTANCE.getDragCells()) {
            tempX = t2.getAbsX();
            tempX2 = t2.getAbsX2();
            if (srcX2 == tempX) {
                RIGHT_PANELS.add(t2);
                continue;
            }
            if (srcX2 != tempX2) continue;
            LEFT_PANELS.add(t2);
        }
        for (DragCell pnlL : LEFT_PANELS) {
            if (pnlL.equals(src)) continue;
            tempY = pnlL.getAbsY();
            tempY2 = pnlL.getAbsY2();
            for (DragCell pnlR : RIGHT_PANELS) {
                if (tempY >= src.getAbsY2() && tempY == pnlR.getAbsY() && tempY < limBottom) {
                    limBottom = tempY;
                    continue;
                }
                if (tempY2 > src.getAbsY() || tempY2 != pnlR.getAbsY2() || tempY2 <= limTop) continue;
                limTop = tempY2;
            }
        }
        Iterator<DragCell> itrLeft = LEFT_PANELS.iterator();
        while (itrLeft.hasNext()) {
            DragCell t2;
            t2 = itrLeft.next();
            if (t2.getAbsY() < limBottom && t2.getAbsY2() > limTop) continue;
            itrLeft.remove();
        }
        Iterator<DragCell> itrRight = RIGHT_PANELS.iterator();
        while (itrRight.hasNext()) {
            DragCell t3 = itrRight.next();
            if (t3.getAbsY() < limBottom && t3.getAbsY2() > limTop) continue;
            itrRight.remove();
        }
    }

    public static void startResizeY(MouseEvent e) {
        MouseUtil.lockCursor();
        evtY = (int)e.getLocationOnScreen().getY();
        TOP_PANELS.clear();
        BOTTOM_PANELS.clear();
        DragCell src = (DragCell)((JPanel)e.getSource()).getParent();
        int srcY2 = src.getAbsY2();
        int limLeft = -1;
        int limRight = Integer.MAX_VALUE;
        int tempX = -1;
        int tempX2 = -1;
        int tempY = -1;
        int tempY2 = -1;
        for (DragCell t2 : FView.SINGLETON_INSTANCE.getDragCells()) {
            tempY = t2.getAbsY();
            tempY2 = t2.getAbsY2();
            if (srcY2 == tempY) {
                BOTTOM_PANELS.add(t2);
                continue;
            }
            if (srcY2 != tempY2) continue;
            TOP_PANELS.add(t2);
        }
        for (DragCell pnlT : TOP_PANELS) {
            if (pnlT.equals(src)) continue;
            tempX = pnlT.getAbsX();
            tempX2 = pnlT.getAbsX2();
            for (DragCell pnlB : BOTTOM_PANELS) {
                if (tempX >= src.getAbsX2() && tempX == pnlB.getAbsX() && tempX < limRight) {
                    limRight = tempX;
                    continue;
                }
                if (tempX2 > src.getAbsX() || tempX2 != pnlB.getAbsX2() || tempX2 <= limLeft) continue;
                limLeft = tempX2;
            }
        }
        Iterator<DragCell> itrTop = TOP_PANELS.iterator();
        while (itrTop.hasNext()) {
            DragCell t2;
            t2 = itrTop.next();
            if (t2.getAbsX() < limRight && t2.getAbsX2() > limLeft) continue;
            itrTop.remove();
        }
        Iterator<DragCell> itrBottom = BOTTOM_PANELS.iterator();
        while (itrBottom.hasNext()) {
            DragCell t3 = itrBottom.next();
            if (t3.getAbsX() < limRight && t3.getAbsX2() > limLeft) continue;
            itrBottom.remove();
        }
    }

    public static void endResize() {
        MouseUtil.unlockCursor();
        SLayoutIO.saveLayout(null);
    }

    public static MouseListener getResizeXListener() {
        return MAD_RESIZE_X;
    }

    public static MouseListener getResizeYListener() {
        return MAD_RESIZE_Y;
    }

    public static MouseMotionListener getDragXListener() {
        return MMA_DRAG_X;
    }

    public static MouseMotionListener getDragYListener() {
        return MMA_DRAG_Y;
    }

    public static ComponentListener getWindowResizeListener() {
        return CAD_RESIZE;
    }

    static {
        MAD_RESIZE_X = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                MouseUtil.setCursor(11);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MouseUtil.resetCursor();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SResizingUtil.startResizeX(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SResizingUtil.endResize();
            }
        };
        MAD_RESIZE_Y = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                MouseUtil.setCursor(8);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MouseUtil.resetCursor();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SResizingUtil.startResizeY(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SResizingUtil.endResize();
            }
        };
        MMA_DRAG_X = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                SResizingUtil.resizeX(e);
            }
        };
        MMA_DRAG_Y = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                SResizingUtil.resizeY(e);
            }
        };
        CAD_RESIZE = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SResizingUtil.resizeWindow();
                SRearrangingUtil.updateBorders();
            }
        };
    }
}

