/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.framework;

import forge.gui.MouseUtil;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.ICDoc;
import forge.gui.framework.IVDoc;
import forge.gui.framework.SLayoutIO;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FSkin;
import forge.view.FView;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public final class SRearrangingUtil {
    private static int evtX;
    private static int evtY;
    private static int tempX;
    private static int tempY;
    private static int tempW;
    private static int tempH;
    private static JPanel pnlPreview;
    private static FSkin.SkinnedLayeredPane pnlDocument;
    private static DragCell cellTarget;
    private static DragCell cellSrc;
    private static DragCell cellNew;
    private static Dropzone dropzone;
    private static List<IVDoc<? extends ICDoc>> docsToMove;
    private static IVDoc<? extends ICDoc> srcSelectedDoc;
    private static final FSkin.SkinCursor CUR_L;
    private static final FSkin.SkinCursor CUR_T;
    private static final FSkin.SkinCursor CUR_B;
    private static final FSkin.SkinCursor CUR_R;
    private static final FSkin.SkinCursor CUR_TAB;
    private static final MouseListener MAD_REARRANGE;
    private static final MouseMotionListener MMA_REARRANGE;

    private static void startRearrange(MouseEvent e) {
        cellSrc = (DragCell)((Container)e.getSource()).getParent().getParent();
        docsToMove.clear();
        dropzone = Dropzone.NONE;
        srcSelectedDoc = cellSrc.getSelected();
        if (e.getSource() instanceof DragTab) {
            for (IVDoc<? extends ICDoc> vDoc : cellSrc.getDocs()) {
                if (vDoc.getTabLabel() != e.getSource()) continue;
                cellSrc.setSelected(vDoc);
                docsToMove.add(vDoc);
            }
        } else {
            docsToMove.addAll(cellSrc.getDocs());
        }
        pnlPreview.setVisible(true);
        pnlPreview.setBounds(0, 0, 0, 0);
    }

    private static void rearrange(MouseEvent e) {
        int nestingMargin = 30;
        evtX = (int)e.getLocationOnScreen().getX();
        evtY = (int)e.getLocationOnScreen().getY();
        for (DragCell t2 : FView.SINGLETON_INSTANCE.getDragCells()) {
            tempX = t2.getAbsX();
            tempY = t2.getAbsY();
            tempW = t2.getW();
            tempH = t2.getH();
            if (evtX < tempX || evtY < tempY || evtX > tempX + tempW || evtY > tempY + tempH) continue;
            cellTarget = t2;
            break;
        }
        if (evtX < tempX + 30 && evtY > tempY + 20 && cellTarget.getW() / 2 > 100) {
            dropzone = Dropzone.LEFT;
            pnlDocument.setCursor(CUR_L);
            pnlPreview.setBounds(cellTarget.getX() + 5, cellTarget.getY() + 5, (tempW - 5) / 2, tempH - 5);
        } else if (evtX > tempX + tempW - 30 && evtY > tempY + 20 && cellTarget.getW() / 2 > 100) {
            dropzone = Dropzone.RIGHT;
            pnlDocument.setCursor(CUR_R);
            tempW = cellTarget.getW() / 2;
            pnlPreview.setBounds(cellTarget.getX() + cellTarget.getW() - tempW, cellTarget.getY() + 5, tempW, tempH - 5);
        } else if (evtY < tempY + 30 + 20 && evtY > tempY + 20 && cellTarget.getH() / 2 > 75) {
            dropzone = Dropzone.TOP;
            pnlDocument.setCursor(CUR_T);
            pnlPreview.setBounds(cellTarget.getX() + 5, cellTarget.getY() + 5, tempW - 5, tempH / 2);
        } else if (evtY > tempY + tempH - 30 && cellTarget.getH() / 2 > 75) {
            dropzone = Dropzone.BOTTOM;
            pnlDocument.setCursor(CUR_B);
            tempH = cellTarget.getH() / 2;
            pnlPreview.setBounds(cellTarget.getX() + 5, cellTarget.getY() + cellTarget.getH() - tempH, tempW - 5, tempH);
        } else if (cellTarget.equals(cellSrc)) {
            dropzone = Dropzone.NONE;
            MouseUtil.resetCursor();
            pnlPreview.setBounds(0, 0, 0, 0);
        } else {
            dropzone = Dropzone.BODY;
            pnlDocument.setCursor(CUR_TAB);
            pnlPreview.setBounds(cellTarget.getX() + 5, cellTarget.getY() + 5, tempW - 5, tempH - 5);
        }
    }

    private static void endRearrange() {
        MouseUtil.resetCursor();
        pnlPreview.setVisible(false);
        pnlPreview.setBounds(0, 0, 0, 0);
        if (dropzone.equals((Object)Dropzone.NONE) || cellTarget.equals(cellSrc) && cellSrc.getDocs().size() == 1) {
            if (srcSelectedDoc != cellSrc.getSelected()) {
                SLayoutIO.saveLayout(null);
            }
            srcSelectedDoc = null;
            return;
        }
        tempX = cellTarget.getX();
        tempY = cellTarget.getY();
        tempW = cellTarget.getW();
        tempH = cellTarget.getH();
        cellNew = new DragCell();
        switch (dropzone) {
            case LEFT: {
                cellNew.setBounds(tempX, tempY, tempW / 2, tempH);
                cellTarget.setBounds(tempX + cellNew.getW(), tempY, tempW - cellNew.getW(), tempH);
                FView.SINGLETON_INSTANCE.addDragCell(cellNew);
                break;
            }
            case RIGHT: {
                cellTarget.setBounds(tempX, tempY, tempW / 2, tempH);
                cellNew.setBounds(cellTarget.getX() + cellTarget.getW(), tempY, tempW - cellTarget.getW(), tempH);
                FView.SINGLETON_INSTANCE.addDragCell(cellNew);
                break;
            }
            case TOP: {
                cellNew.setBounds(tempX, tempY, tempW, tempH - tempH / 2);
                cellTarget.setBounds(tempX, tempY + cellNew.getH(), tempW, tempH - cellNew.getH());
                FView.SINGLETON_INSTANCE.addDragCell(cellNew);
                break;
            }
            case BOTTOM: {
                cellTarget.setBounds(tempX, tempY, tempW, tempH / 2);
                cellNew.setBounds(tempX, cellTarget.getY() + cellTarget.getH(), tempW, tempH - cellTarget.getH());
                FView.SINGLETON_INSTANCE.addDragCell(cellNew);
                break;
            }
            case BODY: {
                cellNew = cellTarget;
                break;
            }
        }
        for (IVDoc<? extends ICDoc> vDoc : docsToMove) {
            cellSrc.removeDoc(vDoc);
            cellNew.addDoc(vDoc);
            cellNew.setSelected(vDoc);
        }
        if (cellSrc.getDocs().size() == 0) {
            SRearrangingUtil.fillGap();
            FView.SINGLETON_INSTANCE.removeDragCell(cellSrc);
        }
        cellNew.updateRoughBounds();
        cellTarget.updateRoughBounds();
        cellSrc.setSelected(srcSelectedDoc);
        srcSelectedDoc = null;
        cellSrc.refresh();
        cellTarget.refresh();
        cellNew.validate();
        cellNew.refresh();
        SRearrangingUtil.updateBorders();
        SLayoutIO.saveLayout(null);
    }

    private static void fillGap() {
        ArrayList<DragCell> cellsToResize = new ArrayList<DragCell>();
        int srcX = cellSrc.getAbsX();
        int srcX2 = cellSrc.getAbsX2();
        int srcY = cellSrc.getAbsY();
        int srcY2 = cellSrc.getAbsY2();
        int srcW = cellSrc.getW();
        int srcH = cellSrc.getH();
        boolean foundT = false;
        boolean foundB = false;
        boolean foundR = false;
        boolean foundL = false;
        cellsToResize.clear();
        foundT = false;
        foundB = false;
        for (DragCell cell : FView.SINGLETON_INSTANCE.getDragCells()) {
            if (cell.getAbsX2() != srcX) continue;
            if (cell.getAbsY() == srcY) {
                foundT = true;
                cellsToResize.add(cell);
            }
            if (cell.getAbsY2() == srcY2) {
                foundB = true;
                if (!cellsToResize.contains(cell)) {
                    cellsToResize.add(cell);
                }
            }
            if (cell.getAbsY() <= srcY || cell.getAbsY2() >= srcY2) continue;
            cellsToResize.add(cell);
        }
        if (foundT && foundB) {
            for (DragCell cell : cellsToResize) {
                cell.setBounds(cell.getX(), cell.getY(), cell.getW() + srcW, cell.getH());
                cell.updateRoughBounds();
            }
            return;
        }
        cellsToResize.clear();
        foundT = false;
        foundB = false;
        for (DragCell cell : FView.SINGLETON_INSTANCE.getDragCells()) {
            if (cell.getAbsX() != srcX2) continue;
            if (cell.getAbsY() == srcY) {
                foundT = true;
                cellsToResize.add(cell);
            }
            if (cell.getAbsY2() == srcY2) {
                foundB = true;
                if (!cellsToResize.contains(cell)) {
                    cellsToResize.add(cell);
                }
            }
            if (cell.getAbsY() <= srcY || cell.getAbsY2() >= srcY2) continue;
            cellsToResize.add(cell);
        }
        if (foundT && foundB) {
            for (DragCell cell : cellsToResize) {
                cell.setBounds(cellSrc.getX(), cell.getY(), cell.getW() + srcW, cell.getH());
                cell.updateRoughBounds();
            }
            return;
        }
        cellsToResize.clear();
        foundL = false;
        foundR = false;
        for (DragCell cell : FView.SINGLETON_INSTANCE.getDragCells()) {
            if (cell.getAbsY() != srcY2) continue;
            if (cell.getAbsX() == srcX) {
                foundL = true;
                cellsToResize.add(cell);
            }
            if (cell.getAbsX2() == srcX2) {
                foundR = true;
                if (!cellsToResize.contains(cell)) {
                    cellsToResize.add(cell);
                }
            }
            if (cell.getAbsX() <= srcX || cell.getAbsX2() >= srcX2) continue;
            cellsToResize.add(cell);
        }
        if (foundL && foundR) {
            for (DragCell cell : cellsToResize) {
                cell.setBounds(cell.getX(), cellSrc.getY(), cell.getW(), cell.getH() + srcH);
                cell.updateRoughBounds();
            }
            return;
        }
        cellsToResize.clear();
        foundL = false;
        foundR = false;
        for (DragCell cell : FView.SINGLETON_INSTANCE.getDragCells()) {
            if (cell.getAbsY2() != srcY) continue;
            if (cell.getAbsX() == srcX) {
                foundL = true;
                cellsToResize.add(cell);
            }
            if (cell.getAbsX2() == srcX2) {
                foundR = true;
                if (!cellsToResize.contains(cell)) {
                    cellsToResize.add(cell);
                }
            }
            if (cell.getAbsX() <= srcX || cell.getAbsX2() >= srcX2) continue;
            cellsToResize.add(cell);
        }
        if (foundL && foundR) {
            for (DragCell cell : cellsToResize) {
                cell.setBounds(cell.getX(), cell.getY(), cell.getW(), cell.getH() + srcH);
                cell.updateRoughBounds();
            }
            return;
        }
        throw new UnsupportedOperationException("Gap was not filled.");
    }

    public static void fillGap(DragCell sourceCell0) {
        cellSrc = sourceCell0;
        SRearrangingUtil.fillGap();
    }

    public static void updateBorders() {
        List<DragCell> cells = FView.SINGLETON_INSTANCE.getDragCells();
        JPanel pnlContent = FView.SINGLETON_INSTANCE.getPnlContent();
        for (DragCell t2 : cells) {
            if ((double)t2.getAbsX2() == pnlContent.getLocationOnScreen().getX() + (double)pnlContent.getWidth()) {
                t2.getBorderRight().setVisible(false);
            } else {
                t2.getBorderRight().setVisible(true);
            }
            if ((double)t2.getAbsY2() == pnlContent.getLocationOnScreen().getY() + (double)pnlContent.getHeight()) {
                t2.getBorderBottom().setVisible(false);
                continue;
            }
            t2.getBorderBottom().setVisible(true);
        }
        cells.clear();
    }

    public static MouseListener getRearrangeClickEvent() {
        return MAD_REARRANGE;
    }

    public static MouseMotionListener getRearrangeDragEvent() {
        return MMA_REARRANGE;
    }

    static {
        pnlPreview = FView.SINGLETON_INSTANCE.getPnlPreview();
        pnlDocument = FView.SINGLETON_INSTANCE.getLpnDocument();
        cellTarget = null;
        cellSrc = null;
        cellNew = null;
        dropzone = Dropzone.NONE;
        docsToMove = new ArrayList<IVDoc<? extends ICDoc>>();
        srcSelectedDoc = null;
        CUR_L = FSkin.getCursor(FSkinProp.IMG_CUR_L, 16, 16, "CUR_L");
        CUR_T = FSkin.getCursor(FSkinProp.IMG_CUR_T, 16, 16, "CUR_T");
        CUR_B = FSkin.getCursor(FSkinProp.IMG_CUR_B, 16, 16, "CUR_B");
        CUR_R = FSkin.getCursor(FSkinProp.IMG_CUR_R, 16, 16, "CUR_R");
        CUR_TAB = FSkin.getCursor(FSkinProp.IMG_CUR_TAB, 16, 16, "CUR_TAB");
        MAD_REARRANGE = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SRearrangingUtil.startRearrange(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SRearrangingUtil.endRearrange();
            }
        };
        MMA_REARRANGE = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                SRearrangingUtil.rearrange(e);
            }
        };
    }

    private static enum Dropzone {
        BODY,
        RIGHT,
        NONE,
        TOP,
        BOTTOM,
        LEFT;

    }
}

