/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.framework;

import forge.gui.framework.DragCell;
import forge.gui.framework.ICDoc;
import forge.gui.framework.ILocalRepaint;
import forge.gui.framework.IVDoc;
import forge.view.FView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class SOverflowUtil {
    private static final MouseListener MAD_OVERFLOW_SELECT = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            JLabel src = (JLabel)e.getSource();
            DragCell pnlParent = (DragCell)src.getParent().getParent();
            JPanel pnlOverflow = FView.SINGLETON_INSTANCE.getPnlTabOverflow();
            String constraints = "w 150px!, h 20px!, gap 5px 5px 2px 2px";
            int w = 160;
            int h2 = 0;
            pnlOverflow.removeAll();
            for (IVDoc<? extends ICDoc> t2 : pnlParent.getDocs()) {
                if (t2.getTabLabel().isVisible()) continue;
                pnlOverflow.add((Component)new OverflowLabel(t2, pnlParent), "w 150px!, h 20px!, gap 5px 5px 2px 2px");
                h2 += 24;
            }
            pnlOverflow.revalidate();
            pnlOverflow.setVisible(true);
            int x = src.getParent().getParent().getX() + src.getX() + 5;
            int y = src.getParent().getParent().getY() + src.getY() + 5 + src.getHeight() + 3;
            if (x + 160 > FView.SINGLETON_INSTANCE.getPnlContent().getWidth()) {
                x += src.getWidth() - 160;
            }
            pnlOverflow.setBounds(x, y, 160, h2);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ((JLabel)e.getSource()).setBackground(Color.cyan);
            ((JLabel)e.getSource()).repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ((JLabel)e.getSource()).setBackground(Color.black);
            ((JLabel)e.getSource()).repaint();
        }
    };
    private static final MouseListener MAD_HIDE_OVERFLOW = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            JPanel pnl = FView.SINGLETON_INSTANCE.getPnlTabOverflow();
            if (pnl != null) {
                pnl.setVisible(!pnl.isVisible());
            }
        }
    };

    public static MouseListener getOverflowListener() {
        return MAD_OVERFLOW_SELECT;
    }

    public static MouseListener getHideOverflowListener() {
        return MAD_HIDE_OVERFLOW;
    }

    private static class OverflowLabel
    extends JLabel
    implements ILocalRepaint {
        public OverflowLabel(final IVDoc<? extends ICDoc> tab0, final DragCell parent0) {
            super(tab0.getTabLabel().getText());
            this.setOpaque(true);
            this.setBackground(Color.LIGHT_GRAY);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.setBackground(Color.ORANGE);
                    this.repaintSelf();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.setBackground(Color.LIGHT_GRAY);
                    this.repaintSelf();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    FView.SINGLETON_INSTANCE.getPnlTabOverflow().setVisible(false);
                    parent0.setSelected(tab0);
                    parent0.refresh();
                }
            });
        }

        @Override
        public void repaintSelf() {
            Dimension d = this.getSize();
            this.repaint(0, 0, d.width, d.height);
        }
    }
}

