/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.framework;

import forge.Singletons;
import forge.gui.FThreads;
import forge.gui.SOverlayUtils;
import forge.gui.framework.DragCell;
import forge.gui.framework.EDocID;
import forge.gui.framework.FScreen;
import forge.gui.framework.ICDoc;
import forge.gui.framework.IVDoc;
import forge.gui.framework.InvalidLayoutFileException;
import forge.gui.framework.RectangleOfDouble;
import forge.gui.framework.SDisplayUtil;
import forge.gui.framework.SResizingUtil;
import forge.gui.util.SOptionPane;
import forge.localinstance.properties.FileLocation;
import forge.localinstance.properties.ForgeConstants;
import forge.toolbox.FAbsolutePositioner;
import forge.toolbox.SaveOpenDialog;
import forge.util.CollectionSuppliers;
import forge.util.ThreadUtil;
import forge.util.maps.HashMapOfLists;
import forge.util.maps.MapOfLists;
import forge.view.FFrame;
import forge.view.FView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.border.EmptyBorder;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public final class SLayoutIO {
    private static final XMLEventFactory EF = XMLEventFactory.newInstance();
    private static final XMLEvent NEWLINE = EF.createDTD("\n");
    private static final XMLEvent TAB = EF.createDTD("\t");
    private static final AtomicBoolean saveWindowRequested = new AtomicBoolean(false);
    private static final AtomicBoolean saveRequested = new AtomicBoolean(false);

    public static void saveLayout() {
        SaveOpenDialog dlgSave = new SaveOpenDialog();
        FileLocation layoutFile = Singletons.getControl().getCurrentScreen().getLayoutFile();
        File defFile = layoutFile != null ? new File(layoutFile.userPrefLoc) : null;
        File saveFile = dlgSave.SaveDialog(defFile, SaveOpenDialog.Filetypes.LAYOUT);
        if (saveFile != null) {
            SLayoutIO.saveLayout(saveFile);
        }
    }

    public static void openLayout() {
        SOverlayUtils.genericOverlay();
        SaveOpenDialog dlgOpen = new SaveOpenDialog();
        FileLocation layoutFile = Singletons.getControl().getCurrentScreen().getLayoutFile();
        File defFile = layoutFile != null ? new File(layoutFile.userPrefLoc) : null;
        File loadFile = dlgOpen.OpenDialog(defFile, SaveOpenDialog.Filetypes.LAYOUT);
        if (loadFile != null) {
            FView.SINGLETON_INSTANCE.getPnlContent().removeAll();
            FThreads.invokeInEdtLater(() -> {
                SLayoutIO.loadLayout(loadFile);
                SLayoutIO.saveLayout(null);
                SOverlayUtils.hideOverlay();
            });
        }
    }

    public static void revertLayout() {
        SOverlayUtils.genericOverlay();
        FView.SINGLETON_INSTANCE.getPnlContent().removeAll();
        FThreads.invokeInEdtLater(() -> {
            SLayoutIO.loadLayout(null);
            SOverlayUtils.hideOverlay();
        });
    }

    public static void saveWindowLayout() {
        if (saveWindowRequested.getAndSet(true)) {
            return;
        }
        ThreadUtil.delay(500, () -> {
            SLayoutIO.finishSaveWindowLayout();
            saveWindowRequested.set(false);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void finishSaveWindowLayout() {
        FFrame window = FView.SINGLETON_INSTANCE.getFrame();
        if (window.isMinimized()) {
            return;
        }
        Rectangle normalBounds = window.getNormalBounds();
        FileLocation file = ForgeConstants.WINDOW_LAYOUT_FILE;
        String fWriteTo = file.userPrefLoc;
        XMLOutputFactory out = XMLOutputFactory.newInstance();
        XMLEventWriter writer = null;
        try (FileOutputStream fos = new FileOutputStream(fWriteTo);){
            writer = out.createXMLEventWriter(fos);
            writer.add(EF.createStartDocument());
            writer.add(NEWLINE);
            writer.add(EF.createStartElement("", "", "layout"));
            writer.add(EF.createAttribute("x", String.valueOf(normalBounds.x)));
            writer.add(EF.createAttribute("y", String.valueOf(normalBounds.y)));
            writer.add(EF.createAttribute("w", String.valueOf(normalBounds.width)));
            writer.add(EF.createAttribute("h", String.valueOf(normalBounds.height)));
            writer.add(EF.createAttribute("max", window.isMaximized() ? "1" : "0"));
            writer.add(EF.createAttribute("fs", window.isFullScreen() ? "1" : "0"));
            writer.add(EF.createEndElement("", "", "layout"));
            writer.flush();
            writer.add(EF.createEndDocument());
        }
        catch (IOException | XMLStreamException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    public static void loadWindowLayout() {
        FFrame window = FView.SINGLETON_INSTANCE.getFrame();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        FileLocation file = ForgeConstants.WINDOW_LAYOUT_FILE;
        boolean usedCustomPrefsFile = false;
        FileInputStream fis = null;
        try {
            File userSetting = new File(file.userPrefLoc);
            if (userSetting.exists()) {
                usedCustomPrefsFile = true;
                fis = new FileInputStream(userSetting);
            } else {
                fis = new FileInputStream(file.defaultLoc);
            }
            XMLEventReader reader = null;
            try {
                reader = inputFactory.createXMLEventReader(fis);
                while (reader != null && reader.hasNext()) {
                    StartElement element;
                    XMLEvent event = reader.nextEvent();
                    if (!event.isStartElement() || !(element = event.asStartElement()).getName().getLocalPart().equals("layout")) continue;
                    Iterator<Attribute> attributes = element.getAttributes();
                    Dimension minSize = window.getMinimumSize();
                    int x = 0;
                    int y = 0;
                    int w = minSize.width;
                    int h2 = minSize.height;
                    boolean max = false;
                    boolean fs = false;
                    while (attributes.hasNext()) {
                        Attribute attribute = attributes.next();
                        switch (attribute.getName().toString()) {
                            case "x": {
                                x = Integer.parseInt(attribute.getValue());
                                break;
                            }
                            case "y": {
                                y = Integer.parseInt(attribute.getValue());
                                break;
                            }
                            case "w": {
                                w = Integer.parseInt(attribute.getValue());
                                break;
                            }
                            case "h": {
                                h2 = Integer.parseInt(attribute.getValue());
                                break;
                            }
                            case "max": {
                                max = attribute.getValue().equals("1");
                                break;
                            }
                            case "fs": {
                                fs = attribute.getValue().equals("1");
                            }
                        }
                    }
                    int centerX = x + w / 2;
                    int centerY = y + h2 / 2;
                    Rectangle screenBounds = SDisplayUtil.getScreenBoundsForPoint(new Point(centerX, centerY));
                    if (centerX < screenBounds.x) {
                        x = screenBounds.x;
                    } else if (centerX > screenBounds.x + screenBounds.width && (x = screenBounds.x + screenBounds.width - w) < screenBounds.x) {
                        x = screenBounds.x;
                    }
                    if (centerY < screenBounds.y) {
                        y = screenBounds.y;
                    } else if (centerY > screenBounds.y + screenBounds.height && (y = screenBounds.y + screenBounds.height - h2) < screenBounds.y) {
                        y = screenBounds.y;
                    }
                    window.setWindowLayout(x, y, w, h2, max, fs);
                }
            }
            catch (Exception e) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (XMLStreamException x) {
                    e.printStackTrace();
                }
                e.printStackTrace();
                if (usedCustomPrefsFile) {
                    throw new InvalidLayoutFileException();
                }
                throw new RuntimeException(e);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void saveLayout(File f0) {
        if (saveRequested.getAndSet(true)) {
            return;
        }
        ThreadUtil.delay(100, () -> {
            SLayoutIO.save(f0);
            saveRequested.set(false);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void save(File f0) {
        String fWriteTo;
        FileLocation file = Singletons.getControl().getCurrentScreen().getLayoutFile();
        if (f0 == null) {
            if (file == null) {
                return;
            }
            fWriteTo = file.userPrefLoc;
        } else {
            fWriteTo = f0.getPath();
        }
        XMLOutputFactory out = XMLOutputFactory.newInstance();
        XMLEventWriter writer = null;
        try (FileOutputStream fos = new FileOutputStream(fWriteTo);){
            String layoutSerial = SLayoutIO.getLayoutSerial(file.defaultLoc);
            writer = out.createXMLEventWriter(fos);
            List<DragCell> cells = FView.SINGLETON_INSTANCE.getDragCells();
            writer.add(EF.createStartDocument());
            writer.add(NEWLINE);
            writer.add(EF.createStartElement("", "", "layout"));
            writer.add(EF.createAttribute("serial", layoutSerial));
            writer.add(NEWLINE);
            for (DragCell cell : cells) {
                cell.updateRoughBounds();
                RectangleOfDouble bounds = cell.getRoughBounds();
                writer.add(TAB);
                writer.add(EF.createStartElement("", "", "cell"));
                writer.add(EF.createAttribute("x", String.valueOf(Math.rint(bounds.getX() * 100000.0) / 100000.0)));
                writer.add(EF.createAttribute("y", String.valueOf(Math.rint(bounds.getY() * 100000.0) / 100000.0)));
                writer.add(EF.createAttribute("w", String.valueOf(Math.rint(bounds.getW() * 100000.0) / 100000.0)));
                writer.add(EF.createAttribute("h", String.valueOf(Math.rint(bounds.getH() * 100000.0) / 100000.0)));
                if (cell.getSelected() != null) {
                    writer.add(EF.createAttribute("sel", cell.getSelected().getDocumentID().toString()));
                }
                writer.add(NEWLINE);
                for (IVDoc<? extends ICDoc> vDoc : cell.getDocs()) {
                    SLayoutIO.createNode(writer, "doc", vDoc.getDocumentID().toString());
                }
                writer.add(TAB);
                writer.add(EF.createEndElement("", "", "cell"));
                writer.add(NEWLINE);
            }
            writer.flush();
            writer.add(EF.createEndDocument());
        }
        catch (IOException | XMLStreamException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLayoutSerial(String layoutFileName) {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        FileInputStream fis = null;
        XMLEventReader reader = null;
        try {
            fis = new FileInputStream(layoutFileName);
            reader = inputFactory.createXMLEventReader(fis);
            while (null != reader && reader.hasNext()) {
                StartElement element;
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement() || !(element = event.asStartElement()).getName().getLocalPart().equals("layout")) continue;
                Iterator<Attribute> attributes = element.getAttributes();
                while (attributes.hasNext()) {
                    Attribute attribute = attributes.next();
                    String atrName = attribute.getName().toString();
                    if (!atrName.equals("serial")) continue;
                    String string = attribute.getValue();
                    return string;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static void loadLayout(File f) {
        FView view = FView.SINGLETON_INSTANCE;
        String defaultLayoutSerial = "";
        String userLayoutSerial = "";
        boolean resetLayout = false;
        FScreen screen = Singletons.getControl().getCurrentScreen();
        FAbsolutePositioner.SINGLETON_INSTANCE.hideAll();
        view.getPnlInsets().removeAll();
        view.getPnlInsets().setLayout(new BorderLayout());
        view.getPnlInsets().add((Component)view.getPnlContent(), "Center");
        view.getPnlInsets().setBorder(new EmptyBorder(5, 5, 0, 0));
        view.removeAllDragCells();
        FileLocation file = screen.getLayoutFile();
        if (file != null) {
            MapOfLists<LayoutInfo, EDocID> model = null;
            boolean usedCustomPrefsFile = false;
            FileInputStream fis = null;
            try {
                if (f != null && f.exists()) {
                    fis = new FileInputStream(f);
                } else {
                    File userSetting = new File(file.userPrefLoc);
                    if (userSetting.exists()) {
                        defaultLayoutSerial = SLayoutIO.getLayoutSerial(file.defaultLoc);
                        if (defaultLayoutSerial.compareTo(userLayoutSerial = SLayoutIO.getLayoutSerial(file.userPrefLoc)) > 0) {
                            resetLayout = SOptionPane.showConfirmDialog(String.format("Your %s layout file is from an older template.", screen.getTabCaption()), "Reset Layout?", "Reset", "Keep");
                        }
                        if (resetLayout) {
                            screen.deleteLayoutFile();
                            fis = new FileInputStream(file.defaultLoc);
                        } else {
                            fis = new FileInputStream(userSetting);
                            usedCustomPrefsFile = true;
                        }
                    } else {
                        fis = new FileInputStream(file.defaultLoc);
                    }
                }
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                XMLEventReader xer = null;
                try {
                    xer = inputFactory.createXMLEventReader(fis);
                    model = SLayoutIO.readLayout(xer);
                }
                catch (Exception e) {
                    try {
                        if (xer != null) {
                            xer.close();
                        }
                    }
                    catch (XMLStreamException x) {
                        x.printStackTrace();
                    }
                    e.printStackTrace();
                    if (usedCustomPrefsFile) {
                        throw new InvalidLayoutFileException();
                    }
                    throw new RuntimeException(e);
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            for (Map.Entry kv : model.entrySet()) {
                LayoutInfo layoutInfo = (LayoutInfo)kv.getKey();
                DragCell cell = new DragCell();
                cell.setRoughBounds(layoutInfo.getBounds());
                FView.SINGLETON_INSTANCE.addDragCell(cell);
                for (EDocID edoc : (Collection)kv.getValue()) {
                    try {
                        if (edoc.getDoc() == null) continue;
                        cell.addDoc(edoc.getDoc());
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println("Failed to get doc for " + (Object)((Object)edoc));
                    }
                }
                if (layoutInfo.getSelectedId() == null) continue;
                cell.setSelected(layoutInfo.getSelectedId().getDoc());
            }
        }
        SResizingUtil.resizeWindow();
    }

    private static MapOfLists<LayoutInfo, EDocID> readLayout(XMLEventReader reader) throws XMLStreamException {
        EDocID selectedId = null;
        double x0 = 0.0;
        double y0 = 0.0;
        double w0 = 0.0;
        double h0 = 0.0;
        HashMapOfLists<LayoutInfo, EDocID> model = new HashMapOfLists<LayoutInfo, EDocID>(CollectionSuppliers.arrayLists());
        LayoutInfo currentKey = null;
        while (null != reader && reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement()) continue;
            StartElement element = event.asStartElement();
            if (element.getName().getLocalPart().equals("cell")) {
                Iterator<Attribute> attributes = element.getAttributes();
                while (attributes.hasNext()) {
                    Attribute attribute = attributes.next();
                    String atrName = attribute.getName().toString();
                    if (atrName.equals("x")) {
                        x0 = Double.parseDouble(attribute.getValue());
                        continue;
                    }
                    if (atrName.equals("y")) {
                        y0 = Double.parseDouble(attribute.getValue());
                        continue;
                    }
                    if (atrName.equals("w")) {
                        w0 = Double.parseDouble(attribute.getValue());
                        continue;
                    }
                    if (atrName.equals("h")) {
                        h0 = Double.parseDouble(attribute.getValue());
                        continue;
                    }
                    if (!atrName.equals("sel")) continue;
                    selectedId = EDocID.valueOf(attribute.getValue());
                }
                currentKey = new LayoutInfo(new RectangleOfDouble(x0, y0, w0, h0), selectedId);
                continue;
            }
            if (!element.getName().getLocalPart().equals("doc")) continue;
            event = reader.nextEvent();
            model.add(currentKey, EDocID.valueOf(event.asCharacters().getData()));
        }
        return model;
    }

    private static void createNode(XMLEventWriter writer0, String propertyName, String value) throws XMLStreamException {
        writer0.add(TAB);
        writer0.add(TAB);
        writer0.add(EF.createStartElement("", "", propertyName));
        writer0.add(EF.createCharacters(value));
        writer0.add(EF.createEndElement("", "", propertyName));
        writer0.add(NEWLINE);
    }

    private static class LayoutInfo {
        private final RectangleOfDouble bounds;
        private final EDocID selectedId;

        public LayoutInfo(RectangleOfDouble bounds0, EDocID selectedId0) {
            this.bounds = bounds0;
            this.selectedId = selectedId0;
        }

        public RectangleOfDouble getBounds() {
            return this.bounds;
        }

        public EDocID getSelectedId() {
            return this.selectedId;
        }
    }

    private static class Property {
        public static final String x = "x";
        public static final String y = "y";
        public static final String w = "w";
        public static final String h = "h";
        public static final String sel = "sel";
        public static final String doc = "doc";
        public static final String max = "max";
        public static final String fs = "fs";

        private Property() {
        }
    }
}

