/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.framework;

import forge.gui.FThreads;
import forge.gui.framework.DragCell;
import forge.gui.framework.ICDoc;
import forge.gui.framework.IVDoc;
import forge.view.FFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SDisplayUtil {
    private static boolean remindIsRunning = false;
    private static int counter = 0;
    private static int[] newA = null;
    private static int[] newR = null;
    private static int[] newG = null;
    private static int[] newB = null;
    private static Timer timer1 = null;

    public static void remind(IVDoc<? extends ICDoc> tab0) {
        int steps = 5;
        int delay = 80;
        SDisplayUtil.remind(tab0, 5, 80);
    }

    public static void remind(IVDoc<? extends ICDoc> tab0, final int steps, int delay) {
        SDisplayUtil.showTab(tab0);
        final JPanel pnl = tab0.getParentCell().getBody();
        if (remindIsRunning) {
            return;
        }
        if (pnl == null) {
            return;
        }
        remindIsRunning = true;
        final int oldR = pnl.getBackground().getRed();
        final int oldG = pnl.getBackground().getGreen();
        final int oldB = pnl.getBackground().getBlue();
        final int oldA = pnl.getBackground().getAlpha();
        counter = 0;
        newR = new int[steps];
        newG = new int[steps];
        newB = new int[steps];
        newA = new int[steps];
        for (int i = 0; i < steps; ++i) {
            SDisplayUtil.newR[i] = (255 - oldR) / steps * i;
            SDisplayUtil.newG[i] = oldG / steps * i;
            SDisplayUtil.newB[i] = oldB / steps * i;
            SDisplayUtil.newA[i] = (255 - oldA) / steps * i;
        }
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                counter++;
                if (counter != steps - 1) {
                    SwingUtilities.invokeLater(() -> {
                        int r = newR == null ? oldR : newR[counter];
                        int a = newA == null ? oldA : newR[counter];
                        pnl.setBackground(new Color(r, oldG, oldB, a));
                    });
                } else {
                    SwingUtilities.invokeLater(() -> pnl.setBackground(new Color(oldR, oldG, oldB, oldA)));
                    remindIsRunning = false;
                    timer1.cancel();
                    SDisplayUtil.access$302(null);
                    SDisplayUtil.access$402(null);
                    SDisplayUtil.access$502(null);
                    SDisplayUtil.access$602(null);
                }
            }
        };
        timer1 = new Timer();
        timer1.scheduleAtFixedRate(tt, 0L, (long)delay);
    }

    public static void showTab(IVDoc<? extends ICDoc> tab0) {
        Runnable showTabRoutine = () -> {
            Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            DragCell dc = tab0.getParentCell();
            if (dc != null) {
                dc.setSelected(tab0);
            }
            if (null != c) {
                c.requestFocusInWindow();
            }
        };
        if (FThreads.isGuiThread()) {
            FThreads.invokeInEdtNowOrLater(showTabRoutine);
        } else {
            FThreads.invokeInEdtAndWait(showTabRoutine);
        }
    }

    public static GraphicsDevice getGraphicsDevice(Point point) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : env.getScreenDevices()) {
            if (!gd.getDefaultConfiguration().getBounds().contains(point)) continue;
            return gd;
        }
        return null;
    }

    public static GraphicsDevice getGraphicsDevice(Rectangle rect) {
        return SDisplayUtil.getGraphicsDevice(new Point(rect.x + rect.width / 2, rect.y + rect.height / 2));
    }

    public static Rectangle getScreenBoundsForPoint(Point point) {
        GraphicsDevice gd = SDisplayUtil.getGraphicsDevice(point);
        if (gd == null) {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        }
        return gd.getDefaultConfiguration().getBounds();
    }

    public static Rectangle getScreenMaximizedBounds(Rectangle rect) {
        GraphicsDevice gd = SDisplayUtil.getGraphicsDevice(rect);
        if (gd == null) {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        }
        GraphicsConfiguration config = gd.getDefaultConfiguration();
        Rectangle bounds = config.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(config);
        bounds.x += screenInsets.left;
        bounds.y += screenInsets.top;
        bounds.width -= screenInsets.left + screenInsets.right;
        bounds.height -= screenInsets.top + screenInsets.bottom;
        return bounds;
    }

    public static boolean setFullScreenWindow(FFrame frame, boolean fullScreen) {
        return SDisplayUtil.setFullScreenWindow(SDisplayUtil.getGraphicsDevice(frame.getNormalBounds()), frame, fullScreen);
    }

    private static boolean setFullScreenWindow(GraphicsDevice gd, Window window, boolean fullScreen) {
        if (gd != null && gd.isFullScreenSupported()) {
            if (fullScreen) {
                gd.setFullScreenWindow(window);
            } else if (gd.getFullScreenWindow() == window) {
                gd.setFullScreenWindow(null);
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ int[] access$302(int[] x0) {
        newR = x0;
        return x0;
    }

    static /* synthetic */ int[] access$402(int[] x0) {
        newG = x0;
        return x0;
    }

    static /* synthetic */ int[] access$502(int[] x0) {
        newB = x0;
        return x0;
    }

    static /* synthetic */ int[] access$602(int[] x0) {
        newA = x0;
        return x0;
    }
}

