/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.framework;

public class RectangleOfDouble {
    private final double x;
    private final double y;
    private final double w;
    private final double h;

    public RectangleOfDouble(double x0, double y0, double w0, double h0) {
        if (x0 > 1.0) {
            throw new IllegalArgumentException("X value greater than 100%!");
        }
        this.x = x0;
        if (y0 > 1.0) {
            throw new IllegalArgumentException("Y value greater than 100%!");
        }
        this.y = y0;
        if (w0 > 1.0) {
            throw new IllegalArgumentException("W value greater than 100%!");
        }
        this.w = w0;
        if (h0 > 1.0) {
            throw new IllegalArgumentException("H value greater than 100%!");
        }
        this.h = h0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.h);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.w);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RectangleOfDouble other = (RectangleOfDouble)obj;
        if (Double.doubleToLongBits(this.h) != Double.doubleToLongBits(other.h)) {
            return false;
        }
        if (Double.doubleToLongBits(this.w) != Double.doubleToLongBits(other.w)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getW() {
        return this.w;
    }

    public final double getH() {
        return this.h;
    }

    public String toString() {
        return String.format("Rectangle @(%f, %f) sz=(%f, %f)", this.x, this.y, this.w, this.h);
    }
}

