/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.framework;

import forge.Singletons;
import forge.gui.framework.ICDoc;
import forge.gui.framework.IVTopLevelUI;
import forge.localinstance.properties.FileLocation;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.skin.FSkinProp;
import forge.screens.bazaar.CBazaarUI;
import forge.screens.bazaar.VBazaarUI;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.VDeckEditorUI;
import forge.screens.home.CHomeUI;
import forge.screens.home.VHomeUI;
import forge.screens.match.CMatchUI;
import forge.screens.match.VMatchUI;
import forge.screens.workshop.CWorkshopUI;
import forge.screens.workshop.VWorkshopUI;
import forge.toolbox.FOptionPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import forge.view.FView;
import java.io.File;

public class FScreen {
    public static final FScreen HOME_SCREEN = new FScreen(VHomeUI.SINGLETON_INSTANCE, CHomeUI.SINGLETON_INSTANCE, "lblHomeWithSpaces", FSkin.getIcon(FSkinProp.ICO_FAVICON), false, "lblExitForge", null, false);
    public static final FScreen WORKSHOP_SCREEN = new FScreen(VWorkshopUI.SINGLETON_INSTANCE, CWorkshopUI.SINGLETON_INSTANCE, "lblWorkshop", FSkin.getIcon(FSkinProp.ICO_SETTINGS), false, "lblBacktoHome", ForgeConstants.WORKSHOP_LAYOUT_FILE, false);
    public static final FScreen DECK_EDITOR_CONSTRUCTED = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblDeckEditorWithSpaces", FSkin.getImage(FSkinProp.IMG_PACK), false, "lblBacktoHome", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen DECK_EDITOR_ARCHENEMY = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblSchemeDeckEditor", FSkin.getImage(FSkinProp.IMG_PACK), true, "lblCloseEditor", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen DECK_EDITOR_COMMANDER = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblCommanderDeckEditor", FSkin.getImage(FSkinProp.IMG_PACK), true, "lblCloseEditor", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen DECK_EDITOR_TINY_LEADERS = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblTinyLeadersDeckEditor", FSkin.getImage(FSkinProp.IMG_PACK), true, "lblCloseEditor", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen DECK_EDITOR_BRAWL = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblBrawlDeckEditor", FSkin.getImage(FSkinProp.IMG_PACK), true, "lblCloseEditor", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen DECK_EDITOR_OATHBREAKER = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblOathbreakerDeckEditor", FSkin.getImage(FSkinProp.IMG_PACK), true, "lblCloseEditor", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen DECK_EDITOR_PLANECHASE = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblPlanarDeckEditor", FSkin.getImage(FSkinProp.IMG_PACK), true, "lblCloseEditor", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen DECK_EDITOR_DRAFT = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblDraftDeckEditor", FSkin.getImage(FSkinProp.IMG_PACK), true, "lblCloseEditor", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen DECK_EDITOR_SEALED = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblSealedDeckEditor", FSkin.getImage(FSkinProp.IMG_PACK), true, "lblCloseEditor", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen TOKEN_VIEWER = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblTokenViewer", FSkin.getImage(FSkinProp.IMG_PACK), true, "lblCloseViewer", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen DECK_EDITOR_QUEST = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblQuestDeckEditor", FSkin.getImage(FSkinProp.IMG_PACK), true, "lblCloseEditor", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen DECK_EDITOR_QUEST_TOURNAMENT = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblQuestTournamentDeckEditor", FSkin.getImage(FSkinProp.IMG_PACK), true, "lblCloseEditor", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen QUEST_CARD_SHOP = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblSpellShop", FSkin.getIcon(FSkinProp.ICO_QUEST_BOOK), true, "lblLeaveShop", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen DRAFTING_PROCESS = new FScreen(VDeckEditorUI.SINGLETON_INSTANCE, CDeckEditorUI.SINGLETON_INSTANCE, "lblDraft", FSkin.getImage(FSkinProp.IMG_ZONE_HAND), true, "lblLeaveDraft", ForgeConstants.EDITOR_LAYOUT_FILE, false);
    public static final FScreen QUEST_BAZAAR = new FScreen(VBazaarUI.SINGLETON_INSTANCE, CBazaarUI.SINGLETON_INSTANCE, "lblBazaar", FSkin.getIcon(FSkinProp.ICO_QUEST_BOTTLES), true, "lblLeaveBazaar", null, false);
    private final IVTopLevelUI view;
    private final ICDoc controller;
    private String tabCaption;
    private String closeButtonTooltip;
    private final FSkin.SkinImage tabIcon;
    private final boolean allowTabClose;
    private final FileLocation layoutFile;
    private final boolean isMatch;
    private String daytime = null;

    private FScreen(IVTopLevelUI view0, ICDoc controller0, String tabCaption0, FSkin.SkinImage tabIcon0, boolean allowTabClose0, String closeButtonTooltip0, FileLocation layoutFile0, boolean isMatch) {
        this.view = view0;
        this.controller = controller0;
        this.tabCaption = Localizer.getInstance().getMessage(tabCaption0, new Object[0]);
        this.tabIcon = tabIcon0;
        this.allowTabClose = allowTabClose0;
        this.closeButtonTooltip = Localizer.getInstance().getMessage(closeButtonTooltip0, new Object[0]);
        this.layoutFile = layoutFile0;
        this.isMatch = isMatch;
    }

    public static FScreen getMatchScreen(CMatchUI controller, VMatchUI view) {
        return new FScreen(view, controller, "lblGame", FSkin.getIcon(FSkinProp.ICO_ALPHASTRIKE), true, "lblConcedeGame", ForgeConstants.MATCH_LAYOUT_FILE, true);
    }

    public IVTopLevelUI getView() {
        return this.view;
    }

    public ICDoc getController() {
        return this.controller;
    }

    public String getTabCaption() {
        return this.tabCaption;
    }

    public void setTabCaption(String caption) {
        this.tabCaption = caption;
        FView.SINGLETON_INSTANCE.getNavigationBar().updateTitle(this);
    }

    public String getDaytime() {
        return this.daytime;
    }

    public void setDaytime(String daytime) {
        this.daytime = daytime;
    }

    public FSkin.SkinImage getTabIcon() {
        return this.tabIcon;
    }

    public boolean allowTabClose() {
        return this.allowTabClose;
    }

    public String getCloseButtonTooltip() {
        return this.closeButtonTooltip;
    }

    public void setCloseButtonTooltip(String closeButtonTooltip0) {
        this.closeButtonTooltip = closeButtonTooltip0;
    }

    public boolean onSwitching(FScreen toScreen) {
        return this.view.onSwitching(this, toScreen);
    }

    public boolean onClosing() {
        return this.view.onClosing(this);
    }

    public FileLocation getLayoutFile() {
        return this.layoutFile;
    }

    public boolean deleteLayoutFile() {
        if (this.layoutFile == null) {
            return false;
        }
        return FScreen.deleteLayoutFile(this.layoutFile);
    }

    public static boolean deleteMatchLayoutFile() {
        return FScreen.deleteLayoutFile(ForgeConstants.MATCH_LAYOUT_FILE);
    }

    private static boolean deleteLayoutFile(FileLocation file) {
        try {
            File f = new File(file.userPrefLoc);
            f.delete();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            FOptionPane.showErrorDialog(Localizer.getInstance().getMessage("txerrFailedtodeletelayoutfile", new Object[0]));
            return false;
        }
    }

    public void close() {
        Singletons.getView().getNavigationBar().closeTab(this);
    }

    public boolean isMatchScreen() {
        return this.isMatch;
    }
}

