/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.framework;

import com.google.common.collect.Lists;
import forge.gui.framework.DragTab;
import forge.gui.framework.ICDoc;
import forge.gui.framework.ILocalRepaint;
import forge.gui.framework.IVDoc;
import forge.gui.framework.RectangleOfDouble;
import forge.gui.framework.SOverflowUtil;
import forge.gui.framework.SRearrangingUtil;
import forge.gui.framework.SResizingUtil;
import forge.gui.framework.VEmptyDoc;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.toolbox.FPanel;
import forge.toolbox.FSkin;
import forge.view.FView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public final class DragCell
extends JPanel
implements ILocalRepaint {
    private RectangleOfDouble roughSize;
    private int smoothX = 0;
    private int smoothY = 0;
    private int smoothW = 0;
    private int smoothH = 0;
    private final JPanel pnlHead = new JPanel(new MigLayout("insets 0, gap 0, hidemode 3"));
    private final FPanel pnlBody = new FPanel();
    private final JPanel pnlBorderRight = new JPanel();
    private final JPanel pnlBorderBottom = new JPanel();
    private final int tabPaddingPx = 2;
    private final int margin = 4;
    private final List<IVDoc<? extends ICDoc>> allDocs = new ArrayList<IVDoc<? extends ICDoc>>();
    private final JLabel lblHandle = new DragHandle();
    private final JLabel lblOverflow = new JLabel();
    private IVDoc<? extends ICDoc> docSelected = null;

    public DragCell() {
        super(new MigLayout("insets 0, gap 0, wrap 2"));
        this.setOpaque(false);
        this.pnlHead.setOpaque(false);
        this.pnlHead.setBackground(Color.DARK_GRAY);
        this.lblOverflow.setForeground(Color.white);
        this.lblOverflow.setHorizontalAlignment(0);
        this.lblOverflow.setHorizontalTextPosition(0);
        this.lblOverflow.setFont(new Font("Dialog", 0, 10));
        this.lblOverflow.setOpaque(true);
        this.lblOverflow.setBackground(Color.black);
        this.lblOverflow.setToolTipText("Other tabs");
        this.pnlBorderRight.setOpaque(false);
        this.pnlBorderRight.addMouseListener(SResizingUtil.getResizeXListener());
        this.pnlBorderRight.addMouseMotionListener(SResizingUtil.getDragXListener());
        this.pnlBorderBottom.setOpaque(false);
        this.pnlBorderBottom.addMouseListener(SResizingUtil.getResizeYListener());
        this.pnlBorderBottom.addMouseMotionListener(SResizingUtil.getDragYListener());
        this.lblOverflow.addMouseListener(SOverflowUtil.getOverflowListener());
        this.pnlHead.add(this.lblHandle, "pushx, growx, h 100%!, gap 2px 2px 0 0", -1);
        this.pnlHead.add(this.lblOverflow, "w 20px!, h 100%!, gap 2px 2px 0 0", -1);
        this.pnlBody.setCornerDiameter(0);
    }

    public void doCellLayout(boolean showTabs) {
        this.removeAll();
        int borderT = 5;
        int headH = showTabs || this.allDocs.size() > 1 ? 20 : 0;
        this.add((Component)this.pnlHead, "w 100% - 5px!, h " + headH + "px!");
        this.add((Component)this.pnlBorderRight, "w 5px!, h 100% - 5px!, span 1 2");
        this.add((Component)this.pnlBody, "w 100% - 5px!, h 100% - " + (headH + 5) + "px!");
        this.add((Component)this.pnlBorderBottom, "w 100% - 5px!, h 5px!");
        if (this.isShowing()) {
            this.validate();
        }
    }

    private static boolean showGameTabs() {
        ForgePreferences prefs = FModel.getPreferences();
        return !prefs.getPrefBoolean(ForgePreferences.FPref.UI_HIDE_GAME_TABS);
    }

    public JPanel getHead() {
        return this.pnlHead;
    }

    public JPanel getBody() {
        return this.pnlBody;
    }

    public JPanel getBorderRight() {
        return this.pnlBorderRight;
    }

    public JPanel getBorderBottom() {
        return this.pnlBorderBottom;
    }

    public List<IVDoc<? extends ICDoc>> getDocs() {
        return Lists.newArrayList(this.allDocs);
    }

    @Override
    public void repaintSelf() {
        Dimension d = this.getSize();
        this.repaint(0, 0, d.width, d.height);
    }

    public int getW() {
        return this.getWidth();
    }

    public int getH() {
        return this.getHeight();
    }

    public int getAbsX() {
        int i = 0;
        try {
            i = (int)this.getLocationOnScreen().getX();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public int getAbsX2() {
        int i = 0;
        try {
            i = this.getAbsX() + this.getW();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public int getAbsY() {
        int i = 0;
        try {
            i = (int)this.getLocationOnScreen().getY();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public int getAbsY2() {
        int i = 0;
        try {
            i = this.getAbsY() + this.getH();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public void updateRoughBounds() {
        double contentW = FView.SINGLETON_INSTANCE.getPnlContent().getWidth();
        double contentH = FView.SINGLETON_INSTANCE.getPnlContent().getHeight();
        this.roughSize = new RectangleOfDouble((double)this.getX() / contentW, (double)this.getY() / contentH, (double)this.getW() / contentW, (double)this.getH() / contentH);
    }

    public void setRoughBounds(RectangleOfDouble rectangleOfDouble) {
        this.roughSize = rectangleOfDouble;
    }

    public RectangleOfDouble getRoughBounds() {
        return this.roughSize;
    }

    public void setSmoothBounds() {
        super.setBounds(this.smoothX, this.smoothY, this.smoothW, this.smoothH);
    }

    public void setSmoothX(int x0) {
        this.smoothX = x0;
    }

    public void setSmoothY(int y0) {
        this.smoothY = y0;
    }

    public void setSmoothW(int w0) {
        this.smoothW = w0;
    }

    public void setSmoothH(int h0) {
        this.smoothH = h0;
    }

    public void addDoc(IVDoc<? extends ICDoc> doc0) {
        if (doc0 instanceof VEmptyDoc) {
            return;
        }
        this.allDocs.add(doc0);
        doc0.setParentCell(this);
        this.pnlHead.add(doc0.getTabLabel(), "h 100%!, gap 2px 2px 0 0", this.allDocs.size() - 1);
        this.setSelected(this.getSelected());
        this.doCellLayout(DragCell.showGameTabs());
    }

    public void removeDoc(IVDoc<? extends ICDoc> doc0) {
        boolean wasSelected = this.docSelected == doc0;
        this.allDocs.remove(doc0);
        this.pnlHead.remove(doc0.getTabLabel());
        if (wasSelected) {
            this.setSelected(null);
        }
        this.doCellLayout(DragCell.showGameTabs());
    }

    public void setSelected(IVDoc<? extends ICDoc> doc0) {
        if (null != doc0 && this.docSelected == doc0) {
            return;
        }
        this.docSelected = null;
        this.pnlBody.removeAll();
        for (IVDoc<? extends ICDoc> doc : this.allDocs) {
            if (doc.equals(doc0)) {
                this.docSelected = doc0;
                doc.getTabLabel().priorityOne();
                doc.getTabLabel().setSelected(true);
                doc.populate();
                doc.getLayoutControl().update();
                continue;
            }
            doc.getTabLabel().setSelected(false);
            doc.getTabLabel().priorityDecrease();
        }
        this.pnlBody.revalidate();
        this.pnlBody.repaint();
        if (this.docSelected == null && this.allDocs.size() > 0) {
            this.setSelected(this.allDocs.get(0));
        }
    }

    public IVDoc<? extends ICDoc> getSelected() {
        return this.docSelected;
    }

    public void refresh() {
        DragTab selectedTab;
        int headW = this.pnlHead.getWidth();
        if (this.docSelected == null) {
            return;
        }
        if (headW <= 0) {
            return;
        }
        if (this.allDocs.isEmpty()) {
            return;
        }
        ArrayList<DragTab> priority = new ArrayList<DragTab>();
        DragTab nextTab = selectedTab = this.docSelected.getTabLabel();
        while (nextTab != null) {
            priority.add(nextTab);
            nextTab = this.getNextTabInPriority(nextTab.getPriority());
        }
        int tempW = this.lblOverflow.getWidth() + 4 + 8;
        int docOverflowCounter = 0;
        for (DragTab tab : priority) {
            tab.setVisible(false);
            tab.setMaximumSize(null);
            if (tab.equals(selectedTab) || (tempW += tab.getWidth() + 4) < headW) {
                tab.setVisible(true);
                continue;
            }
            ++docOverflowCounter;
        }
        tempW = docOverflowCounter == 0 ? headW - 4 : headW - this.lblOverflow.getWidth() - 4 - 10;
        selectedTab.setMaximumSize(new Dimension(tempW, 20));
        this.lblOverflow.setText("+" + docOverflowCounter);
        if (docOverflowCounter == 0) {
            this.lblOverflow.setVisible(false);
        } else {
            this.lblOverflow.setVisible(true);
        }
    }

    private DragTab getNextTabInPriority(int currentPriority0) {
        DragTab neo = null;
        int lowest = Integer.MAX_VALUE;
        for (IVDoc<? extends ICDoc> d : this.allDocs) {
            DragTab temp = d.getTabLabel();
            if (neo != null && temp.getPriority() == lowest) {
                temp.priorityDecrease();
            }
            if (d.equals(this.docSelected) || temp.getPriority() > lowest || temp.getPriority() <= currentPriority0) continue;
            lowest = temp.getPriority();
            neo = temp;
        }
        return neo;
    }

    private class DragHandle
    extends JLabel {
        private final FSkin.SkinImage img = FSkin.getImage(FSkinProp.IMG_HANDLE);
        private boolean hovered = false;

        public DragHandle() {
            this.addMouseListener(SRearrangingUtil.getRearrangeClickEvent());
            this.addMouseMotionListener(SRearrangingUtil.getRearrangeDragEvent());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    DragHandle.this.hovered = true;
                    DragCell.this.repaintSelf();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    DragHandle.this.hovered = false;
                    DragCell.this.repaintSelf();
                }
            });
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            if (!this.hovered) {
                return;
            }
            Dimension imgSize = this.img.getSizeForPaint(g2);
            int imgW = imgSize.width;
            if (imgW < 1) {
                return;
            }
            int imgH = imgSize.height;
            for (int x = 0; x < this.getWidth(); x += imgW) {
                FSkin.drawImage(g2, this.img, x, (this.getHeight() - imgH) / 2);
            }
        }
    }
}

