/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.error;

import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.util.SOptionPane;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.Localizer;
import io.sentry.Sentry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class BugReporter {
    private static final int STACK_OVERFLOW_MAX_MESSAGE_LEN = 16384;
    public static final String REPORT = Localizer.getInstance().getMessage("lblReport", new Object[0]);
    public static final String SAVE = Localizer.getInstance().getMessage("lblSave", new Object[0]);
    public static final String DISCARD = Localizer.getInstance().getMessage("lblDiscardError", new Object[0]);
    public static final String EXIT = Localizer.getInstance().getMessage("lblExit", new Object[0]);
    public static final String SENTRY = Localizer.getInstance().getMessage("lblAutoSubmitBugReports", new Object[0]);
    private static Throwable exception;
    private static String message;

    public static void reportException(Throwable ex, String message) {
        if (ex == null) {
            return;
        }
        exception = ex;
        if (message != null) {
            System.err.printf("%s > %s%n", FThreads.debugGetCurrThreadId(), message);
        }
        System.err.print(FThreads.debugGetCurrThreadId() + " > ");
        ex.printStackTrace();
        StringBuilder sb = new StringBuilder();
        if (null != message && !message.isEmpty()) {
            Sentry.addBreadcrumb(message);
            sb.append(FThreads.debugGetCurrThreadId()).append(" > ").append(message).append("\n");
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String swStr = sw.toString();
        if (ex instanceof StackOverflowError && swStr.length() >= 16384) {
            sb.append(swStr, 0, 16384);
            sb.append("\n... (truncated)");
        } else {
            sb.append(swStr);
        }
        if (BugReporter.isSentryEnabled()) {
            BugReporter.sendSentry();
        } else {
            GuiBase.getInterface().showBugReportDialog(Localizer.getInstance().getMessage("lblReportCrash", new Object[0]), sb.toString(), true);
        }
    }

    public static boolean isSentryEnabled() {
        return FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.USE_SENTRY);
    }

    public static void reportException(Throwable ex) {
        BugReporter.reportException(ex, null);
    }

    public static void reportException(Throwable ex, String format, Object ... args) {
        BugReporter.reportException(ex, String.format(format, args));
    }

    public static void reportBug(String details) {
        StringBuilder sb = new StringBuilder();
        if (null != details && !details.isEmpty()) {
            sb.append("\n\n");
            sb.append(details);
        }
        message = sb.toString();
        if (BugReporter.isSentryEnabled()) {
            BugReporter.sendSentry();
        } else {
            GuiBase.getInterface().showBugReportDialog(Localizer.getInstance().getMessage("btnReportBug", new Object[0]), message, false);
        }
    }

    public static void saveToFile(String text) {
        String name;
        File f;
        long curTime = System.currentTimeMillis();
        int i = 0;
        while ((f = new File(name = String.format("%TF-%02d.txt", curTime, i))).exists()) {
            ++i;
        }
        f = GuiBase.getInterface().getSaveFile(f);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(f));){
            bw.write(text);
        }
        catch (IOException ex) {
            SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblThereErrorWasDuringSaving", ex), Localizer.getInstance().getMessage("lblErrorSavingFile", new Object[0]), SOptionPane.ERROR_ICON);
        }
    }

    public static void sendSentry() {
        if (exception != null) {
            Sentry.captureException(exception);
        } else if (message != null) {
            Sentry.captureMessage(message);
        }
    }

    private BugReporter() {
    }
}

