/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.download;

import com.esotericsoftware.minlog.Log;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.download.GuiDownloadService;
import forge.gui.interfaces.IProgressBar;
import forge.util.BuildInfo;
import forge.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class GuiDownloadZipService
extends GuiDownloadService {
    private final String name;
    private final String desc;
    private final String sourceUrl;
    private final String destFolder;
    private final String deleteFolder;
    private int filesExtracted;
    private boolean allowDeletion;

    public GuiDownloadZipService(String name0, String desc0, String sourceUrl0, String destFolder0, String deleteFolder0, IProgressBar progressBar0) {
        this(name0, desc0, sourceUrl0, destFolder0, deleteFolder0, progressBar0, true);
    }

    public GuiDownloadZipService(String name0, String desc0, String sourceUrl0, String destFolder0, String deleteFolder0, IProgressBar progressBar0, boolean allowDeletion0) {
        this.name = name0;
        this.desc = desc0;
        this.sourceUrl = sourceUrl0;
        this.destFolder = destFolder0;
        this.deleteFolder = deleteFolder0;
        this.progressBar = progressBar0;
        this.allowDeletion = allowDeletion0;
    }

    @Override
    public String getTitle() {
        return "Download " + this.name;
    }

    @Override
    protected String getStartOverrideDesc() {
        return this.desc;
    }

    @Override
    protected final Map<String, String> getNeededFiles() {
        HashMap<String, String> files = new HashMap<String, String>();
        files.put("_", "_");
        return files;
    }

    @Override
    public final void run() {
        this.downloadAndUnzip();
        if (!this.cancel) {
            FThreads.invokeInEdtNowOrLater(() -> {
                if (this.progressBar != null) {
                    this.progressBar.setDescription(this.filesExtracted + " " + this.desc + " extracted");
                }
                this.finish();
            });
        }
    }

    public void downloadAndUnzip() {
        this.filesExtracted = 0;
        String zipFilename = this.download("temp.zip");
        if (zipFilename == null) {
            return;
        }
        this.extract(zipFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String download(String filename) {
        GuiBase.getInterface().preventSystemSleep(true);
        if (this.progressBar == null) {
            return "";
        }
        this.progressBar.reset();
        this.progressBar.setPercentMode(true);
        this.progressBar.setDescription("Downloading " + this.desc);
        try {
            String string;
            URL url = new URL(this.sourceUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection(this.getProxy());
            if (url.getPath().endsWith(".php")) {
                conn.setRequestProperty("User-Agent", BuildInfo.getUserAgent());
            }
            conn.connect();
            if (conn.getResponseCode() != 200) {
                String string2 = null;
                return string2;
            }
            long contentLength = conn.getContentLength();
            if (contentLength == 0L) {
                String string3 = null;
                return string3;
            }
            this.progressBar.setMaximum(100);
            FileUtil.ensureDirectoryExists(this.destFolder);
            String destFile = this.destFolder + filename;
            try (BufferedInputStream input = new BufferedInputStream(conn.getInputStream(), 8192);
                 OutputStream output = Files.newOutputStream(Paths.get(destFile, new String[0]), new OpenOption[0]);){
                int count;
                long total = 0L;
                byte[] data = new byte[1024];
                while ((count = ((InputStream)input).read(data)) != -1 && !this.cancel) {
                    total += (long)count;
                    if (this.progressBar != null) {
                        this.progressBar.setValue((int)(100L * total / contentLength));
                    }
                    output.write(data, 0, count);
                }
                output.flush();
            }
            if (this.cancel) {
                new File(destFile).delete();
                string = null;
                return string;
            }
            string = destFile;
            return string;
        }
        catch (Exception ex) {
            Log.error("Downloading " + this.desc, "Error downloading " + this.desc, ex);
            String string = null;
            return string;
        }
        finally {
            GuiBase.getInterface().preventSystemSleep(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(String zipFilename) {
        try {
            ZipFile zipFile;
            File deleteDir;
            GuiBase.getInterface().preventSystemSleep(true);
            if (this.deleteFolder != null && this.allowDeletion && (deleteDir = new File(this.deleteFolder)).exists()) {
                if (this.progressBar != null) {
                    this.progressBar.reset();
                    this.progressBar.setDescription("Deleting old " + this.desc + "...");
                }
                if (this.deleteFolder.equals(this.destFolder)) {
                    String oldZipFilename = zipFilename;
                    zipFilename = deleteDir.getParentFile().getAbsolutePath() + File.separator + "temp.zip";
                    com.google.common.io.Files.move(new File(oldZipFilename), new File(zipFilename));
                }
                FileUtil.deleteDirectory(deleteDir);
            }
            Charset charset = Charset.forName("IBM437");
            try {
                zipFile = new ZipFile(zipFilename, charset);
            }
            catch (Throwable e) {
                zipFile = new ZipFile(zipFilename);
            }
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            if (this.progressBar != null) {
                this.progressBar.reset();
                this.progressBar.setPercentMode(true);
                this.progressBar.setDescription("Extracting " + this.desc);
                this.progressBar.setMaximum(zipFile.size());
            }
            FileUtil.ensureDirectoryExists(this.destFolder);
            int count = 0;
            int failedCount = 0;
            while (entries.hasMoreElements() && !this.cancel) {
                try {
                    ZipEntry entry = entries.nextElement();
                    String path = this.destFolder + File.separator + entry.getName();
                    if (entry.isDirectory()) {
                        new File(path).mkdir();
                        if (this.progressBar == null) continue;
                        this.progressBar.setValue(++count);
                        continue;
                    }
                    this.copyInputStream(zipFile.getInputStream(entry), path);
                    if (this.progressBar != null) {
                        this.progressBar.setValue(++count);
                    }
                    ++this.filesExtracted;
                }
                catch (Exception e) {
                    if (this.progressBar != null) {
                        this.progressBar.setValue(++count);
                    }
                    ++failedCount;
                }
            }
            if (failedCount > 0) {
                Log.error("Downloading " + this.desc, failedCount + " " + this.desc + " could not be extracted");
            }
            zipFile.close();
            new File(zipFilename).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            GuiBase.getInterface().preventSystemSleep(false);
        }
    }

    protected void copyInputStream(InputStream in, String outPath) throws IOException {
        byte[] buffer = new byte[1024];
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Paths.get(outPath, new String[0]), new OpenOption[0]));){
            int len;
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
        in.close();
    }
}

