/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.download;

import com.google.common.collect.Iterables;
import forge.StaticData;
import forge.card.CardEdition;
import forge.gui.download.GuiDownloadService;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.util.ImageUtil;
import forge.util.TextUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class GuiDownloadSetPicturesLQ
extends GuiDownloadService {
    @Override
    public String getTitle() {
        return "Download LQ Set Pictures";
    }

    @Override
    protected final Map<String, String> getNeededFiles() {
        TreeMap<String, String> downloads = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        HashMap<String, String> setMapping = new HashMap<String, String>();
        HashSet<String> existingSets = GuiDownloadSetPicturesLQ.retrieveManifestDirectory();
        HashSet<String> missingSets = new HashSet<String>();
        for (PaperCard c : Iterables.concat(FModel.getMagicDb().getCommonCards().getAllCards(), FModel.getMagicDb().getVariantCards().getAllCards())) {
            String setCode3 = c.getEdition();
            if (!setMapping.containsKey(setCode3)) {
                setMapping.put(setCode3, StaticData.instance().getEditions().getCode2ByCode(setCode3));
            }
            String setCode2 = (String)setMapping.get(setCode3);
            if (StringUtils.isBlank(setCode3) || CardEdition.UNKNOWN.getCode().equals(setCode3)) continue;
            if (!existingSets.contains(setCode3) && !existingSets.contains(setCode2)) {
                if (missingSets.contains(setCode3)) continue;
                missingSets.add(setCode3);
                System.out.println(setCode3 + " not found on server. Ignoring downloads for this set.");
                continue;
            }
            GuiDownloadSetPicturesLQ.addDLObject(ImageUtil.getDownloadUrl(c, ""), ImageUtil.getImageKey(c, "", true), downloads);
            if (!c.hasBackFace()) continue;
            GuiDownloadSetPicturesLQ.addDLObject(ImageUtil.getDownloadUrl(c, "back"), ImageUtil.getImageKey(c, "back", true), downloads);
        }
        GuiDownloadSetPicturesLQ.addMissingItems(downloads, ForgeConstants.IMAGE_LIST_TOKENS_FILE, ForgeConstants.CACHE_TOKEN_PICS_DIR);
        return downloads;
    }

    private static void addDLObject(String urlPath, String filename, Map<String, String> downloads) {
        File destFile = new File(ForgeConstants.CACHE_CARD_PICS_DIR, filename + ".jpg");
        String modifier = !filename.contains(".full") ? ".fullborder" : "";
        File fullborder = new File(ForgeConstants.CACHE_CARD_PICS_DIR, TextUtil.fastReplace(filename, ".full", ".fullborder") + modifier + ".jpg");
        if (fullborder.exists()) {
            return;
        }
        if (!destFile.exists()) {
            downloads.put(destFile.getAbsolutePath(), "https://downloads.cardforge.org/images/cards/" + urlPath);
        }
    }
}

