/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.control;

import com.google.common.eventbus.Subscribe;
import forge.game.Game;
import forge.game.card.CardView;
import forge.game.event.GameEvent;
import forge.game.event.GameEventBlockersDeclared;
import forge.game.event.GameEventGameFinished;
import forge.game.event.GameEventGameStarted;
import forge.game.event.GameEventLandPlayed;
import forge.game.event.GameEventPlayerPriority;
import forge.game.event.GameEventSpellAbilityCast;
import forge.game.event.GameEventSpellResolved;
import forge.game.event.GameEventTurnPhase;
import forge.game.event.IGameEventVisitor;
import forge.gamemodes.match.input.InputPlaybackControl;
import forge.gui.FThreads;
import forge.gui.control.PlaybackSpeed;
import forge.player.PlayerControllerHuman;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;

public class FControlGamePlayback
extends IGameEventVisitor.Base<Void> {
    private InputPlaybackControl inputPlayback;
    private final AtomicBoolean paused = new AtomicBoolean(false);
    private final CyclicBarrier gameThreadPauser = new CyclicBarrier(2);
    private final PlayerControllerHuman humanController;
    private Game game;
    public static final int phasesDelay = 200;
    public static final int combatDelay = 400;
    public static final int castDelay = 400;
    public static final int resolveDelay = 400;
    private PlaybackSpeed playbackSpeed = PlaybackSpeed.NORMAL;

    public FControlGamePlayback(PlayerControllerHuman humanController0) {
        this.humanController = humanController0;
    }

    public final PlayerControllerHuman getController() {
        return this.humanController;
    }

    public InputPlaybackControl getInput() {
        return this.inputPlayback;
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game game0) {
        this.game = game0;
        this.inputPlayback = new InputPlaybackControl(this.game, this);
    }

    @Subscribe
    public void receiveGameEvent(GameEvent ev) {
        ev.visit(this);
    }

    private void pauseForEvent(int delay) {
        try {
            Thread.sleep(this.playbackSpeed.applyModifier(delay));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Void visit(GameEventBlockersDeclared event) {
        this.pauseForEvent(400);
        return (Void)super.visit(event);
    }

    @Override
    public Void visit(GameEventTurnPhase ev) {
        try {
            boolean isUiToStop = !this.humanController.getGui().isUiSetToSkipPhase(ev.playerTurn.getView(), ev.phase);
            switch (ev.phase) {
                case COMBAT_END: 
                case COMBAT_DECLARE_ATTACKERS: 
                case COMBAT_DECLARE_BLOCKERS: {
                    if (this.getGame().getPhaseHandler().inCombat()) {
                        this.pauseForEvent(400);
                    }
                    break;
                }
                default: {
                    if (isUiToStop) {
                        this.pauseForEvent(200);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Void visit(GameEventGameFinished event) {
        this.humanController.getInputQueue().removeInput(this.inputPlayback);
        return null;
    }

    @Override
    public Void visit(GameEventGameStarted event) {
        this.humanController.getInputQueue().setInput(this.inputPlayback);
        return null;
    }

    @Override
    public Void visit(GameEventLandPlayed event) {
        this.pauseForEvent(400);
        return (Void)super.visit(event);
    }

    @Override
    public Void visit(GameEventSpellResolved event) {
        FThreads.invokeInEdtNowOrLater(() -> this.humanController.getGui().setCard(CardView.get(event.spell.getHostCard())));
        this.pauseForEvent(400);
        return null;
    }

    @Override
    public Void visit(GameEventSpellAbilityCast event) {
        FThreads.invokeInEdtNowOrLater(() -> this.humanController.getGui().setCard(CardView.get(event.sa.getHostCard())));
        this.pauseForEvent(400);
        return null;
    }

    @Override
    public Void visit(GameEventPlayerPriority event) {
        this.inputPlayback.updateTurnMessage();
        if (this.paused.get()) {
            try {
                this.gameThreadPauser.await();
                this.gameThreadPauser.reset();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void onGameStopRequested() {
        this.paused.set(false);
        if (this.gameThreadPauser.getNumberWaiting() != 0) {
            this.releaseGameThread();
        }
    }

    private void releaseGameThread() {
        this.getGame().getAction().invoke(() -> {
            try {
                this.gameThreadPauser.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                e.printStackTrace();
            }
        });
    }

    public void resume() {
        this.paused.set(false);
        this.releaseGameThread();
    }

    public void pause() {
        this.paused.set(true);
    }

    public void singleStep() {
        this.releaseGameThread();
    }

    public void setSpeed(PlaybackSpeed speed) {
        this.playbackSpeed = speed;
    }
}

