/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.card;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import forge.card.CardType;
import forge.game.ability.AbilityFactory;
import forge.game.ability.ApiType;
import forge.game.replacement.ReplacementType;
import forge.game.trigger.TriggerType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public final class CardScriptParser {
    private final String script;
    private final Set<String> sVars = Sets.newTreeSet();
    private final Set<String> sVarAbilities = Sets.newTreeSet();
    private static final Set<String> DEFINED_CARDS = ImmutableSortedSet.of((Comparable)((Object)"Self"), (Comparable)((Object)"OriginalHost"), (Comparable)((Object)"EffectSource"), (Comparable)((Object)"Equipped"), (Comparable)((Object)"Enchanted"), (Comparable)((Object)"TopOfLibrary"), (Comparable[])new String[]{"BottomOfLibrary", "Targeted", "ThisTargetedCard", "ParentTarget", "Remembered", "DirectRemembered", "DelayTriggerRemembered", "RememberedFirst", "Clones", "Imprinted", "ChosenCard", "SacrificedCards", "Sacrificed", "DiscardedCards", "Discarded", "ExiledCards", "Exiled", "TappedCards", "Tapped", "UntappedCards", "Untapped", "Parent", "SourceFirstSpell"});
    private static final Set<String> DEFINED_CARDS_STARTSWITH = ImmutableSortedSet.of("Triggered", "Replaced", "ThisTurnEntered");
    private static final Set<String> DEFINED_PLAYERS = ImmutableSortedSet.of((Comparable)((Object)"Targeted"), (Comparable)((Object)"TargetedPlayer"), (Comparable)((Object)"ParentTarget"), (Comparable)((Object)"TargetedController"), (Comparable)((Object)"TargetedOwner"), (Comparable)((Object)"TargetedAndYou"), (Comparable[])new String[]{"ParentTargetedController", "Remembered", "DelayTriggerRemembered", "RememberedOpponents", "RememberedController", "RememberedOwner", "ImprintedController", "ImprintedOwner", "EnchantedController", "EnchantedOwner", "EnchantedPlayer", "AttackingPlayer", "DefendingPlayer", "ChosenPlayer", "SourceController", "CardOwner", "ActivePlayer", "You", "Opponent"});
    private static final Set<String> DEFINED_PLAYERS_STARTSWITH = ImmutableSortedSet.of("Triggered", "OppNonTriggered", "Replaced");
    private static final Set<String> VALID_INCLUSIVE = ImmutableSortedSet.of("Spell", "Permanent", "Card");
    private static final Set<String> VALID_EXCLUSIVE = ImmutableSortedSet.of((Comparable)((Object)"sameName"), (Comparable)((Object)"namedCard"), (Comparable)((Object)"NamedByRememberedPlayer"), (Comparable)((Object)"Permanent"), (Comparable)((Object)"ChosenCard"), (Comparable)((Object)"nonChosenCard"), (Comparable[])new String[]{"White", "Blue", "Black", "Red", "Green", "nonWhite", "nonBlue", "nonBlack", "nonRed", "nonGreen", "Colorless", "nonColorless", "Multicolor", "Monocolor", "ChosenColor", "AllChosenColors", "AnyChosenColor", "DoubleFaced", "Flip", "YouCtrl", "YourTeamCtrl", "YouDontCtrl", "OppCtrl", "ChosenCtrl", "DefenderCtrl", "DefenderCtrlForRemembered", "DefendingPlayerCtrl", "EnchantedPlayerCtrl", "EnchantedControllerCtrl", "RememberedPlayer", "RememberedPlayerCtrl", "TargetedPlayerCtrl", "TargetedControllerCtrl", "ActivePlayerCtrl", "YouOwn", "YouDontOwn", "OppOwn", "TargetedPlayerOwn", "OwnerDoesntControl", "Other", "Self", "AttachedBy", "Attached", "NameNotEnchantingEnchantedPlayer", "Enchanted", "CanEnchantRemembered", "CanEnchantSource", "CanBeEnchantedBy", "CanBeEnchantedByTargeted", "CanBeEnchantedByAllRemembered", "EquippedBy", "EquippedByTargeted", "EquippedByEnchanted", "FortifiedBy", "CanBeEquippedBy", "Equipped", "Fortified", "HauntedBy", "notTributed", "madness", "Paired", "PairedWith", "Above", "DirectlyAbove", "TopGraveyardCreature", "BottomGraveyard", "TopLibrary", "BottomLibrary", "Cloned", "DamagedBy", "Damaged", "sharesPermanentTypeWith", "canProduceSameManaTypeWith", "SecondSpellCastThisTurn", "ThisTurnCast", "withFlashback", "tapped", "untapped", "faceDown", "faceUp", "hasLevelUp", "DrawnThisTurn", "firstTurnControlled", "startedTheTurnUntapped", "attackedOrBlockedSinceYourLastUpkeep", "blockedOrBeenBlockedSinceYourLastUpkeep", "dealtDamageToYouThisTurn", "dealtDamageToOppThisTurn", "controllerWasDealtCombatDamageByThisTurn", "controllerWasDealtDamageByThisTurn", "wasDealtDamageThisTurn", "wasDealtDamageByHostThisTurn", "wasDealtDamageByEquipeeThisTurn", "wasDealtDamageByEnchantedThisTurn", "dealtDamageThisTurn", "attackedThisTurn", "attackedLastTurn", "blockedThisTurn", "gotBlockedThisTurn", "notAttackedThisTurn", "greatestPower", "yardGreatestPower", "leastPower", "leastToughness", "greatestCMC", "greatestRememberedCMC", "lowestRememberedCMC", "lowestCMC", "enchanted", "unenchanted", "enchanting", "equipped", "unequipped", "equipping", "modified", "token", "nonToken", "hasXCost", "suspended", "delved", "attacking", "attackingYou", "notattacking", "attackedBySourceThisCombat", "blocking", "blockingSource", "blockingCreatureYouCtrl", "blockingRemembered", "sharesBlockingAssignmentWith", "notblocking", "blocked", "blockedBySource", "blockedThisTurn", "blockedByThisTurn", "blockedBySourceThisTurn", "isBlockedByRemembered", "blockedRemembered", "blockedByRemembered", "unblocked", "attackersBandedWith", "kicked", "kicked1", "kicked2", "evoked", "HasDevoured", "IsMonstrous", "CostsPhyrexianMana", "IsRemembered", "IsNotRemembered", "IsImprinted", "IsNotImprinted", "hasActivatedAbilityWithTapCost", "hasActivatedAbility", "hasManaAbility", "hasNonManaActivatedAbility", "NoAbilities", "HasCounters", "wasNotCast", "ChosenType", "IsNotChosenType", "IsCommander", "IsNotCommander", "IsRenowned"});
    private static final Set<String> VALID_EXCLUSIVE_STARTSWITH = ImmutableSortedSet.of((Comparable)((Object)"named"), (Comparable)((Object)"notnamed"), (Comparable)((Object)"OwnedBy"), (Comparable)((Object)"ControlledBy"), (Comparable)((Object)"ControllerControls"), (Comparable)((Object)"AttachedTo"), (Comparable[])new String[]{"EnchantedBy", "NotEnchantedBy", "TopGraveyard", "SharesColorWith", "MostProminentColor", "notSharesColorWith", "sharesCreatureTypeWith", "sharesCardTypeWith", "sharesLandTypeWith", "sharesNameWith", "doesNotShareNameWith", "sharesControllerWith", "sharesOwnerWith", "ThisTurnEntered", "sharesTypeWith", "hasKeyword", "with", "greatestPowerControlledBy", "greatestCMCControlledBy", "power", "toughness", "cmc", "totalPT", "counters", "non", "RememberMap", "wasCastFrom", "set", "inZone", "HasSVar"});

    public CardScriptParser(String script) {
        String[] lines;
        this.script = script;
        for (String line : lines = StringUtils.split(script, "\r\n")) {
            String[] sVarParts;
            if (StringUtils.isEmpty(line) || !line.startsWith("SVar:") || (sVarParts = StringUtils.split(line, ':')).length != 3) continue;
            this.sVars.add(sVarParts[1]);
        }
    }

    public Map<Integer, Integer> getErrorRegions() {
        return this.getErrorRegions(false);
    }

    private Map<Integer, Integer> getErrorRegions(boolean quick) {
        TreeMap<Integer, Integer> result = Maps.newTreeMap();
        String[] lines = StringUtils.split(this.script, '\n');
        int index = 0;
        for (String line : lines) {
            String trimLine = line.trim();
            if (StringUtils.isEmpty(line)) continue;
            boolean bad = false;
            if (!trimLine.startsWith("Name:") || trimLine.length() <= "Name:".length()) {
                if (trimLine.startsWith("ManaCost:")) {
                    if (!CardScriptParser.isManaCostLegal(trimLine.substring("ManaCost:".length()))) {
                        bad = true;
                    }
                } else if (trimLine.startsWith("Types:")) {
                    if (!CardScriptParser.isTypeLegal(trimLine.substring("Types:".length()))) {
                        bad = true;
                    }
                } else if (trimLine.startsWith("A:")) {
                    result.putAll(this.getActivatedAbilityErrors(trimLine.substring("A:".length()), index + "A:".length()));
                } else if (trimLine.startsWith("R:")) {
                    result.putAll(this.getReplacementErrors(trimLine.substring("R:".length()), index + "R:".length()));
                } else if (!trimLine.startsWith("S:")) {
                    if (trimLine.startsWith("T:")) {
                        result.putAll(this.getTriggerErrors(trimLine.substring("T:".length()), index + "T:".length()));
                    } else if (trimLine.startsWith("SVar:")) {
                        String[] sVarParts = trimLine.split(":", 3);
                        if (sVarParts.length != 3) {
                            bad = true;
                        }
                        if (this.sVarAbilities.contains(sVarParts[1])) {
                            result.putAll(this.getSubAbilityErrors(sVarParts[2], index + "SVar:".length() + 1 + sVarParts[1].length() + 1));
                        }
                    }
                }
            }
            if (bad) {
                result.put(index, trimLine.length());
            }
            index += line.length() + 1;
            if (quick && !result.isEmpty()) break;
        }
        return result;
    }

    private static boolean isManaCostLegal(String manaCost) {
        if (manaCost.equals("no cost")) {
            return true;
        }
        if (StringUtils.isEmpty(manaCost) || StringUtils.isWhitespace(manaCost)) {
            return false;
        }
        for (String part : StringUtils.split(manaCost, ' ')) {
            if (StringUtils.isNumeric(part) || part.equals("X")) continue;
            return CardScriptParser.isManaCostPart(part);
        }
        return true;
    }

    private static boolean isManaCostPart(String part) {
        if (part.length() == 1) {
            return CardScriptParser.isManaSymbol(part.charAt(0));
        }
        if (part.length() == 2) {
            if (!(part.startsWith("P") || part.startsWith("2") || CardScriptParser.isManaSymbol(part.charAt(0)))) {
                return false;
            }
            return CardScriptParser.isManaSymbol(part.charAt(1)) && part.charAt(0) != part.charAt(1);
        }
        return false;
    }

    private static boolean isManaSymbol(char c) {
        return c == 'W' || c == 'U' || c == 'B' || c == 'R' || c == 'G' || c == 'S' || c == 'C';
    }

    private static boolean isTypeLegal(String type) {
        for (String t2 : StringUtils.split(type, ' ')) {
            if (CardScriptParser.isSingleTypeLegal(t2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSingleTypeLegal(String type) {
        return CardType.isACardType(type) || CardType.isASupertype(type) || CardType.isASubType(type);
    }

    private static List<KeyValuePair> getParams(String ability, int offset, Map<Integer, Integer> errorRegions) {
        String[] parts = StringUtils.split(ability, '|');
        ArrayList<KeyValuePair> params = Lists.newArrayList();
        int currentIndex = offset;
        for (String part : parts) {
            String[] subParts = StringUtils.split(part, '$');
            if (subParts.length > 0) {
                params.add(new KeyValuePair(subParts[0], subParts.length > 1 ? subParts[1] : "", currentIndex));
            } else {
                errorRegions.put(currentIndex, part.length());
            }
            currentIndex += part.length() + 1;
        }
        for (KeyValuePair param : params) {
            if (!param.getKey().startsWith(" ") && param.startIndex() != offset) {
                errorRegions.put(param.startIndex() - 1, 2);
            }
            if (!param.getValue().startsWith(" ")) {
                errorRegions.put(param.startIndexValue() - 1, 2);
            }
            if (param.getValue().endsWith(" ") || param.endIndex() == offset + ability.length()) continue;
            errorRegions.put(param.endIndex() - 1, 2);
        }
        return params;
    }

    private Map<Integer, Integer> getActivatedAbilityErrors(String ability, int offset) {
        return this.getAbilityErrors(ability, offset, true);
    }

    private Map<Integer, Integer> getSubAbilityErrors(String ability, int offset) {
        return this.getAbilityErrors(ability, offset, false);
    }

    private Map<Integer, Integer> getAbilityErrors(String ability, int offset, boolean requireCost) {
        TreeMap<Integer, Integer> result = Maps.newTreeMap();
        List<KeyValuePair> params = CardScriptParser.getParams(ability, offset, result);
        if (!CardScriptParser.isAbilityApiDeclarerLegal(params.get(0).getKey())) {
            result.put(params.get(0).startIndex(), params.get(0).length());
        }
        if (requireCost && !params.get(1).getKey().trim().equals("Cost")) {
            result.put(params.get(1).startIndex(), params.get(1).length());
        }
        for (KeyValuePair param : params) {
            boolean isBadValue = false;
            String trimKey = param.getKey().trim();
            String trimValue = param.getValue().trim();
            if (CardScriptParser.isAbilityApiDeclarerLegal(trimKey)) {
                if (!CardScriptParser.isAbilityApiLegal(trimValue)) {
                    isBadValue = true;
                }
            } else if (trimKey.equals("Cost")) {
                if (!CardScriptParser.isCostLegal(trimValue)) {
                    isBadValue = true;
                }
            } else if (trimKey.equals("ValidTgts") || trimKey.equals("ValidCards")) {
                if (!CardScriptParser.isValidLegal(trimValue)) {
                    isBadValue = true;
                }
            } else if (trimKey.equals("Defined")) {
                if (!CardScriptParser.isDefinedLegal(trimValue)) {
                    isBadValue = true;
                }
            } else if (trimKey.equals("TgtPrompt") || trimKey.equals("TargetMin") || trimKey.equals("TargetMax") || trimKey.equals("AILogic") || trimKey.equals("StackDescription") || trimKey.equals("SpellDescription")) {
                if (trimValue.isEmpty()) {
                    isBadValue = true;
                }
            } else if (trimKey.equals("SubAbility") || AbilityFactory.additionalAbilityKeys.contains(trimKey)) {
                if (this.sVars.contains(trimValue)) {
                    this.sVarAbilities.add(trimValue);
                } else {
                    isBadValue = true;
                }
            } else {
                result.put(param.startIndex(), param.keyLength());
            }
            if (!isBadValue) continue;
            result.put(param.startIndexValue(), param.valueLength());
        }
        return result;
    }

    private Map<Integer, Integer> getReplacementErrors(String replacement, int offset) {
        TreeMap<Integer, Integer> result = Maps.newTreeMap();
        List<KeyValuePair> params = CardScriptParser.getParams(replacement, offset, result);
        for (KeyValuePair param : params) {
            boolean isBadValue = false;
            String trimKey = param.getKey().trim();
            String trimValue = param.getValue().trim();
            if (trimKey.equals("Event")) {
                if (!CardScriptParser.isReplacementApiLegal(trimValue)) {
                    isBadValue = true;
                }
            } else if (trimKey.equals("ReplaceWith")) {
                if (this.sVars.contains(trimValue)) {
                    this.sVarAbilities.add(trimValue);
                } else {
                    isBadValue = true;
                }
            } else if (trimKey.equals("Description")) {
                if (trimValue.isEmpty()) {
                    isBadValue = true;
                }
            } else {
                result.put(param.startIndex(), param.keyLength());
            }
            if (!isBadValue) continue;
            result.put(param.startIndexValue(), param.valueLength());
        }
        return result;
    }

    private Map<Integer, Integer> getTriggerErrors(String trigger, int offset) {
        TreeMap<Integer, Integer> result = Maps.newTreeMap();
        List<KeyValuePair> params = CardScriptParser.getParams(trigger, offset, result);
        for (KeyValuePair param : params) {
            boolean isBadValue = false;
            String trimKey = param.getKey().trim();
            String trimValue = param.getValue().trim();
            if (trimKey.equals("Mode")) {
                if (!CardScriptParser.isTriggerApiLegal(trimValue)) {
                    isBadValue = true;
                }
            } else if (trimKey.equals("Cost")) {
                if (!CardScriptParser.isCostLegal(trimValue)) {
                    isBadValue = true;
                }
            } else if (trimKey.equals("Execute")) {
                if (this.sVars.contains(trimValue)) {
                    this.sVarAbilities.add(trimValue);
                } else {
                    isBadValue = true;
                }
            } else if (trimKey.equals("TriggerDescription")) {
                if (trimValue.isEmpty()) {
                    isBadValue = true;
                }
            } else if (trimKey.equals("ValidCard")) {
                if (!CardScriptParser.isValidLegal(trimValue)) {
                    isBadValue = true;
                }
            } else {
                result.put(param.startIndex(), param.keyLength());
            }
            if (!isBadValue) continue;
            result.put(param.startIndexValue(), param.valueLength());
        }
        return result;
    }

    private static boolean isCostLegal(String cost) {
        return CardScriptParser.isManaCostLegal(cost.trim());
    }

    private static boolean isAbilityApiDeclarerLegal(String declarer) {
        String tDeclarer = declarer.trim();
        for (AbilityFactory.AbilityRecordType type : AbilityFactory.AbilityRecordType.values()) {
            if (!type.getPrefix().equals(tDeclarer)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAbilityApiLegal(String api) {
        try {
            return ApiType.smartValueOf(api.trim()) != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static boolean isReplacementApiLegal(String api) {
        try {
            return ReplacementType.smartValueOf(api.trim()) != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static boolean isTriggerApiLegal(String api) {
        try {
            return TriggerType.smartValueOf(api.trim()) != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static Predicate<String> startsWith(String s2) {
        return s2::startsWith;
    }

    private static boolean isDefinedLegal(String defined) {
        return CardScriptParser.isDefinedCardOrSaLegal(defined) || CardScriptParser.isDefinedPlayerLegal(defined);
    }

    private static boolean isDefinedCardOrSaLegal(String defined) {
        if (defined.startsWith("Valid")) {
            return CardScriptParser.isValidLegal(defined.substring("Valid".length()));
        }
        if (DEFINED_CARDS.contains(defined)) {
            return true;
        }
        return Iterables.any(DEFINED_CARDS_STARTSWITH, CardScriptParser.startsWith(defined));
    }

    private static boolean isDefinedPlayerLegal(String defined) {
        boolean non = defined.startsWith("Non");
        boolean flipped = defined.startsWith("Flipped");
        if (non || flipped) {
            String newDefined = null;
            if (non) {
                newDefined = defined.substring("Non".length());
            } else if (flipped) {
                newDefined = defined.substring("Flipped".length());
            }
            return CardScriptParser.isDefinedPlayerLegal(newDefined);
        }
        if (DEFINED_PLAYERS.contains(defined)) {
            return true;
        }
        return Iterables.any(DEFINED_PLAYERS_STARTSWITH, CardScriptParser.startsWith(defined));
    }

    private static boolean isValidLegal(String valid) {
        String[] splitPlus;
        String[] splitDot;
        String remaining = valid;
        if (remaining.charAt(0) == '!') {
            remaining = valid.substring(1);
        }
        if (!VALID_INCLUSIVE.contains((splitDot = remaining.split("\\."))[0]) && !CardScriptParser.isSingleTypeLegal(splitDot[0])) {
            return false;
        }
        if (splitDot.length < 2) {
            return true;
        }
        for (String excl : splitPlus = StringUtils.split(splitDot[1], '+')) {
            if (CardScriptParser.isValidExclusive(excl)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidExclusive(String valid) {
        if (valid.charAt(0) == '!') {
            valid = valid.substring(1);
        }
        if (VALID_EXCLUSIVE.contains(valid)) {
            return true;
        }
        return Iterables.any(VALID_EXCLUSIVE_STARTSWITH, CardScriptParser.startsWith(valid));
    }

    private static final class KeyValuePair {
        private final String key;
        private final String value;
        private final int index;

        private KeyValuePair(String key, String value, int index) {
            this.key = key;
            this.value = value;
            this.index = index;
        }

        private String getKey() {
            return this.key;
        }

        private String getValue() {
            return this.value;
        }

        private int length() {
            return this.keyLength() + 1 + this.valueLength();
        }

        private int keyLength() {
            return this.key.length();
        }

        private int valueLength() {
            return this.value.length();
        }

        private int startIndex() {
            return this.index;
        }

        private int endIndexKey() {
            return this.startIndex() + this.key.length();
        }

        private int startIndexValue() {
            return this.endIndexKey() + 1;
        }

        private int endIndex() {
            return this.startIndex() + this.length();
        }
    }
}

