/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.card;

import com.google.common.collect.Sets;
import forge.card.CardRarity;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.mana.ManaCostShard;
import forge.deck.DeckRecognizer;
import forge.game.GameView;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.card.CounterType;
import forge.game.player.PlayerView;
import forge.game.zone.ZoneType;
import forge.item.InventoryItemFromSet;
import forge.item.PaperCard;
import forge.item.PreconDeck;
import forge.item.SealedProduct;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CardDetailUtil {
    private CardDetailUtil() {
    }

    public static DetailColors getBorderColor(CardView.CardStateView card, boolean canShow) {
        if (card == null) {
            return CardDetailUtil.getBorderColors(null, false, false, false).iterator().next();
        }
        return CardDetailUtil.getBorderColors(card.getColors(), card.isLand(), canShow, false).iterator().next();
    }

    public static List<DetailColors> getBorderColors(CardView.CardStateView card, boolean canShow) {
        if (card == null) {
            return CardDetailUtil.getBorderColors(null, false, false, true);
        }
        return CardDetailUtil.getBorderColors(card.getColors(), card.isLand(), canShow, true);
    }

    public static List<DetailColors> getBorderColors(ColorSet colorSet) {
        return CardDetailUtil.getBorderColors(colorSet, false, true, true);
    }

    private static List<DetailColors> getBorderColors(ColorSet cardColors, boolean isLand, boolean canShow, boolean supportMultiple) {
        ArrayList<DetailColors> borderColors = new ArrayList<DetailColors>();
        if (cardColors == null || !canShow) {
            borderColors.add(DetailColors.FACE_DOWN);
        } else if (cardColors.isColorless()) {
            if (isLand) {
                borderColors.add(DetailColors.LAND);
            } else {
                borderColors.add(DetailColors.COLORLESS);
            }
        } else {
            int colorCount = cardColors.countColors();
            if (colorCount > 3 || colorCount > 1 && !supportMultiple) {
                borderColors.add(DetailColors.MULTICOLOR);
            } else {
                block7: for (ManaCostShard shard : cardColors.getOrderedShards()) {
                    switch (shard.getColorMask()) {
                        case 1: {
                            borderColors.add(DetailColors.WHITE);
                            continue block7;
                        }
                        case 2: {
                            borderColors.add(DetailColors.BLUE);
                            continue block7;
                        }
                        case 4: {
                            borderColors.add(DetailColors.BLACK);
                            continue block7;
                        }
                        case 8: {
                            borderColors.add(DetailColors.RED);
                            continue block7;
                        }
                        case 16: {
                            borderColors.add(DetailColors.GREEN);
                        }
                    }
                }
            }
        }
        if (borderColors.isEmpty()) {
            borderColors.add(DetailColors.UNKNOWN);
        }
        return borderColors;
    }

    public static String getCurrentColors(CardView.CardStateView c) {
        ColorSet curColors = c.getColors();
        String strCurColors = "";
        if (curColors.hasWhite()) {
            strCurColors = strCurColors + "{W}";
        }
        if (curColors.hasBlue()) {
            strCurColors = strCurColors + "{U}";
        }
        if (curColors.hasBlack()) {
            strCurColors = strCurColors + "{B}";
        }
        if (curColors.hasRed()) {
            strCurColors = strCurColors + "{R}";
        }
        if (curColors.hasGreen()) {
            strCurColors = strCurColors + "{G}";
        }
        if (strCurColors.isEmpty()) {
            strCurColors = "{C}";
        }
        return strCurColors;
    }

    public static DetailColors getRarityColor(CardRarity rarity) {
        switch (rarity) {
            case Uncommon: {
                return DetailColors.UNCOMMON;
            }
            case Rare: {
                return DetailColors.RARE;
            }
            case MythicRare: {
                return DetailColors.MYTHIC;
            }
            case Special: {
                return DetailColors.SPECIAL;
            }
        }
        return DetailColors.COMMON;
    }

    public static String getItemDescription(InventoryItemFromSet item) {
        if (item instanceof SealedProduct) {
            return ((SealedProduct)item).getDescription();
        }
        if (item instanceof PreconDeck) {
            return ((PreconDeck)item).getDescription();
        }
        return item.getName();
    }

    public static String formatCardName(CardView card, boolean canShow, boolean forAltState) {
        String name = forAltState ? card.getAlternateState().getName() : card.getName();
        String translatedname = CardTranslation.getTranslatedName(name);
        return StringUtils.isEmpty(translatedname) || !canShow ? "???" : translatedname.trim();
    }

    public static String formatCardType(CardView.CardStateView card, boolean canShow) {
        boolean isInPlay = card.getCard() != null && ZoneType.Battlefield.equals((Object)card.getCard().getZone());
        String translatedtype = CardTranslation.getTranslatedType(card);
        return canShow ? translatedtype : (card.getState() == CardStateName.FaceDown && isInPlay ? "Creature" : "");
    }

    public static String formatPrimaryCharacteristic(CardView.CardStateView card, boolean canShow) {
        if (!canShow && card.getState() != CardStateName.FaceDown) {
            return "";
        }
        StringBuilder ptText = new StringBuilder();
        boolean vehicle = card.getType().hasSubtype("Vehicle");
        if (vehicle && !card.isCreature()) {
            ptText.append("{");
        }
        if (card.isCreature() || vehicle) {
            ptText.append(card.getPower()).append(" / ").append(card.getToughness());
        }
        if (vehicle && !card.isCreature()) {
            ptText.append("}");
        }
        if (card.isPlaneswalker()) {
            if (ptText.length() > 0) {
                ptText.insert(0, "P/T: ");
                ptText.append(" - ").append("Loy: ");
            } else {
                ptText.append(Localizer.getInstance().getMessage("lblLoyalty", new Object[0])).append(": ");
            }
            ptText.append(card.getLoyalty());
        }
        if (card.isBattle()) {
            ptText.append(Localizer.getInstance().getMessage("lblDefense", new Object[0])).append(": ");
            ptText.append(card.getDefense());
        }
        if (card.isAttraction()) {
            ptText.append(Localizer.getInstance().getMessage("lblLights", new Object[0])).append(": ");
            ptText.append(CardDetailUtil.formatAttractionLights(card.getAttractionLights()));
        }
        return ptText.toString();
    }

    public static String formatAttractionLights(Set<Integer> lights) {
        return (lights.contains(1) ? "{AL1ON} " : "{AL1OFF} ") + (lights.contains(2) ? "{AL2ON} " : "{AL2OFF} ") + (lights.contains(3) ? "{AL3ON} " : "{AL3OFF} ") + (lights.contains(4) ? "{AL4ON} " : "{AL4OFF} ") + (lights.contains(5) ? "{AL5ON} " : "{AL5OFF} ") + (lights.contains(6) ? "{AL6ON}" : "{AL6OFF}");
    }

    public static String formatCardId(CardView.CardStateView card) {
        String id = card.getDisplayId();
        return id.isEmpty() ? id : "[" + id + "]";
    }

    public static String formatCurrentCardColors(CardView.CardStateView state) {
        String showCurColorMode = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_DISPLAY_CURRENT_COLORS);
        boolean showCurColors = false;
        String curColors = "";
        if (state.getCard().isImmutable()) {
            return "";
        }
        if (!showCurColorMode.equals("Never")) {
            CardView card = state.getCard();
            boolean isMulticolor = state.getColors().isMulticolor();
            boolean isChanged = false;
            curColors = CardDetailUtil.getCurrentColors(state);
            if (showCurColorMode.equals("Changed") || showCurColorMode.equals("Multi+Changed")) {
                String origIdent = "";
                PaperCard origPaperCard = null;
                Card origCard = null;
                try {
                    if (!card.getName().isEmpty()) {
                        origPaperCard = FModel.getMagicDb().getCommonCards().getCard(card.getName());
                    } else {
                        String altName = card.getAlternateState().getName();
                        if (!altName.isEmpty()) {
                            origPaperCard = FModel.getMagicDb().getCommonCards().getCard(card.getAlternateState().getName());
                        }
                    }
                    if (origPaperCard != null) {
                        origCard = Card.getCardForUi(origPaperCard);
                    }
                    origIdent = origCard != null ? CardDetailUtil.getCurrentColors(origCard.isFaceDown() ? CardView.get(origCard).getState(false) : CardView.get(origCard).getCurrentState()) : "";
                }
                catch (Exception ex) {
                    System.err.println("Unexpected behavior: card " + card.getName() + "[" + card.getId() + "] tripped an exception when trying to process current card colors.");
                }
                boolean bl = isChanged = !curColors.equals(origIdent);
            }
            if (showCurColorMode.equals("Multicolor") && isMulticolor || showCurColorMode.equals("Changed") && isChanged || showCurColorMode.equals("Multi+Changed") && (isChanged || isMulticolor) || showCurColorMode.equals("Always")) {
                showCurColors = true;
            }
        }
        return showCurColors ? curColors : "";
    }

    public static String composeCardText(CardView.CardStateView state, GameView gameView, boolean canShow) {
        String curCardColors;
        String note;
        Map<String, String> notes;
        PlayerView pl;
        int preventNextDamage;
        int n;
        int n2;
        int n3;
        int intensity;
        String regex;
        String text;
        if (!canShow) {
            return "";
        }
        CardView card = state.getCard();
        StringBuilder area = new StringBuilder();
        if (card.isToken()) {
            area.append("Token");
        } else if (card.isTokenCard()) {
            area.append("Token card");
        } else if (card.isEmblem()) {
            area.append("Emblem");
        } else if (card.isBoon()) {
            area.append("Boon");
        } else if (card.isImmutable()) {
            area.append("Effect");
        }
        if (area.length() != 0) {
            area.append("\n");
        }
        boolean needTranslation = true;
        if (card.isToken() && card.getCloneOrigin() == null) {
            needTranslation = false;
        }
        String string = !card.isSplitCard() ? card.getText(state, needTranslation ? CardTranslation.getTranslationTexts(state) : null) : (text = card.getText(state, needTranslation ? CardTranslation.getTranslationTexts(card.getLeftSplitState(), card.getRightSplitState()) : null));
        if (text.contains("LEVEL")) {
            regex = "[0-99]+/[0-99]";
            text = text.replaceAll(regex, "[$0]");
        }
        regex = "LEVEL [0-9]+-[0-9]+ \\[[0-99]+/[0-99]]+ ";
        text = text.replaceAll(regex, "$0\r\n");
        regex = "LEVEL [0-9]+\\+ \\[[0-99]+/[0-99]]+ ";
        text = text.replaceAll(regex, "$0\r\n");
        regex = ",,,";
        text = text.replaceAll(regex, "\r\n");
        regex = "\\., ";
        text = text.replaceAll(regex, ".\r\n");
        area.append(text);
        if (card.isPhasedOut()) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Phased Out");
        }
        Map<String, String> changedColorWords = card.getChangedColorWords();
        Map<String, String> changedTypes = card.getChangedTypes();
        if (changedColorWords != null && changedTypes != null) {
            if (!(changedColorWords.isEmpty() && changedTypes.isEmpty() || area.length() == 0)) {
                area.append("\n");
            }
            for (Map.Entry entry : Sets.union(changedColorWords.entrySet(), changedTypes.entrySet())) {
                area.append("Text changed: all instances of ");
                if (((String)entry.getKey()).equals("Any")) {
                    if (changedColorWords.containsKey(entry.getValue())) {
                        area.append("color words");
                    } else if (CardType.getBasicTypes().contains(entry.getValue())) {
                        area.append("basic land types");
                    } else {
                        area.append("creature types");
                    }
                } else {
                    area.append((String)entry.getKey());
                }
                area.append(" are replaced by ");
                area.append((String)entry.getValue());
                area.append(".\n");
            }
        }
        if ((intensity = card.getIntensity()) > 0) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Intensity: ").append(intensity);
        }
        if (card.getCounters() != null) {
            for (Map.Entry<CounterType, Integer> c : card.getCounters().entrySet()) {
                if (c.getValue() == 0) continue;
                if (area.length() != 0) {
                    area.append("\n");
                }
                area.append(c.getKey().getName()).append(" counters: ");
                area.append(c.getValue());
            }
        }
        if (state.isCreature() && (n3 = card.getDamage()) > 0) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Damage: ").append(n3);
        }
        if ((state.isCreature() || state.isPlaneswalker()) && (n2 = card.getAssignedDamage()) > 0) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Assigned Damage: ").append(n2);
        }
        if ((n = card.getShieldCount()) > 0) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Regeneration Shields: ").append(n);
        }
        if ((preventNextDamage = card.getPreventNextDamage()) > 0) {
            area.append("\n");
            area.append("Prevent the next ").append(preventNextDamage).append(" damage that would be dealt to ");
            area.append(state.getName()).append(" this turn.");
        }
        if (card.getDraftAction() != null) {
            for (String draftAction : card.getDraftAction()) {
                if (area.length() != 0) {
                    area.append("\n");
                }
                area.append(TextUtil.fastReplace(draftAction, "CARDNAME", card.getName()));
            }
        }
        if ((pl = card.getController()) != null && (notes = pl.getDraftNotes()) != null && (note = notes.get(card.getName())) != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Draft Notes: ").append(note);
        }
        if (!card.getChosenType().isEmpty()) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("(chosen type: ");
            area.append(card.getChosenType());
            if (!card.getChosenType2().isEmpty()) {
                area.append(", ").append(card.getChosenType2());
            }
            area.append(")");
        }
        if (card.getNotedTypes() != null && !card.getNotedTypes().isEmpty()) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("(noted type").append(card.getNotedTypes().size() == 1 ? ": " : "s: ");
            area.append(Lang.joinHomogenous(card.getNotedTypes()));
            area.append(")");
        }
        if (card.getChosenColors() != null && !card.getChosenColors().isEmpty()) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("(").append(Localizer.getInstance().getMessage("lblChosenColors", new Object[0])).append(" ");
            area.append(Lang.joinHomogenous(card.getChosenColors().stream().map(DeckRecognizer::getLocalisedMagicColorName).collect(Collectors.toList())));
            area.append(")");
        }
        if (card.getChosenCards() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("(chosen card").append(card.getChosenCards().size() == 1 ? ": " : "s: ");
            area.append(Lang.joinHomogenous(card.getChosenCards())).append(")");
        }
        if (!card.getChosenNumber().isEmpty()) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("(chosen number: ").append(card.getChosenNumber()).append(")");
        }
        if (card.getStoredRolls() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("(stored dice results: ").append(StringUtils.join(card.getStoredRolls(), ", "));
            area.append(")");
        }
        if (card.getChosenPlayer() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("(chosen player: ").append(card.getChosenPlayer()).append(")");
        }
        if (!card.getChosenMode().isEmpty()) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("(chosen mode: ").append(card.getChosenMode()).append(")");
        }
        if (card.getNamedCard() != null && !card.getNamedCard().isEmpty()) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("(named card").append(card.getNamedCard().size() > 1 ? "s" : "").append(": ");
            if (card.isFaceDown() && state.getState() == CardStateName.FaceDown) {
                area.append("Hidden");
            } else {
                area.append(StringUtils.join(card.getNamedCard(), ", "));
            }
            area.append(")");
        }
        if (card.getCurrentRoom() != null && !card.getCurrentRoom().isEmpty()) {
            if (area.length() != 0) {
                area.append("\n\n");
            }
            area.append("(In room: ");
            area.append(card.getCurrentRoom()).append(")");
        }
        if (card.getId() >= 0 && card.getCurrentState().getType().hasStringType("Class") && card.getZone() == ZoneType.Battlefield) {
            if (area.length() != 0) {
                area.append("\n\n");
            }
            area.append("(Class Level:").append(card.getClassLevel()).append(")");
        }
        if (card.getRingLevel() > 0 && card.getZone() == ZoneType.Command) {
            if (area.length() != 0) {
                area.append("\n\n");
            }
            area.append("(Ring Level:").append(card.getRingLevel()).append(")");
        }
        if (card.getSector() != null && !card.getSector().isEmpty()) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Sector: ").append(card.getSector());
        }
        if (card.hasCardAttachments()) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("=Attached: ");
            area.append(StringUtils.join(card.getAttachedCards(), ", "));
            area.append("=");
        }
        if (card.getAttachedTo() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("*Attached to ").append(card.getAttachedTo()).append("*");
        }
        if (card.getEnchantedPlayer() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("*Enchanting ").append(card.getEnchantedPlayer()).append("*");
        }
        if (card.getGainControlTargets() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("+Controlling: ");
            area.append(StringUtils.join(card.getGainControlTargets(), ", "));
            area.append("+");
        }
        if (card.getProtectingPlayer() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Protected by: ").append(card.getProtectingPlayer());
        }
        if (card.getCloneOrigin() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("^Cloned via: ");
            area.append(card.getCloneOrigin().getCurrentState().getName());
            area.append("^");
        }
        if (card.getImprintedCards() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Imprinting: ");
            area.append(StringUtils.join(card.getImprintedCards(), ", "));
        }
        if (card.getExiledCards() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Exiled: ");
            area.append(StringUtils.join(card.getExiledCards(), ", "));
        }
        if (card.getHauntedBy() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Haunted by: ");
            area.append(StringUtils.join(card.getHauntedBy(), ", "));
        }
        if (card.getHaunting() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Haunting ").append(card.getHaunting());
        }
        if (card.getEncodedCards() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Encoded: ").append(card.getEncodedCards());
        }
        if (card.getUntilLeavesBattlefield() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            area.append("Exiled until this leaves the battlefield: ").append(card.getUntilLeavesBattlefield());
        }
        if (card.getMustBlockCards() != null) {
            if (area.length() != 0) {
                area.append("\n");
            }
            String mustBlockThese = Lang.joinHomogenous(card.getMustBlockCards());
            area.append("Must block ").append(mustBlockThese);
        }
        if (card.isExertedThisTurn()) {
            if (area.length() != 0) {
                area.append("\n\n");
            }
            area.append("^Exerted^");
        }
        if (!(curCardColors = CardDetailUtil.formatCurrentCardColors(state)).isEmpty()) {
            if (area.length() != 0) {
                area.append("\n\n");
            }
            area.append("Current Card Colors: ");
            area.append(curCardColors);
        }
        if (state.hasStorm() && gameView != null) {
            if (area.length() != 0) {
                area.append("\n\n");
            }
            area.append("Current Storm Count: ").append(gameView.getStormCount());
        }
        if (card.getOwner() != card.getController()) {
            if (area.length() != 0) {
                area.append("\n\n");
            }
            area.append("Owner: ").append(card.getOwner().toString());
        }
        return area.toString();
    }

    public static enum DetailColors {
        WHITE(254, 253, 244),
        BLUE(90, 146, 202),
        BLACK(32, 34, 31),
        RED(253, 66, 40),
        GREEN(22, 115, 69),
        MULTICOLOR(248, 219, 85),
        COLORLESS(160, 166, 164),
        LAND(190, 153, 112),
        FACE_DOWN(83, 61, 40),
        COMMON(10, 7, 10),
        UNCOMMON(160, 172, 174),
        RARE(193, 170, 100),
        MYTHIC(171, 54, 39),
        SPECIAL(141, 114, 147),
        UNKNOWN(200, 0, 230);

        public final int r;
        public final int g;
        public final int b;

        private DetailColors(int r0, int g0, int b0) {
            this.r = r0;
            this.g = g0;
            this.b = b0;
        }
    }
}

